/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.sleepingbags.items;

import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.extensions.IForgeDimension;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ItemSleepingBag
extends Item {
    public ItemSleepingBag(DyeColor dyeColor) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_200917_a(1));
        this.setRegistryName(new ResourceLocation("sleeping_bags", dyeColor.func_176610_l() + "_sleeping_bag"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
        }
        IForgeDimension.SleepResult sleepResult = worldIn.field_73011_w.canSleepAt(playerIn, playerIn.func_180425_c());
        if (sleepResult.equals((Object)IForgeDimension.SleepResult.DENY) || sleepResult.equals((Object)IForgeDimension.SleepResult.BED_EXPLODES)) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.cant_sleep_here", new Object[0]), true);
            return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
        }
        if (!playerIn.field_70122_E) {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.cant_sleep_in_air", new Object[0]), true);
            return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
        }
        PlayerEntity.SleepResult sleepResult1 = this.trySleep(playerIn);
        if (sleepResult1 != null) {
            playerIn.func_146105_b(sleepResult1.func_221259_a(), true);
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public PlayerEntity.SleepResult trySleep(PlayerEntity player) {
        PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)player, Optional.empty());
        if (ret != null) {
            return ret;
        }
        BlockPos pos = player.func_180425_c();
        if (player.func_70608_bn() || !player.func_70089_S()) {
            return PlayerEntity.SleepResult.OTHER_PROBLEM;
        }
        if (!player.field_70170_p.field_73011_w.func_76569_d()) {
            return PlayerEntity.SleepResult.NOT_POSSIBLE_HERE;
        }
        if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, Optional.empty())) {
            return PlayerEntity.SleepResult.NOT_POSSIBLE_NOW;
        }
        if (!player.func_184812_l_()) {
            double width = 8.0;
            double height = 5.0;
            if (!player.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB((double)pos.func_177958_n() - width, (double)pos.func_177956_o() - height, (double)pos.func_177952_p() - width, (double)pos.func_177958_n() + width, (double)pos.func_177956_o() + height, (double)pos.func_177952_p() + width), monsterEntity -> monsterEntity.func_191990_c(player)).isEmpty()) {
                return PlayerEntity.SleepResult.NOT_SAFE;
            }
        }
        player.func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n));
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        try {
            Method setPose1 = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"setPose", (Class[])new Class[]{Pose.class});
            setPose1.invoke((Object)player, Pose.SLEEPING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        player.func_213369_d(pos);
        player.func_213317_d(Vec3d.field_186680_a);
        player.field_70160_al = true;
        try {
            ObfuscationReflectionHelper.setPrivateValue(PlayerEntity.class, (Object)player, (Object)0, (String)"sleepTimer");
        }
        catch (ObfuscationReflectionHelper.UnableToFindFieldException unableToFindFieldException) {
            // empty catch block
        }
        if (player.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)player.field_70170_p).func_72854_c();
        }
        return null;
    }
}

