/*
 * Decompiled with CFR 0.152.
 */
package com.github.draylar.snowdrift.logic;

import com.github.draylar.snowdrift.Snowdrift;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class SnowIncrementer {
    private static final float MAX_SNOW_TEMP = 0.15f;

    public void tickSnow(class_3218 world, List<class_2791> loadedChunks) {
        loadedChunks.forEach(chunk -> {
            class_1923 chunkPos = chunk.method_12004();
            if (this.canIncrementSnow(world)) {
                class_2338 snowPos = new class_2338(chunkPos.method_8326() + world.field_9229.nextInt(16), 0, chunkPos.method_8328() + world.field_9229.nextInt(16));
                this.tryIncrementSnowAt(world, snowPos);
            }
        });
    }

    private boolean canIncrementSnow(class_3218 world) {
        return world.field_9229.nextInt(Snowdrift.CONFIG.increaseChancePerChunk) == 0;
    }

    private void tryIncrementSnowAt(class_3218 world, class_2338 basePos) {
        class_2338 topPos = world.method_8598(class_2902.class_2903.field_13197, basePos);
        class_2680 topState = world.method_8320(topPos);
        if (world.method_22385().method_22393(topPos).method_21740(topPos) > 0.15f) {
            return;
        }
        if (this.getSnowLevelAt(world, topPos) >= Snowdrift.CONFIG.maxLayers) {
            return;
        }
        if (topState.method_26204().equals(class_2246.field_10477)) {
            int currentLayers = (Integer)topState.method_11654((class_2769)class_2488.field_11518);
            int higherPositionsAroundBlock = 0;
            for (int i : this.getLevelsAround(world, topPos)) {
                if (i < currentLayers) continue;
                ++higherPositionsAroundBlock;
            }
            if (higherPositionsAroundBlock >= Snowdrift.CONFIG.smoothingRequirement && currentLayers < 8) {
                world.method_8501(topPos, (class_2680)topState.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(currentLayers + 1)));
            }
        } else if (topState.method_26215() && class_2246.field_10477.method_9564().method_26184((class_4538)world, topPos)) {
            world.method_8501(topPos, class_2246.field_10477.method_9564());
        }
    }

    private ArrayList<Integer> getLevelsAround(class_3218 world, class_2338 pos) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (class_2350 direction : class_2350.values()) {
            class_2680 offsetState;
            if (direction.method_10166() == class_2350.class_2351.field_11052 || !(offsetState = world.method_8320(pos.method_10093(direction))).method_26204().equals(class_2246.field_10477)) continue;
            int offsetLevel = (Integer)offsetState.method_11654((class_2769)class_2488.field_11518);
            levels.add(offsetLevel);
        }
        return levels;
    }

    private int getSnowLevelAt(class_3218 world, class_2338 pos) {
        int level = 0;
        if (world.method_8320(pos).method_26204().equals(class_2246.field_10477)) {
            while (world.method_8320(pos.method_10087(1)).method_26204().equals(class_2246.field_10477)) {
                pos = pos.method_10087(1);
            }
            while (world.method_8320(pos).method_26204().equals(class_2246.field_10477)) {
                level += ((Integer)world.method_8320(pos).method_11654((class_2769)class_2488.field_11518)).intValue();
                pos = pos.method_10086(1);
            }
        }
        return level;
    }
}

