/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.init.StatueBlocks;
import com.shynieke.statues.recipes.StatueLootList;
import com.shynieke.statues.tiles.StatueTile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BabyZombieStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)8.5, (double)9.5);

    public BabyZombieStatueBlock(AbstractBlock.Properties builder) {
        super(builder.func_200947_a(SoundType.field_185851_d));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.isDecorative(state)) {
            BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
            if (blockState.func_177230_c() == Blocks.field_150368_y) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)pos.func_177977_b().func_177958_n(), (double)pos.func_177977_b().func_177956_o(), (double)pos.func_177977_b().func_177952_p(), 0.0, 0.0, 0.0);
                worldIn.func_175656_a(pos.func_177977_b(), (BlockState)StatueBlocks.flood_statue.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()));
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187915_go, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if (blockState.func_177230_c() == StatueBlocks.chicken_statue && this.isDecorative(blockState)) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)pos.func_177977_b().func_177958_n(), (double)pos.func_177977_b().func_177956_o(), (double)pos.func_177977_b().func_177952_p(), 0.0, 0.0, 0.0);
                worldIn.func_175656_a(pos.func_177977_b(), (BlockState)StatueBlocks.chicken_jockey_statue.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()));
                worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187915_go, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean isDecorative(BlockState state) {
        return (Boolean)state.func_177229_b((Property)INTERACTIVE) == false;
    }

    @Override
    public void executeStatueBehavior(StatueTile tile, BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult result) {
        tile.playSound(SoundEvents.field_187899_gZ, pos, (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f + 1.5f);
        tile.giveItem(StatueLootList.getLootInfo(this.getLootName()).getLoot(), playerIn);
    }

    @Override
    public boolean isBaby() {
        return true;
    }

    @Override
    public String getLootName() {
        return "baby_zombie";
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.field_200725_aD;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }
}

