/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.SheepStatueBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.init.StatueBlocks;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DropHandler {
    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        ItemStack itemStackToDrop;
        Entity entity = event.getEntity();
        Entity source = event.getSource().func_76346_g();
        DropHandler.addSombrero(entity, source, event);
        if (entity instanceof VillagerEntity) {
            switch (entity.field_70170_p.field_73012_v.nextInt(4)) {
                default: {
                    this.DropLootStatues(entity, new ItemStack((IItemProvider)StatueBlocks.villager_br_statue), source, event);
                    break;
                }
                case 1: {
                    this.DropLootStatues(entity, new ItemStack((IItemProvider)StatueBlocks.villager_wh_statue), source, event);
                    break;
                }
                case 2: {
                    this.DropLootStatues(entity, new ItemStack((IItemProvider)StatueBlocks.villager_pu_statue), source, event);
                    break;
                }
                case 3: {
                    this.DropLootStatues(entity, new ItemStack((IItemProvider)StatueBlocks.villager_gr_statue), source, event);
                    break;
                }
            }
        } else if (entity instanceof EvokerEntity || entity instanceof VindicatorEntity || entity instanceof VexEntity) {
            if (entity instanceof EvokerEntity) {
                ItemStack itemStackToDrop2 = new ItemStack((IItemProvider)StatueBlocks.evoker_statue);
                this.DropLootStatues(entity, itemStackToDrop2, source, event);
            }
            ItemStack itemStackToDrop2 = new ItemStack((IItemProvider)StatueBlocks.totem_of_undying_statue);
            this.DropLootStatues(entity, itemStackToDrop2, source, event);
        } else if (entity instanceof SheepEntity) {
            SheepEntity sheep = (SheepEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueBlocks.sheep_shaven_statue);
            if (!sheep.func_70892_o()) {
                itemStackToDrop = new ItemStack((IItemProvider)SheepStatueBlock.getStatue(sheep.func_175509_cj()));
            }
            this.DropLootStatues(entity, itemStackToDrop, source, event);
        } else if (entity instanceof BeeEntity) {
            BeeEntity bee = (BeeEntity)entity;
            itemStackToDrop = new ItemStack((IItemProvider)StatueBlocks.bee_statue);
            if (entity.field_70170_p.field_73012_v.nextBoolean()) {
                itemStackToDrop = new ItemStack((IItemProvider)StatueBlocks.angry_bee_statue);
            }
            String trans = "Trans Bee";
            if (bee.func_145748_c_().func_150261_e().equalsIgnoreCase(trans)) {
                itemStackToDrop = new ItemStack((IItemProvider)StatueBlocks.bee_statue);
                itemStackToDrop.func_200302_a((ITextComponent)new StringTextComponent(trans));
            }
            this.DropLootStatues(entity, itemStackToDrop, source, event);
        } else {
            for (Block block : StatueBlocks.BLOCKS) {
                AbstractStatueBase statue;
                if (!(block instanceof AbstractStatueBase) || !(statue = (AbstractStatueBase)block).getEntity().equals((Object)entity.func_200600_R()) || statue.isHiddenStatue()) continue;
                ItemStack itemStackToDrop3 = new ItemStack((IItemProvider)block);
                if (entity instanceof MobEntity) {
                    if (((MobEntity)entity).func_70631_g_() != statue.isBaby()) continue;
                    this.DropLootStatues(entity, itemStackToDrop3, source, event);
                    continue;
                }
                this.DropLootStatues(entity, itemStackToDrop3, source, event);
            }
        }
        if (((Boolean)StatuesConfig.COMMON.playerDropsStatue.get()).booleanValue() && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ItemStack playerStatueStack = new ItemStack((IItemProvider)StatueBlocks.player_statue).func_200302_a(player.func_200200_C_());
            double random_drop = Math.random();
            double playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get();
            BlockPos entityPos = entity.func_233580_cy_();
            switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.playerStatueKillSource.get())) {
                default: {
                    if (!(source instanceof PlayerEntity) || source instanceof FakePlayer) break;
                    ServerPlayerEntity sourcePlayer = (ServerPlayerEntity)source;
                    List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                    if (!luckyPlayers.isEmpty()) {
                        for (String luckyName : luckyPlayers) {
                            String user = sourcePlayer.func_200200_C_().func_150261_e();
                            if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                            playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get() / 4.0;
                        }
                    }
                    if (!(random_drop < playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), playerStatueStack));
                    break;
                }
                case PLAYER_FAKEPLAYER: {
                    if (!(source instanceof PlayerEntity) || !(random_drop < playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), playerStatueStack));
                    break;
                }
                case ALL: {
                    if (!(random_drop < playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), playerStatueStack));
                }
            }
        }
    }

    public void DropLootStatues(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        double random_drop = Math.random();
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        BlockPos entityPos = entity.func_233580_cy_();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof PlayerEntity) || source instanceof FakePlayer) break;
                ServerPlayerEntity player = (ServerPlayerEntity)source;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.func_200200_C_().func_150261_e();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!(random_drop < default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof PlayerEntity) || !(random_drop < default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
                break;
            }
            case ALL: {
                if (!(random_drop < default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), itemStackToDrop));
            }
        }
    }

    public static void addSombrero(Entity entity, Entity source, LivingDropsEvent event) {
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        BlockPos entityPos = entity.func_233580_cy_();
        Biome biome = entity.field_70170_p.func_226691_t_(entity.func_233580_cy_());
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                double random_drop;
                if (!(source instanceof PlayerEntity) || source instanceof FakePlayer) break;
                ServerPlayerEntity player = (ServerPlayerEntity)source;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.func_200200_C_().func_150261_e();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!((random_drop = Math.random()) < default_drop_chance) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) break;
                ItemStack sombreroStack = new ItemStack((IItemProvider)StatueBlocks.sombrero);
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), sombreroStack));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                double random_drop;
                if (!(source instanceof PlayerEntity) || !((random_drop = Math.random()) < default_drop_chance) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) break;
                ItemStack sombreroStack = new ItemStack((IItemProvider)StatueBlocks.sombrero);
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), sombreroStack));
                break;
            }
            case ALL: {
                double random_drop = Math.random();
                if (!(random_drop < default_drop_chance) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) break;
                ItemStack sombreroStack = new ItemStack((IItemProvider)StatueBlocks.sombrero);
                event.getDrops().add(new ItemEntity(entity.field_70170_p, (double)entityPos.func_177958_n(), (double)entityPos.func_177956_o(), (double)entityPos.func_177952_p(), sombreroStack));
            }
        }
    }
}

