/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles;

import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public abstract class AbstractStatueTile
extends TileEntity
implements ITickableTileEntity {
    public int cooldown = 0;
    public int cooldownMax = 200;
    public boolean statueAble = false;
    private int mobKilled;
    private int statueLevel;
    private boolean dropsItems;
    private float dropMultiplier;
    private boolean spawnsMobs;
    private boolean makesSounds;
    private boolean hasExternalUse;

    protected AbstractStatueTile(TileEntityType<?> tileType) {
        super(tileType);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.cooldown = compound.func_74762_e("StatueCooldown");
        this.cooldownMax = compound.func_74762_e("StatueMaxcooldown");
        this.statueAble = compound.func_74767_n("StatueAble");
        this.loadFromNbt(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("StatueCooldown", this.cooldown);
        compound.func_74768_a("StatueMaxcooldown", this.cooldownMax);
        compound.func_74757_a("StatueAble", this.statueAble);
        return this.saveToNbt(compound);
    }

    public void func_73660_a() {
        if (!this.statueAble) {
            ++this.cooldown;
            this.func_70296_d();
            if (this.cooldown >= this.cooldownMax) {
                this.cooldown = 0;
                this.setStatueAble(true);
            }
        }
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getCooldownMax() {
        return this.cooldownMax;
    }

    public int getStatueLevel() {
        return this.statueLevel;
    }

    public float getDropMultiplier() {
        return this.dropMultiplier;
    }

    public boolean isStatueAble() {
        return this.statueAble;
    }

    public void setStatueAble(boolean statueAble) {
        this.statueAble = statueAble;
        this.func_70296_d();
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.mobKilled = compound.func_74762_e("mobKilled");
        this.statueLevel = compound.func_74762_e("statueLevel");
        this.dropsItems = compound.func_74767_n("dropsItems");
        this.spawnsMobs = compound.func_74767_n("spawnsMobs");
        this.makesSounds = compound.func_74767_n("makesSounds");
        this.hasExternalUse = compound.func_74767_n("hasExternalUse");
        this.dropMultiplier = compound.func_74760_g("dropMultiplier");
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        this.saveAllTraits(compound);
        return compound;
    }

    public CompoundNBT saveAllTraits(CompoundNBT tag) {
        ListNBT listnbt = new ListNBT();
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74768_a("mobKilled", this.mobKilled);
        compoundnbt.func_74768_a("statueLevel", this.statueLevel);
        compoundnbt.func_74757_a("dropsItems", this.dropsItems);
        compoundnbt.func_74757_a("spawnsMobs", this.spawnsMobs);
        compoundnbt.func_74757_a("makesSounds", this.makesSounds);
        compoundnbt.func_74757_a("hasExternalUse", this.hasExternalUse);
        compoundnbt.func_74776_a("dropMultiplier", this.dropMultiplier);
        listnbt.add((Object)compoundnbt);
        if (!listnbt.isEmpty()) {
            tag.func_218657_a("Traits", (INBT)listnbt);
        }
        return tag;
    }

    public boolean isDecorative() {
        return !this.dropsItems && !this.spawnsMobs && !this.makesSounds && !this.hasExternalUse;
    }

    public boolean canDropItems() {
        return this.dropsItems;
    }

    public boolean canSpawnMobs() {
        return this.spawnsMobs;
    }

    public boolean makesSounds() {
        return this.makesSounds;
    }

    public boolean hasExternalUse() {
        return this.hasExternalUse;
    }
}

