/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.tiles;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.init.StatueBlocks;
import com.shynieke.statues.init.StatueTiles;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PlayerTile
extends TileEntity
implements INameable,
ITickableTileEntity {
    private static PlayerProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    private String BlockName = "";
    private GameProfile playerProfile;
    private Boolean comparatorApplied = false;
    private Boolean OnlineChecking = false;
    private int checkerCooldown = 0;

    public PlayerTile() {
        super(StatueTiles.PLAYER);
    }

    public PlayerTile(String name) {
        this();
        this.BlockName = name;
    }

    public static void setProfileCache(PlayerProfileCache profileCacheIn) {
        profileCache = profileCacheIn;
    }

    public static void setSessionService(MinecraftSessionService sessionServiceIn) {
        sessionService = sessionServiceIn;
    }

    public String setName(String name) {
        this.BlockName = name;
        return this.BlockName;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.BlockName = compound.func_74779_i("PlayerName");
        if (compound.func_150297_b("PlayerProfile", 10)) {
            this.setPlayerProfile(NBTUtil.func_152459_a((CompoundNBT)compound.func_74775_l("PlayerProfile")));
        }
        this.comparatorApplied = compound.func_74767_n("comparatorApplied");
        this.OnlineChecking = compound.func_74767_n("OnlineChecking");
        this.checkerCooldown = compound.func_74762_e("checkerCooldown");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("PlayerName", this.BlockName);
        if (this.playerProfile != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)this.playerProfile);
            compound.func_218657_a("PlayerProfile", (INBT)compoundnbt);
        }
        compound.func_74757_a("comparatorApplied", this.comparatorApplied.booleanValue());
        compound.func_74757_a("OnlineChecking", this.OnlineChecking.booleanValue());
        compound.func_74768_a("checkerCooldown", this.checkerCooldown);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 4, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_145818_k_() {
        return this.BlockName != null && !this.BlockName.isEmpty();
    }

    @Nullable
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    public void setPlayerProfile(@Nullable GameProfile profile) {
        this.playerProfile = profile;
        this.updatePlayerProfile();
    }

    private void updatePlayerProfile() {
        this.playerProfile = PlayerTile.updateGameProfile(this.playerProfile);
        this.func_70296_d();
    }

    public static GameProfile updateGameProfile(GameProfile input) {
        if (input != null && !StringUtils.func_151246_b((String)input.getName())) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            if (profileCache != null && sessionService != null) {
                GameProfile gameprofile = profileCache.func_152655_a(input.getName());
                if (gameprofile == null) {
                    return input;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                }
                return gameprofile;
            }
            return input;
        }
        return input;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() == StatueBlocks.player_statue && this.comparatorApplied.booleanValue()) {
            boolean isStateOnline = (Boolean)state.func_177229_b((net.minecraft.state.Property)PlayerStatueBlock.ONLINE);
            if (!this.OnlineChecking.booleanValue()) {
                ++this.checkerCooldown;
                this.func_70296_d();
                if (this.checkerCooldown == 0) {
                    this.checkerCooldown = 200;
                }
                if (this.checkerCooldown >= 200) {
                    this.checkerCooldown = 0;
                    this.setOnlineChecking(true);
                }
            } else {
                boolean checkAnswer = this.field_145850_b.func_217371_b(this.playerProfile.getId()) != null;
                BlockState newState = (BlockState)state.func_206870_a((net.minecraft.state.Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(checkAnswer));
                if (isStateOnline != checkAnswer) {
                    this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((net.minecraft.state.Property)PlayerStatueBlock.ONLINE, (Comparable)Boolean.valueOf(checkAnswer)), 5);
                    this.field_145850_b.func_184138_a(this.func_174877_v(), state, newState, 5);
                }
                this.setOnlineChecking(false);
            }
        }
    }

    public void setComparatorApplied(Boolean comparatorApplied) {
        this.comparatorApplied = comparatorApplied;
        this.func_70296_d();
    }

    public Boolean getComparatorApplied() {
        return this.comparatorApplied;
    }

    public int getCooldown() {
        return this.checkerCooldown;
    }

    public void setOnlineChecking(boolean onlineChecking) {
        this.OnlineChecking = onlineChecking;
        this.func_70296_d();
    }

    public ITextComponent func_200200_C_() {
        return this.func_145818_k_() ? new StringTextComponent(this.BlockName) : new TranslationTextComponent("statue.player");
    }

    public ITextComponent func_200201_e() {
        return null;
    }
}

