/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import vswe.stevesfactory.blocks.BlockCableCamouflages;
import vswe.stevesfactory.blocks.BlockCamouflageBase;
import vswe.stevesfactory.init.ModBlocks;
import vswe.stevesfactory.tiles.TileEntityCluster;

public class BlockCableCluster
extends BlockCamouflageBase {
    public static final IProperty FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final IProperty ADVANCED = PropertyBool.func_177716_a((String)"advanced");

    public BlockCableCluster() {
        super(Material.field_151573_f);
        this.func_149647_a(ModBlocks.creativeTab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(2.0f);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{ADVANCED, FACING};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{BlockCableCamouflages.BLOCK_POS};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ADVANCED, (Comparable)Boolean.valueOf(this.isAdvanced(meta))).func_177226_a(FACING, (Comparable)this.getSide(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.addAdvancedMeta(((EnumFacing)state.func_177229_b(FACING)).func_176745_a(), (Boolean)state.func_177229_b(ADVANCED) != false ? 8 : 0);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityCluster tileEntity = (TileEntityCluster)world.func_175625_s(pos);
        if (state instanceof IExtendedBlockState && tileEntity != null) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)BlockCableCamouflages.BLOCK_POS, (Object)pos);
        }
        return state;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        if (this.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            ModBlocks.blockCable.updateInventories((IBlockAccess)world, pos);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack itemStack = this.getItemStack((IBlockAccess)world, pos, world.func_180495_p(pos));
        if (itemStack != null) {
            return itemStack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    private ItemStack getItemStack(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCluster) {
            TileEntityCluster cluster = (TileEntityCluster)te;
            ItemStack itemStack = new ItemStack((Block)ModBlocks.blockCableCluster, 1, this.func_180651_a(state));
            NBTTagCompound compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
            NBTTagCompound cable = new NBTTagCompound();
            compound.func_74782_a("Cable", (NBTBase)cable);
            cable.func_74773_a("Types", cluster.getTypes());
            return itemStack;
        }
        return null;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        drop.add(this.getItemStack(world, pos, state));
        return drop;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCluster();
    }

    private TileEntityCluster getTe(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCluster) {
            return (TileEntityCluster)te;
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        int meta = this.addAdvancedMeta(BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)entity).func_176745_a(), itemStack.func_77952_i());
        world.func_180501_a(pos, state.func_177230_c().func_176203_a(meta), 2);
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, pos);
        if (cluster != null) {
            cluster.loadElements(itemStack);
            cluster.onBlockPlacedBy(world, pos, state, entity, itemStack);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (cluster != null) {
            cluster.onNeighborBlockChange((IBlockAccess)world, pos, state, block);
        }
        if (this.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            ModBlocks.blockCable.updateInventories((IBlockAccess)world, pos);
        }
        super.func_189540_a(state, world, pos, blockIn);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntityCluster cluster = this.getTe(world, pos);
        IBlockState state = world.func_180495_p(pos);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (cluster != null) {
            cluster.onNeighborBlockChange(world, pos, state, block);
        }
        if (this.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            ModBlocks.blockCable.updateInventories(world, pos);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(world, pos);
        if (cluster != null) {
            return cluster.canConnectRedstone(state, world, pos, side);
        }
        return false;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, pos);
        if (cluster != null) {
            cluster.onBlockAdded(world, pos, state);
        }
        if (this.isAdvanced(state.func_177230_c().func_176201_c(state))) {
            ModBlocks.blockCable.updateInventories((IBlockAccess)world, pos);
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(world, pos);
        if (cluster != null) {
            return cluster.shouldCheckWeakPower(state, world, pos, side);
        }
        return false;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(world, pos);
        if (cluster != null) {
            return cluster.isProvidingWeakPower(state, world, pos, side);
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityCluster cluster = this.getTe(blockAccess, pos);
        if (cluster != null) {
            return cluster.isProvidingStrongPower(state, blockAccess, pos, side);
        }
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityCluster cluster = this.getTe((IBlockAccess)world, pos);
        if (cluster != null) {
            return cluster.onBlockActivated(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 8));
    }

    public boolean isAdvanced(int meta) {
        return (meta & 8) != 0;
    }

    public int getSideMeta(int meta) {
        return meta & 7;
    }

    public EnumFacing getSide(int meta) {
        return EnumFacing.func_82600_a((int)this.getSideMeta(meta));
    }

    private int addAdvancedMeta(int meta, int advancedMeta) {
        return meta | advancedMeta & 8;
    }

    private int getAdvancedMeta(int meta) {
        return this.addAdvancedMeta(0, meta);
    }

    public int func_180651_a(IBlockState state) {
        return this.getAdvancedMeta(state.func_177230_c().func_176201_c(state));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return true;
    }
}

