/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.blocks.IRedstoneNode;
import vswe.stevesfactory.tiles.TileEntityBUD;
import vswe.stevesfactory.tiles.TileEntityCamouflage;
import vswe.stevesfactory.tiles.TileEntityInput;
import vswe.stevesfactory.tiles.TileEntityOutput;
import vswe.stevesfactory.tiles.TileEntitySignUpdater;

public enum ConnectionBlockType {
    INVENTORY(Localization.TYPE_INVENTORY, null, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, false),
    TANK(Localization.TYPE_TANK, null, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, false),
    EMITTER(Localization.TYPE_EMITTER, TileEntityOutput.class, null, false),
    RECEIVER(Localization.TYPE_RECEIVER, TileEntityInput.class, null, false),
    NODE(Localization.TYPE_NODE, IRedstoneNode.class, null, true),
    BUD(Localization.TYPE_BUD, TileEntityBUD.class, null, false),
    CAMOUFLAGE(Localization.TYPE_CAMOUFLAGE, TileEntityCamouflage.class, null, false),
    SIGN(Localization.TYPE_SIGN, TileEntitySignUpdater.class, null, false);

    private Localization name;
    private Class clazz;
    private Capability capability;
    private boolean group;

    private ConnectionBlockType(@Nullable Localization name, Class clazz, Capability capability, boolean group) {
        this.name = name;
        this.clazz = clazz;
        this.capability = capability;
        this.group = group;
    }

    public boolean isInstance(TileEntity tileEntity) {
        if (this.clazz != null && this.clazz.isInstance(tileEntity)) {
            return true;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.capability == null || tileEntity == null || !tileEntity.hasCapability(this.capability, facing)) continue;
            return true;
        }
        return false;
    }

    public <T> T getObject(TileEntity tileEntity) {
        return (T)tileEntity;
    }

    public boolean isGroup() {
        return this.group;
    }

    public Localization getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }
}

