/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks.client;

import com.google.common.base.Function;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.util.vector.Vector3f;
import vswe.stevesfactory.blocks.BlockCableCamouflages;
import vswe.stevesfactory.blocks.BlockCableCluster;
import vswe.stevesfactory.blocks.client.CamouflageBlockModel;
import vswe.stevesfactory.tiles.TileEntityCamouflage;
import vswe.stevesfactory.tiles.TileEntityCluster;

public class BakedCamouflageBlockModel
implements IBakedModel {
    private VertexFormat format;
    private TextureAtlasSprite normalSprite;
    private TextureAtlasSprite insideSprite;
    private TextureAtlasSprite transformSprite;
    private TextureAtlasSprite clusterFront;
    private TextureAtlasSprite clusterSide;
    private TextureAtlasSprite clusterFrontAdv;
    private TextureAtlasSprite clusterSideAdv;
    private FaceBakery bakery;
    private Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private IModelState modelState;

    public BakedCamouflageBlockModel(IModelState modelState, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, boolean isCamouflage) {
        this.format = format;
        this.bakedTextureGetter = bakedTextureGetter;
        this.modelState = modelState;
        this.normalSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)CamouflageBlockModel.NORMAL);
        this.insideSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)CamouflageBlockModel.INSIDE);
        this.transformSprite = (TextureAtlasSprite)bakedTextureGetter.apply((Object)CamouflageBlockModel.TRANSFORM);
        if (!isCamouflage) {
            this.clusterFront = (TextureAtlasSprite)bakedTextureGetter.apply((Object)CamouflageBlockModel.CL_FRONT);
            this.clusterSide = (TextureAtlasSprite)bakedTextureGetter.apply((Object)CamouflageBlockModel.CL_SIDE);
            this.clusterFrontAdv = (TextureAtlasSprite)bakedTextureGetter.apply((Object)CamouflageBlockModel.CL_ADV_FRONT);
            this.clusterSideAdv = (TextureAtlasSprite)bakedTextureGetter.apply((Object)CamouflageBlockModel.CL_ADV_SIDE);
        }
        this.bakery = new FaceBakery();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        IExtendedBlockState blockState;
        Object obj;
        if (state instanceof IExtendedBlockState && (obj = (blockState = (IExtendedBlockState)state).getValue((IUnlistedProperty)BlockCableCamouflages.BLOCK_POS)) != null) {
            BlockPos pos = (BlockPos)obj;
            BlockRendererDispatcher dispatcher = FMLClientHandler.instance().getClient().func_175602_ab();
            BlockModelShapes modelShapes = dispatcher.func_175023_a();
            TileEntity tileEntity = FMLClientHandler.instance().getWorldClient().func_175625_s(pos);
            TileEntityCamouflage camouflage = null;
            TileEntityCluster cluster = null;
            if (tileEntity instanceof TileEntityCluster) {
                cluster = (TileEntityCluster)tileEntity;
                camouflage = (TileEntityCamouflage)TileEntityCluster.getTileEntity(TileEntityCamouflage.class, (IBlockAccess)FMLClientHandler.instance().getWorldClient(), pos);
                BlockCableCluster blockCluster = (BlockCableCluster)cluster.func_145838_q();
                if (camouflage == null) {
                    IModel clusterModel = null;
                    try {
                        clusterModel = ModelLoaderRegistry.getModel((ResourceLocation)(blockCluster.isAdvanced(cluster.func_145832_p()) ? CamouflageBlockModel.MODEL_CLUSTER_ADV : CamouflageBlockModel.MODEL_CLUSTER));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (clusterModel != null) {
                        return clusterModel.bake(this.modelState, this.format, this.bakedTextureGetter).func_188616_a(state, side, rand);
                    }
                }
            } else if (tileEntity instanceof TileEntityCamouflage) {
                camouflage = (TileEntityCamouflage)tileEntity;
            }
            return new AssembledBakedModel(camouflage, pos, blockState, modelShapes, cluster, this.format).func_188616_a(state, side, rand);
        }
        return new AssembledBakedModel().func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.normalSprite;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public class AssembledBakedModel
    implements IBakedModel {
        private List<BakedQuad> quads = new LinkedList<BakedQuad>();
        private VertexFormat format;

        public AssembledBakedModel(TileEntityCamouflage camouflage, BlockPos pos, IExtendedBlockState blockState, BlockModelShapes modelShapes, TileEntityCluster cluster, VertexFormat format) {
            this.format = format;
            if (camouflage != null && this.quads.isEmpty()) {
                for (EnumFacing facing : EnumFacing.values()) {
                    Block block = Block.func_149729_e((int)camouflage.getId(facing.func_176745_a()));
                    Block insideBlock = Block.func_149729_e((int)camouflage.getId(facing.func_176745_a() + EnumFacing.values().length));
                    this.generateQuads(block, pos, blockState, modelShapes, camouflage, facing, false, cluster);
                    if (!camouflage.getCamouflageType().useDoubleRendering()) continue;
                    this.generateQuads(insideBlock, pos, blockState, modelShapes, camouflage, facing, true, cluster);
                }
            }
        }

        public AssembledBakedModel() {
        }

        public void generateQuads(Block block, BlockPos pos, IExtendedBlockState blockState, BlockModelShapes modelShapes, TileEntityCamouflage camouflage, EnumFacing facing, boolean inside, TileEntityCluster cluster) {
            if (block instanceof BlockAir || block instanceof BlockCableCamouflages || block instanceof BlockCableCluster) {
                if (cluster == null) {
                    TileEntityCamouflage.CamouflageType camoType = (TileEntityCamouflage.CamouflageType)((Object)blockState.func_177229_b(BlockCableCamouflages.CAMO_TYPE));
                    this.quads.add(this.getTransformedQuad(blockState, pos, blockState.func_177230_c(), facing, camoType.getIcon(), camoType == TileEntityCamouflage.CamouflageType.NORMAL && !inside ? BakedCamouflageBlockModel.this.normalSprite : (camoType == TileEntityCamouflage.CamouflageType.INSIDE ? BakedCamouflageBlockModel.this.insideSprite : BakedCamouflageBlockModel.this.transformSprite), inside, 0));
                } else {
                    BlockCableCluster blockCluster = (BlockCableCluster)cluster.func_145838_q();
                    int clusterMeta = cluster.func_145832_p();
                    EnumFacing clusterFacing = blockCluster.getSide(clusterMeta);
                    boolean isFacingFront = camouflage != null && camouflage.getCamouflageType().useSpecialShape() && inside || camouflage == null && inside ? facing == clusterFacing.func_176734_d() : facing == clusterFacing;
                    boolean isAdvanced = blockCluster.isAdvanced(clusterMeta);
                    String resource = (isAdvanced ? (isFacingFront ? CamouflageBlockModel.CL_ADV_FRONT : CamouflageBlockModel.CL_ADV_SIDE) : (isFacingFront ? CamouflageBlockModel.CL_FRONT : CamouflageBlockModel.CL_SIDE)).toString();
                    TextureAtlasSprite texture = isAdvanced ? (isFacingFront ? BakedCamouflageBlockModel.this.clusterFrontAdv : BakedCamouflageBlockModel.this.clusterSideAdv) : (isFacingFront ? BakedCamouflageBlockModel.this.clusterFront : BakedCamouflageBlockModel.this.clusterSide);
                    this.quads.add(this.getTransformedQuad(blockState, pos, blockState.func_177230_c(), facing, resource, texture, inside, 0));
                }
            } else {
                IBlockState camoState = block.func_176203_a(camouflage.getMeta(facing.func_176745_a() + (inside ? EnumFacing.values().length : 0)));
                IBakedModel model = modelShapes.func_178125_b(camoState);
                List bakedQuads = model.func_188616_a(camoState, facing, 0L);
                LinkedList<BakedQuad> reBakedQuads = new LinkedList<BakedQuad>();
                for (BakedQuad quad : bakedQuads) {
                    if (quad.func_178210_d() != facing) continue;
                    if (camouflage.getCamouflageType().useDoubleRendering()) {
                        quad = this.reBakeQuadForBlock(quad, blockState, pos, blockState.func_177230_c(), facing, quad.func_187508_a(), inside, camouflage.rotate);
                    }
                    reBakedQuads.add(quad);
                }
                this.quads.addAll(reBakedQuads);
            }
        }

        private BakedQuad getTransformedQuad(IExtendedBlockState blockState, BlockPos pos, Block block, EnumFacing facing, String resource, TextureAtlasSprite sprite, boolean inside, int rotation) {
            AxisAlignedBB alignedBB = block.func_185496_a((IBlockState)blockState, (IBlockAccess)FMLClientHandler.instance().getWorldClient(), pos);
            float maxX = (float)alignedBB.field_72336_d * 16.0f;
            float maxY = (float)alignedBB.field_72337_e * 16.0f;
            float maxZ = (float)alignedBB.field_72334_f * 16.0f;
            float minX = (float)alignedBB.field_72340_a * 16.0f;
            float minY = (float)alignedBB.field_72338_b * 16.0f;
            float minZ = (float)alignedBB.field_72339_c * 16.0f;
            BlockFaceUV faceUV = null;
            float f = 0.002f;
            if (inside) {
                float temp = maxY;
                maxY = 16.0f - minY;
                minY = 16.0f - temp;
                temp = maxZ;
                maxZ = 16.0f - minZ;
                minZ = 16.0f - temp;
            }
            switch (facing) {
                case DOWN: {
                    if (!inside) {
                        faceUV = new BlockFaceUV(new float[]{16.0f - minX, 16.0f - maxZ, 16.0f - maxX, 16.0f - minZ}, 0);
                        break;
                    }
                    faceUV = new BlockFaceUV(new float[]{16.0f - minX, 16.0f - minZ, 16.0f - maxX, 16.0f - maxZ}, 0);
                    maxY = minY + f;
                    break;
                }
                case UP: {
                    if (!inside) {
                        faceUV = new BlockFaceUV(new float[]{minX, minZ, maxX, maxZ}, 0);
                        break;
                    }
                    faceUV = new BlockFaceUV(new float[]{minX, maxZ, maxX, minZ}, 0);
                    minY = maxY - f;
                    break;
                }
                case NORTH: {
                    if (!inside) {
                        faceUV = new BlockFaceUV(new float[]{16.0f - maxX, 16.0f - maxY, 16.0f - minX, 16.0f - minY}, 0);
                        break;
                    }
                    faceUV = new BlockFaceUV(new float[]{16.0f - minX, maxY, 16.0f - maxX, minY}, 0);
                    maxZ = minZ + f;
                    break;
                }
                case SOUTH: {
                    if (!inside) {
                        faceUV = new BlockFaceUV(new float[]{minX, 16.0f - maxY, maxX, 16.0f - minY}, 0);
                        break;
                    }
                    faceUV = new BlockFaceUV(new float[]{maxX, maxY, minX, minY}, 0);
                    minZ = maxZ - f;
                    break;
                }
                case WEST: {
                    if (!inside) {
                        faceUV = new BlockFaceUV(new float[]{minZ, 16.0f - maxY, maxZ, 16.0f - minY}, 0);
                        break;
                    }
                    faceUV = new BlockFaceUV(new float[]{maxZ, maxY, minZ, minY}, 0);
                    maxX = minX + f;
                    break;
                }
                case EAST: {
                    if (!inside) {
                        faceUV = new BlockFaceUV(new float[]{16.0f - maxZ, 16.0f - maxY, 16.0f - minZ, 16.0f - minY}, 0);
                        break;
                    }
                    faceUV = new BlockFaceUV(new float[]{16.0f - minZ, maxY, 16.0f - maxZ, minY}, 0);
                    minX = maxX - f;
                }
            }
            ModelRotation modelRotation = inside ? ModelRotation.func_177524_a((int)180, (int)(rotation * 90)) : ModelRotation.func_177524_a((int)0, (int)(rotation * 90));
            return BakedCamouflageBlockModel.this.bakery.func_178414_a(new Vector3f(minX, minY, minZ), new Vector3f(maxX, maxY, maxZ), new BlockPartFace(facing, -1, resource == null ? "" : resource, faceUV), sprite, inside ? facing.func_176734_d() : facing, modelRotation, null, false, true);
        }

        private BakedQuad reBakeQuadForBlock(BakedQuad original, IExtendedBlockState blockState, BlockPos pos, Block block, EnumFacing facing, TextureAtlasSprite sprite, boolean inside, int rotation) {
            BakedQuad transformedQuad = this.getTransformedQuad(blockState, pos, block, facing, null, sprite, inside, rotation);
            int[] transformedFaceData = transformedQuad.func_178209_a();
            int tintIndex = original.func_178211_c();
            EnumFacing face = original.func_178210_d();
            int[] faceData = (int[])original.func_178209_a().clone();
            for (int i = 0; i < 4; ++i) {
                int storeIndex = i * 7;
                float[] d = new float[3];
                for (int j = 0; j < 3; ++j) {
                    d[j] = Float.intBitsToFloat(faceData[storeIndex + j]) * 16.0f - Float.intBitsToFloat(transformedFaceData[storeIndex + j]) * 16.0f;
                }
                faceData[storeIndex] = transformedFaceData[storeIndex];
                faceData[storeIndex + 1] = transformedFaceData[storeIndex + 1];
                faceData[storeIndex + 2] = transformedFaceData[storeIndex + 2];
                faceData[storeIndex + 4] = transformedFaceData[storeIndex + 4];
                faceData[storeIndex + 5] = transformedFaceData[storeIndex + 5];
            }
            return new BakedQuad(faceData, tintIndex, face, sprite, true, this.format);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            LinkedList<BakedQuad> allFaceQuads = new LinkedList<BakedQuad>();
            if (side != null) {
                for (BakedQuad quad : this.quads) {
                    if (FaceBakery.func_178410_a((int[])quad.func_178209_a()) != side) continue;
                    allFaceQuads.add(quad);
                }
            } else {
                return new LinkedList<BakedQuad>(this.quads);
            }
            return allFaceQuads;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return BakedCamouflageBlockModel.this.normalSprite;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return null;
        }
    }
}

