/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenuFluid;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;

public class FluidSetting
extends Setting {
    private Fluid fluid;
    private int amount;
    private static final String NBT_FLUID_NAME = "FluidName";
    private static final String NBT_FLUID_AMOUNT = "Amount";

    public FluidSetting(int id) {
        super(id);
    }

    @Override
    public void clear() {
        super.clear();
        this.fluid = null;
        this.setDefaultAmount();
    }

    @Override
    public List<String> getMouseOver() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.fluid == null) {
            ret.add(Localization.NO_FLUID_SELECTED.toString());
        } else {
            ret.add(ComponentMenuFluid.getDisplayName(this.fluid));
        }
        ret.add("");
        ret.add(Localization.CHANGE_FLUID.toString());
        if (this.fluid != null) {
            ret.add(Localization.EDIT_SETTING.toString());
        }
        return ret;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(int val) {
        this.amount = val;
    }

    @Override
    public boolean isValid() {
        return this.fluid != null;
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeString(this.fluid.getName(), DataBitHelper.MENU_FLUID_ID_LENGTH);
    }

    @Override
    public void readData(DataReader dr) {
        this.fluid = FluidRegistry.getFluid((String)dr.readString(DataBitHelper.MENU_FLUID_ID_LENGTH));
    }

    @Override
    public void copyFrom(Setting setting) {
        this.fluid = ((FluidSetting)setting).fluid;
    }

    @Override
    public int getDefaultAmount() {
        return 1000;
    }

    @Override
    public void load(NBTTagCompound settingTag) {
        this.fluid = FluidRegistry.getFluid((String)settingTag.func_74779_i(NBT_FLUID_NAME));
        this.amount = settingTag.func_74762_e(NBT_FLUID_AMOUNT);
    }

    @Override
    public void save(NBTTagCompound settingTag) {
        settingTag.func_74778_a(NBT_FLUID_NAME, this.fluid.getName());
        settingTag.func_74768_a(NBT_FLUID_AMOUNT, this.amount);
    }

    @Override
    public boolean isContentEqual(Setting otherSetting) {
        return this.fluid.getName().equals(((FluidSetting)otherSetting).fluid.getName());
    }

    @Override
    public void setContent(Object obj) {
        this.fluid = (Fluid)obj;
        this.setDefaultAmount();
    }

    public String getFluidName() {
        return this.fluid.getName();
    }

    public void setFluidFromName(String name) {
        this.fluid = FluidRegistry.getFluid((String)name);
    }

    public Fluid getFluid() {
        return this.fluid;
    }
}

