/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevesfactory.ItemUtils;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenuItem;
import vswe.stevesfactory.components.FuzzyMode;
import vswe.stevesfactory.components.ModItemHelper;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;

public class ItemSetting
extends Setting {
    private FuzzyMode fuzzyMode;
    private ItemStack item;
    private static final String NBT_SETTING_ITEM_ID = "ItemId";
    private static final String NBT_SETTING_ITEM_DMG = "ItemDamage";
    private static final String NBT_SETTING_FUZZY_OLD = "Fuzzy";
    private static final String NBT_SETTING_FUZZY = "FuzzyMode";
    private static final String NBT_SETTING_ITEM_COUNT = "ItemCount";
    private static final String NBT_TAG = "tag";

    public ItemSetting(int id) {
        super(id);
    }

    @Override
    public List<String> getMouseOver() {
        if (this.item != null && GuiScreen.func_146272_n()) {
            return ComponentMenuItem.getToolTip(this.item);
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (this.item == null) {
            ret.add(Localization.NO_ITEM_SELECTED.toString());
        } else {
            ret.add(ComponentMenuItem.getDisplayName(this.item));
        }
        ret.add("");
        ret.add(Localization.CHANGE_ITEM.toString());
        if (this.item != null) {
            ret.add(Localization.EDIT_SETTING.toString());
            ret.add(Localization.FULL_DESCRIPTION.toString());
        }
        return ret;
    }

    @Override
    public void clear() {
        super.clear();
        this.fuzzyMode = FuzzyMode.PRECISE;
        this.item = null;
    }

    @Override
    public int getAmount() {
        return this.item == null ? 0 : this.item.field_77994_a;
    }

    @Override
    public void setAmount(int val) {
        if (this.item != null) {
            this.item.field_77994_a = val;
        }
    }

    @Override
    public boolean isValid() {
        return this.item != null;
    }

    public FuzzyMode getFuzzyMode() {
        return this.fuzzyMode;
    }

    public void setFuzzyMode(FuzzyMode fuzzy) {
        this.fuzzyMode = fuzzy;
    }

    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void writeData(DataWriter dw) {
        dw.writeData(Item.func_150891_b((Item)this.item.func_77973_b()), DataBitHelper.MENU_ITEM_ID);
        dw.writeData(this.fuzzyMode.ordinal(), DataBitHelper.FUZZY_MODE);
        dw.writeData(this.item.func_77952_i(), DataBitHelper.MENU_ITEM_META);
        dw.writeNBT(this.item.func_77978_p());
    }

    @Override
    public void readData(DataReader dr) {
        int id = dr.readData(DataBitHelper.MENU_ITEM_ID);
        this.fuzzyMode = FuzzyMode.values()[dr.readData(DataBitHelper.FUZZY_MODE)];
        int meta = dr.readData(DataBitHelper.MENU_ITEM_META);
        this.item = new ItemStack(Item.func_150899_d((int)id), 1, meta);
        this.item.func_77982_d(dr.readNBT());
    }

    @Override
    public void copyFrom(Setting setting) {
        this.item = ((ItemSetting)setting).getItem().func_77946_l();
        this.fuzzyMode = ((ItemSetting)setting).fuzzyMode;
    }

    @Override
    public int getDefaultAmount() {
        return 1;
    }

    @Override
    public void load(NBTTagCompound settingTag) {
        this.item = new ItemStack(Item.func_150899_d((int)settingTag.func_74765_d(NBT_SETTING_ITEM_ID)), (int)settingTag.func_74765_d(NBT_SETTING_ITEM_COUNT), (int)settingTag.func_74765_d(NBT_SETTING_ITEM_DMG));
        this.fuzzyMode = settingTag.func_74764_b(NBT_SETTING_FUZZY_OLD) ? (settingTag.func_74767_n(NBT_SETTING_FUZZY_OLD) ? FuzzyMode.FUZZY : FuzzyMode.PRECISE) : FuzzyMode.values()[settingTag.func_74771_c(NBT_SETTING_FUZZY)];
        if (settingTag.func_74764_b(NBT_TAG)) {
            this.item.func_77982_d(settingTag.func_74775_l(NBT_TAG));
        } else {
            this.item.func_77982_d(null);
        }
    }

    @Override
    public void save(NBTTagCompound settingTag) {
        settingTag.func_74777_a(NBT_SETTING_ITEM_ID, (short)Item.func_150891_b((Item)this.item.func_77973_b()));
        settingTag.func_74777_a(NBT_SETTING_ITEM_COUNT, (short)this.item.field_77994_a);
        settingTag.func_74777_a(NBT_SETTING_ITEM_DMG, (short)this.item.func_77952_i());
        settingTag.func_74774_a(NBT_SETTING_FUZZY, (byte)this.fuzzyMode.ordinal());
        if (this.item.func_77978_p() != null) {
            settingTag.func_74782_a(NBT_TAG, (NBTBase)this.item.func_77978_p());
        }
    }

    @Override
    public boolean isContentEqual(Setting otherSetting) {
        return Item.func_150891_b((Item)this.item.func_77973_b()) == Item.func_150891_b((Item)((ItemSetting)otherSetting).item.func_77973_b()) && ItemStack.func_77970_a((ItemStack)this.item, (ItemStack)((ItemSetting)otherSetting).item);
    }

    @Override
    public void setContent(Object obj) {
        this.item = ((ItemStack)obj).func_77946_l();
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public boolean isEqualForCommandExecutor(ItemStack other) {
        if (!this.isValid() || other == null) {
            return false;
        }
        switch (this.fuzzyMode) {
            case ORE_DICTIONARY: {
                return ItemUtils.isItemEqual(other, this.getItem(), true, true, true);
            }
            case PRECISE: {
                return Item.func_150891_b((Item)this.getItem().func_77973_b()) == Item.func_150891_b((Item)other.func_77973_b()) && this.getItem().func_77952_i() == other.func_77952_i() && ItemStack.func_77970_a((ItemStack)this.getItem(), (ItemStack)other);
            }
            case NBT_FUZZY: {
                return Item.func_150891_b((Item)this.getItem().func_77973_b()) == Item.func_150891_b((Item)other.func_77973_b()) && this.getItem().func_77952_i() == other.func_77952_i();
            }
            case FUZZY: {
                return Item.func_150891_b((Item)this.getItem().func_77973_b()) == Item.func_150891_b((Item)other.func_77973_b());
            }
            case MOD_GROUPING: {
                return ModItemHelper.areItemsFromSameMod(this.getItem().func_77973_b(), other.func_77973_b());
            }
            case ALL: {
                return true;
            }
        }
        return false;
    }

    public boolean canChangeMetaData() {
        return true;
    }
}

