/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.components.ItemBufferElement;
import vswe.stevesfactory.components.ItemSetting;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.SlotInventoryHolder;

public class OutputItemCounter {
    private Setting setting;
    private boolean useWhiteList;
    private int currentInventoryStackSize;
    private int currentBufferStackSize;

    public OutputItemCounter(List<ItemBufferElement> itemBuffer, List<SlotInventoryHolder> inventories, IItemHandler inventory, Setting setting, boolean useWhiteList) {
        block6: {
            this.setting = setting;
            this.useWhiteList = useWhiteList;
            if (setting == null || ((ItemSetting)setting).getItem() == null || !setting.isLimitedByAmount()) break block6;
            if (useWhiteList) {
                if (inventories.get(0).isShared()) {
                    for (SlotInventoryHolder slotInventoryHolder : inventories) {
                        this.addInventory(slotInventoryHolder.getInventory());
                    }
                } else {
                    this.addInventory(inventory);
                }
            } else {
                for (ItemBufferElement itemBufferElement : itemBuffer) {
                    this.currentBufferStackSize += itemBufferElement.getBufferSize(setting);
                }
            }
        }
    }

    private void addInventory(IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            if (!((ItemSetting)this.setting).isEqualForCommandExecutor(item)) continue;
            this.currentInventoryStackSize += item.field_77994_a;
        }
    }

    public boolean areSettingsSame(Setting setting) {
        return this.setting == null && setting == null || this.setting != null && setting != null && this.setting.getId() == setting.getId();
    }

    public int retrieveItemCount(int desiredItemCount) {
        if (this.setting == null || !this.setting.isLimitedByAmount()) {
            return desiredItemCount;
        }
        int itemsAllowedToBeMoved = this.useWhiteList ? ((ItemSetting)this.setting).getItem().field_77994_a - this.currentInventoryStackSize : this.currentBufferStackSize - ((ItemSetting)this.setting).getItem().field_77994_a;
        return Math.min(itemsAllowedToBeMoved, desiredItemCount);
    }

    public void modifyStackSize(int itemsToMove) {
        if (this.useWhiteList) {
            this.currentInventoryStackSize += itemsToMove;
        } else {
            this.currentBufferStackSize -= itemsToMove;
        }
    }
}

