/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.blocks.IRedstoneNode;
import vswe.stevesfactory.blocks.ITriggerNode;
import vswe.stevesfactory.components.SlotSideTarget;
import vswe.stevesfactory.tiles.TileEntityBUD;
import vswe.stevesfactory.tiles.TileEntityCamouflage;
import vswe.stevesfactory.tiles.TileEntityInput;
import vswe.stevesfactory.tiles.TileEntityOutput;
import vswe.stevesfactory.tiles.TileEntitySignUpdater;
import vswe.stevesfactory.wrappers.CapabilityHelper;

public class SlotInventoryHolder {
    private TileEntity inventory;
    private Map<Integer, SlotSideTarget> validSlots;
    private int sharedOption;
    private int id;

    public SlotInventoryHolder(int id, TileEntity inventory, int sharedOption) {
        this.id = id;
        this.inventory = inventory;
        this.sharedOption = sharedOption;
    }

    public int getId() {
        return this.id;
    }

    public IItemHandler getInventory() {
        return CapabilityHelper.getItemCapabilitySafe(this.inventory);
    }

    public IFluidHandler getTank() {
        return CapabilityHelper.getFluidCapabilitySafe(this.inventory);
    }

    public TileEntityOutput getEmitter() {
        return (TileEntityOutput)this.inventory;
    }

    public IRedstoneNode getNode() {
        return (IRedstoneNode)this.inventory;
    }

    public TileEntityInput getReceiver() {
        return (TileEntityInput)this.inventory;
    }

    public TileEntityBUD getBUD() {
        return (TileEntityBUD)this.inventory;
    }

    public TileEntityCamouflage getCamouflage() {
        return (TileEntityCamouflage)this.inventory;
    }

    public TileEntitySignUpdater getSign() {
        return (TileEntitySignUpdater)this.inventory;
    }

    public Map<Integer, SlotSideTarget> getValidSlots() {
        if (this.validSlots == null) {
            this.validSlots = new HashMap<Integer, SlotSideTarget>();
        }
        return this.validSlots;
    }

    public boolean isShared() {
        return this.sharedOption == 0;
    }

    public int getSharedOption() {
        return this.sharedOption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotInventoryHolder that = (SlotInventoryHolder)o;
        return this.inventory.func_174877_v().func_177958_n() == that.inventory.func_174877_v().func_177958_n() && this.inventory.func_174877_v().func_177956_o() == that.inventory.func_174877_v().func_177956_o() && this.inventory.func_174877_v().func_177952_p() == that.inventory.func_174877_v().func_177956_o();
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }

    public TileEntity getTile() {
        return this.inventory;
    }

    public ITriggerNode getTrigger() {
        return (ITriggerNode)this.inventory;
    }
}

