/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.components.IItemBufferSubElement;

public class SlotStackInventoryHolder
implements IItemBufferSubElement {
    private ItemStack itemStack;
    private IItemHandler inventory;
    private int slot;
    private int sizeLeft;

    public SlotStackInventoryHolder(ItemStack itemStack, IItemHandler inventory, int slot) {
        this.itemStack = itemStack;
        this.inventory = inventory;
        this.slot = slot;
        this.sizeLeft = itemStack.field_77994_a;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public int getSlot() {
        return this.slot;
    }

    @Override
    public void remove() {
        if (this.itemStack.field_77994_a == 0) {
            this.getInventory().insertItem(this.getSlot(), null, false);
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public int getSizeLeft() {
        return Math.min(this.itemStack.field_77994_a, this.sizeLeft);
    }

    @Override
    public void reduceAmount(int val) {
        int extractSize;
        int stackSize = this.itemStack.field_77994_a;
        ItemStack extractStack = this.inventory.extractItem(this.getSlot(), val, false);
        int n = extractSize = extractStack != null ? extractStack.field_77994_a : 0;
        if (extractSize > 0 && stackSize == this.itemStack.field_77994_a) {
            this.itemStack.field_77994_a -= extractSize;
        }
        this.sizeLeft -= extractSize;
    }

    public SlotStackInventoryHolder getSplitElement(int elementAmount, int id, boolean fair) {
        int amountLeft;
        SlotStackInventoryHolder element = new SlotStackInventoryHolder(this.itemStack, this.inventory, this.slot);
        int oldAmount = this.getSizeLeft();
        int amount = oldAmount / elementAmount;
        if (!fair && id < (amountLeft = oldAmount % elementAmount)) {
            ++amount;
        }
        element.sizeLeft = amount;
        return element;
    }
}

