/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.components.TextBoxNumber;
import vswe.stevesfactory.interfaces.GuiManager;

public class TextBoxNumberList {
    private static final int TEXT_BOX_SIZE_H = 12;
    private static final int TEXT_BOX_SRC_X = 0;
    private static final int TEXT_BOX_SRC_Y = 221;
    private List<TextBoxNumber> textBoxes = new ArrayList<TextBoxNumber>();
    private TextBoxNumber selectedTextBox;

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        for (TextBoxNumber textBox : this.textBoxes) {
            if (!textBox.isVisible()) continue;
            int srcTextBoxX = textBox.equals(this.selectedTextBox) ? 1 : 0;
            int srcTextBoxY = textBox.isWide() ? 1 : 0;
            gui.drawTexture(textBox.getX(), textBox.getY(), 0 + srcTextBoxX * textBox.getWidth(), 221 + srcTextBoxY * 12, textBox.getWidth(), 12);
            String str = String.valueOf(textBox.getNumber());
            gui.drawCenteredString(str, textBox.getX(), textBox.getY() + textBox.getTextY(), textBox.getTextSize(), textBox.getWidth(), 0xFFFFFF);
        }
    }

    public void onClick(int mX, int mY, int button) {
        for (TextBoxNumber textBox : this.textBoxes) {
            if (!textBox.isVisible() || !CollisionHelper.inBounds(textBox.getX(), textBox.getY(), textBox.getWidth(), 12, mX, mY)) continue;
            if (textBox.equals(this.selectedTextBox)) {
                if (button == 0) {
                    this.selectedTextBox = null;
                    break;
                }
                textBox.setNumber(0);
                this.selectedTextBox.onNumberChanged();
                break;
            }
            this.selectedTextBox = textBox;
            break;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.selectedTextBox != null && this.selectedTextBox.isVisible()) {
            if (Character.isDigit(c)) {
                int number = Integer.parseInt(String.valueOf(c));
                if ((double)Math.abs(this.selectedTextBox.getNumber()) < Math.pow(10.0, this.selectedTextBox.getLength() - 1)) {
                    this.selectedTextBox.setNumber((Math.abs(this.selectedTextBox.getNumber()) * 10 + number) * (this.selectedTextBox.getNumber() < 0 ? -1 : 1));
                    this.selectedTextBox.onNumberChanged();
                }
                return true;
            }
            if (c == '-' && this.selectedTextBox.allowNegative()) {
                this.selectedTextBox.setNumber(this.selectedTextBox.getNumber() * -1);
                this.selectedTextBox.onNumberChanged();
                return true;
            }
            if (k == 14) {
                this.selectedTextBox.setNumber(this.selectedTextBox.getNumber() / 10);
                this.selectedTextBox.onNumberChanged();
                return true;
            }
            if (k == 15) {
                for (int i = 0; i < this.textBoxes.size(); ++i) {
                    TextBoxNumber textBox = this.textBoxes.get(i);
                    if (!textBox.equals(this.selectedTextBox)) continue;
                    int nextId = (i + 1) % this.textBoxes.size();
                    this.selectedTextBox = this.textBoxes.get(nextId);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    public void addTextBox(TextBoxNumber textBox) {
        this.textBoxes.add(textBox);
    }

    public TextBoxNumber getTextBox(int id) {
        return this.textBoxes.get(id);
    }
}

