/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.EnumFacing;
import vswe.stevesfactory.blocks.ConnectionBlockType;
import vswe.stevesfactory.blocks.IRedstoneNode;
import vswe.stevesfactory.blocks.ITriggerNode;
import vswe.stevesfactory.components.CommandExecutor;
import vswe.stevesfactory.components.ComponentMenuContainer;
import vswe.stevesfactory.components.ComponentMenuRedstoneSides;
import vswe.stevesfactory.components.ComponentMenuRedstoneSidesTrigger;
import vswe.stevesfactory.components.ConnectionOption;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.SlotInventoryHolder;

public abstract class TriggerHelper {
    public static final int TRIGGER_INTERVAL_ID = 2;
    protected boolean canUseMergedDetection;
    protected int containerId;
    protected int sidesId;
    protected ConnectionBlockType blockType;

    protected TriggerHelper(boolean canUseMergedDetection, int containerId, int sidesId, ConnectionBlockType blockType) {
        this.canUseMergedDetection = canUseMergedDetection;
        this.containerId = containerId;
        this.sidesId = sidesId;
        this.blockType = blockType;
    }

    protected abstract boolean isBlockPowered(FlowComponent var1, int var2);

    public abstract void onTrigger(FlowComponent var1, EnumSet<ConnectionOption> var2);

    protected boolean isTriggerPowered(FlowComponent component, int[] currentPower, boolean high) {
        ComponentMenuRedstoneSidesTrigger menuSides = (ComponentMenuRedstoneSidesTrigger)component.getMenus().get(this.sidesId);
        for (int i = 0; i < currentPower.length; ++i) {
            if (!menuSides.isSideRequired(i)) continue;
            if (this.isBlockPowered(component, currentPower[i]) == high) {
                if (menuSides.requireAll()) continue;
                return true;
            }
            if (!menuSides.requireAll()) continue;
            return false;
        }
        return menuSides.requireAll();
    }

    protected boolean hasRedStoneFlipped(FlowComponent component, int[] newPower, int[] oldPower, boolean high) {
        ComponentMenuRedstoneSides menuRedstone = (ComponentMenuRedstoneSides)component.getMenus().get(this.sidesId);
        for (int i = 0; i < oldPower.length; ++i) {
            if (!menuRedstone.isSideRequired(i) || (!high || this.isBlockPowered(component, oldPower[i]) || !this.isBlockPowered(component, newPower[i])) && (high || !this.isBlockPowered(component, oldPower[i]) || this.isBlockPowered(component, newPower[i]))) continue;
            return true;
        }
        return false;
    }

    protected boolean isPulseReceived(FlowComponent component, int[] newPower, int[] oldPower, boolean high) {
        return this.hasRedStoneFlipped(component, newPower, oldPower, high) && this.isTriggerPowered(component, newPower, high);
    }

    protected boolean isPulseReceived(FlowComponent component, List<SlotInventoryHolder> containers, ITriggerNode trigger, boolean high) {
        boolean requiresAll = trigger != null;
        for (SlotInventoryHolder container : containers) {
            ITriggerNode input = container.getTrigger();
            boolean flag = input.equals(trigger) || !requiresAll ? this.isPulseReceived(component, input.getData(), input.getOldData(), high) : this.isTriggerPowered(component, input.getData(), high);
            if (flag) {
                if (requiresAll) continue;
                return true;
            }
            if (!requiresAll) continue;
            return false;
        }
        return requiresAll;
    }

    protected boolean isSpecialPulseReceived(FlowComponent component, boolean high) {
        List<SlotInventoryHolder> containers = CommandExecutor.getContainers(component.getManager(), component.getMenus().get(this.containerId), this.blockType);
        if (containers != null) {
            ComponentMenuContainer componentMenuContainer = (ComponentMenuContainer)component.getMenus().get(this.containerId);
            boolean requiresAll = componentMenuContainer.getOption() == 0;
            boolean foundPulse = false;
            for (SlotInventoryHolder container : containers) {
                ITriggerNode input = container.getTrigger();
                boolean flag = this.isPulseReceived(component, input.getData(), input.getOldData(), high);
                if (flag) {
                    foundPulse = true;
                } else {
                    flag = this.isTriggerPowered(component, input.getData(), high);
                }
                if (foundPulse) {
                    if (requiresAll) continue;
                    return true;
                }
                if (!requiresAll || flag) continue;
                return false;
            }
            return requiresAll && foundPulse;
        }
        return false;
    }

    protected boolean isTriggerPowered(FlowComponent item, boolean high) {
        List<SlotInventoryHolder> receivers = CommandExecutor.getContainers(item.getManager(), item.getMenus().get(this.containerId), this.blockType);
        return receivers != null && this.isTriggerPowered(receivers, item, high);
    }

    public boolean isTriggerPowered(List<SlotInventoryHolder> receivers, FlowComponent component, boolean high) {
        ComponentMenuContainer menuContainer = (ComponentMenuContainer)component.getMenus().get(this.containerId);
        if (this.canUseMergedDetection && menuContainer.getOption() == 0) {
            int[] currentPower = new int[EnumFacing.values().length];
            for (SlotInventoryHolder receiver : receivers) {
                IRedstoneNode node = receiver.getNode();
                for (int i = 0; i < currentPower.length; ++i) {
                    currentPower[i] = Math.min(15, currentPower[i] + node.getPower()[i]);
                }
            }
            return this.isTriggerPowered(component, currentPower, high);
        }
        boolean requiresAll = menuContainer.getOption() == 0 || menuContainer.getOption() == 1 && this.canUseMergedDetection;
        for (SlotInventoryHolder receiver : receivers) {
            int[] data = receiver.getTile() instanceof ITriggerNode ? receiver.getTrigger().getData() : receiver.getNode().getPower();
            if (this.isTriggerPowered(component, data, high)) {
                if (requiresAll) continue;
                return true;
            }
            if (!requiresAll) continue;
            return false;
        }
        return requiresAll;
    }

    protected void activateTrigger(FlowComponent item, EnumSet<ConnectionOption> types) {
        item.getManager().activateTrigger(item, types);
    }
}

