/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.IContainerSelection;
import vswe.stevesfactory.components.VariableColor;
import vswe.stevesfactory.interfaces.GuiManager;

public class Variable
implements IContainerSelection {
    private int id;
    private FlowComponent declaration;
    private List<Integer> containers;
    private boolean executed;
    private static final int VARIABLE_SRC_X = 32;
    private static final int VARIABLE_SRC_Y = 130;
    private static final int VARIABLE_SIZE = 14;
    private static final String NBT_EXECUTED = "Executed";
    private static final String NBT_SELECTION = "Selection";
    private static final String NBT_SELECTION_ID = "Id";

    public Variable(int id) {
        this.id = id;
        this.containers = new ArrayList<Integer>();
    }

    public boolean isValid() {
        return this.declaration != null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void draw(GuiManager gui, int x, int y) {
        VariableColor.values()[this.id].applyColor();
        gui.drawTexture(x + 1, y + 1, 32, 130, 14, 14);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public String getDescription(GuiManager gui) {
        VariableColor color = VariableColor.values()[this.id];
        return color.getTextColor().toString() + this.getNameFromColor(color);
    }

    @Override
    public String getName(GuiManager gui) {
        return this.getNameFromColor(VariableColor.values()[this.id]);
    }

    @Override
    public boolean isVariable() {
        return true;
    }

    private String getNameFromColor(VariableColor color) {
        if (this.getDeclaration() == null || this.getDeclaration().getComponentName() == null) {
            return color.toString();
        }
        return this.getDeclaration().getComponentName();
    }

    public void setDeclaration(FlowComponent flowComponent) {
        if (flowComponent == null || this.declaration == null) {
            this.declaration = flowComponent;
        }
    }

    public FlowComponent getDeclaration() {
        return this.declaration;
    }

    public List<Integer> getContainers() {
        return this.containers;
    }

    public void add(int id) {
        if (!this.containers.contains(id)) {
            this.containers.add(id);
        }
    }

    public void setContainers(List<Integer> containers) {
        this.containers = containers;
    }

    public boolean hasBeenExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public void clearContainers() {
        this.containers.clear();
    }

    public void remove(int id) {
        this.containers.remove((Object)id);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.executed = nbtTagCompound.func_74767_n(NBT_EXECUTED);
        this.containers.clear();
        NBTTagList tagList = nbtTagCompound.func_150295_c(NBT_SELECTION, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound selectionTag = tagList.func_150305_b(i);
            this.containers.add(Integer.valueOf(selectionTag.func_74765_d(NBT_SELECTION_ID)));
        }
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a(NBT_EXECUTED, this.executed);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.containers.size(); ++i) {
            NBTTagCompound selectionTag = new NBTTagCompound();
            selectionTag.func_74777_a(NBT_SELECTION_ID, (short)this.containers.get(i).intValue());
            tagList.func_74742_a((NBTBase)selectionTag);
        }
        nbtTagCompound.func_74782_a(NBT_SELECTION, (NBTBase)tagList);
    }
}

