/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.interfaces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.interfaces.GuiAntiNEI;
import vswe.stevesfactory.interfaces.IAdvancedTooltip;
import vswe.stevesfactory.settings.Settings;
import vswe.stevesfactory.tiles.TileEntityClusterElement;

@SideOnly(value=Side.CLIENT)
public abstract class GuiBase
extends GuiAntiNEI {
    private static final ResourceLocation TERRAIN = new ResourceLocation("textures/atlas/blocks.png");

    public GuiBase(Container container) {
        super(container);
    }

    public abstract ResourceLocation getComponentResource();

    public void drawTexture(int x, int y, int srcX, int srcY, int w, int h) {
        float scale = this.getScale();
        this.drawScaleFriendlyTexture(this.fixScaledCoordinate(this.guiLeft + x, scale, this.field_146297_k.field_71443_c), this.fixScaledCoordinate(this.guiTop + y, scale, this.field_146297_k.field_71440_d), this.fixScaledCoordinate(srcX, scale, 256), this.fixScaledCoordinate(srcY, scale, 256), this.fixScaledCoordinate(w, scale, this.field_146297_k.field_71443_c), this.fixScaledCoordinate(h, scale, this.field_146297_k.field_71440_d));
    }

    private double fixScaledCoordinate(int val, float scale, int size) {
        double d = (float)val / scale;
        d *= (double)size;
        d = Math.floor(d);
        d /= (double)size;
        return d *= (double)scale;
    }

    public void drawScaleFriendlyTexture(double x, double y, double srcX, double srcY, double w, double h) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b(x + 0.0, y + h, (double)this.field_73735_i).func_187315_a((srcX + 0.0) * (double)f, (srcY + h) * (double)f1).func_181675_d();
        worldRenderer.func_181662_b(x + w, y + h, (double)this.field_73735_i).func_187315_a((srcX + w) * (double)f, (srcY + h) * (double)f1).func_181675_d();
        worldRenderer.func_181662_b(x + w, y + 0.0, (double)this.field_73735_i).func_187315_a((srcX + w) * (double)f, (srcY + 0.0) * (double)f1).func_181675_d();
        worldRenderer.func_181662_b(x + 0.0, y + 0.0, (double)this.field_73735_i).func_187315_a((srcX + 0.0) * (double)f, (srcY + 0.0) * (double)f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
    }

    public static ResourceLocation registerTexture(String name) {
        return new ResourceLocation("stevesfactorymanager", "textures/gui/" + name + ".png");
    }

    public void drawString(String str, int x, int y, float mult, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_78276_b(str, (int)((float)(x + this.guiLeft) / mult), (int)((float)(y + this.guiTop) / mult), color);
        GuiBase.bindTexture(this.getComponentResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawSplitString(String str, int x, int y, int w, float mult, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)mult, (float)mult, (float)1.0f);
        this.field_146289_q.func_78279_b(str, (int)((float)(x + this.guiLeft) / mult), (int)((float)(y + this.guiTop) / mult), (int)((float)w / mult), color);
        GuiBase.bindTexture(this.getComponentResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void drawString(String str, int x, int y, int color) {
        this.drawString(str, x, y, 1.0f, color);
    }

    public void drawMouseOver(String str, int x, int y, int width) {
        this.drawMouseOver(this.getLinesFromText(str, width), x, y);
    }

    public List<String> getLinesFromText(String str, int width) {
        ArrayList<String> lst = new ArrayList<String>();
        String[] words = str.split(" ");
        String line = "";
        for (String word : words) {
            String newLine = line.equals("") ? word : line + " " + word;
            if (this.getStringWidth(newLine) < width) {
                line = newLine;
                continue;
            }
            lst.add(line);
            line = word;
        }
        lst.add(line);
        return lst;
    }

    private int getStringMaxWidth(List<String> lines) {
        int width = 0;
        if (lines != null) {
            for (String line : lines) {
                int w = this.field_146289_q.func_78256_a(line);
                if (w <= width) continue;
                width = w;
            }
        }
        return width;
    }

    private int renderLines(List<String> lines, int mX, int mY, boolean first) {
        return this.renderLines(lines, mX, mY, first, false);
    }

    private int renderLines(List<String> lines, int mX, int mY, boolean first, boolean fake) {
        if (lines != null) {
            for (String line : lines) {
                if (!fake) {
                    this.field_146289_q.func_175063_a(line, (float)mX, (float)mY, -1);
                }
                if (first) {
                    mY += 2;
                    first = false;
                }
                mY += 10;
            }
        }
        return mY;
    }

    public void drawMouseOver(IAdvancedTooltip tooltip, int mX, int mY) {
        this.drawMouseOver(tooltip, mX, mY, mX, mY);
    }

    public void drawMouseOver(IAdvancedTooltip tooltip, int x, int y, int mX, int mY) {
        if (tooltip != null) {
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            List<String> prefix = tooltip.getPrefix(this);
            List<String> suffix = tooltip.getSuffix(this);
            int prefixLength = prefix != null ? prefix.size() : 0;
            int suffixLength = suffix != null ? suffix.size() : 0;
            int extraHeight = tooltip.getExtraHeight(this);
            int width = Math.max(tooltip.getMinWidth(this), Math.max(this.getStringMaxWidth(prefix), this.getStringMaxWidth(suffix)));
            int height = extraHeight + (prefixLength + suffixLength) * 10 - 2;
            y += this.guiTop - 12;
            if ((x += this.guiLeft + 12) + width > this.field_146294_l) {
                x -= 28 + width;
            }
            if (y + height + 6 > this.field_146295_m) {
                y = this.field_146295_m - height - 6;
            }
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            int j1 = -267386864;
            this.func_73733_a(x - 3, y - 4, x + width + 3, y - 3, j1, j1);
            this.func_73733_a(x - 3, y + height + 3, x + width + 3, y + height + 4, j1, j1);
            this.func_73733_a(x - 3, y - 3, x + width + 3, y + height + 3, j1, j1);
            this.func_73733_a(x - 4, y - 3, x - 3, y + height + 3, j1, j1);
            this.func_73733_a(x + width + 3, y - 3, x + width + 4, y + height + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, k1, l1);
            this.func_73733_a(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, k1, l1);
            this.func_73733_a(x - 3, y - 3, x + width + 3, y - 3 + 1, k1, k1);
            this.func_73733_a(x - 3, y + height + 2, x + width + 3, y + height + 3, l1, l1);
            y = this.renderLines(prefix, x, y, true);
            tooltip.drawContent(this, x - this.guiLeft, y - this.guiTop, mX, mY);
            this.renderLines(suffix, x, y += extraHeight, false);
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public int getAdvancedToolTipContentStartX(IAdvancedTooltip tooltip) {
        return 12;
    }

    public int getAdvancedToolTipContentStartY(IAdvancedTooltip tooltip) {
        if (tooltip != null) {
            return this.renderLines(tooltip.getPrefix(this), 0, 0, true, true) - 12;
        }
        return 0;
    }

    public void drawMouseOver(String str, int x, int y) {
        this.drawMouseOver(Arrays.asList(str.split("\n")), x, y);
    }

    public void drawMouseOver(List lst, int x, int y) {
        if (lst != null) {
            this.drawHoveringText(lst, x + this.guiLeft, y + this.guiTop, this.field_146289_q);
        }
    }

    public void drawBlock(TileEntity te, int x, int y) {
        ItemStack item = this.getItemStackFromBlock(te);
        if (item != null) {
            this.drawItemStack(item, x, y);
        }
    }

    public String getBlockName(TileEntity te) {
        ItemStack item = this.getItemStackFromBlock(te);
        if (item != null) {
            return this.getItemName(item);
        }
        return "Unknown";
    }

    public String getItemName(ItemStack item) {
        try {
            List str = item.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            if (str != null && str.size() > 0) {
                return (String)str.get(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Unknown";
    }

    private ItemStack getItemStackFromBlock(TileEntity te) {
        if (te != null) {
            if (te instanceof TileEntityClusterElement) {
                return ((TileEntityClusterElement)te).getItemStackFromBlock();
            }
            World world = te.func_145831_w();
            Block block = te.func_145838_q();
            if (world != null && block != null) {
                BlockPos pos = te.func_174877_v();
                return this.getItemStackFromBlock(world, pos, block, world.func_180495_p(pos));
            }
        }
        return null;
    }

    public ItemStack getItemStackFromBlock(World world, int x, int y, int z) {
        BlockPos pos;
        Block block;
        if (world != null && (block = world.func_180495_p(pos = new BlockPos(x, y, z)).func_177230_c()) != null) {
            return this.getItemStackFromBlock(world, pos, block, world.func_180495_p(pos));
        }
        return null;
    }

    private ItemStack getItemStackFromBlock(World world, BlockPos pos, Block block, IBlockState state) {
        try {
            ItemStack item = block.getPickBlock(state, new RayTraceResult(RayTraceResult.Type.BLOCK, new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), EnumFacing.UP, pos), world, pos, (EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
            if (item != null) {
                return item;
            }
        }
        catch (Throwable item) {
            // empty catch block
        }
        try {
            List items = block.getDrops((IBlockAccess)world, pos, state, 0);
            if (items != null && items.size() > 0 && items.get(0) != null) {
                return (ItemStack)items.get(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new ItemStack(block, 1, block.func_176201_c(state));
    }

    public void drawItemAmount(ItemStack itemstack, int x, int y) {
        this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, x + this.guiLeft, y + this.guiTop, null);
        GuiBase.bindTexture(this.getComponentResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawItemStack(ItemStack itemstack, int x, int y) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        this.field_146296_j.field_77023_b = 1.0f;
        try {
            this.field_146296_j.func_175042_a(itemstack, x + this.guiLeft, y + this.guiTop);
        }
        catch (Exception ex) {
            if (itemstack.func_77952_i() != 0) {
                ItemStack newStack = itemstack.func_77946_l();
                newStack.func_77964_b(0);
                this.drawItemStack(newStack, x, y);
            }
        }
        finally {
            this.field_146296_j.field_77023_b = 0.0f;
            GuiBase.bindTexture(this.getComponentResource());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
        }
    }

    public int getStringWidth(String str) {
        return this.field_146289_q.func_78256_a(str);
    }

    public void drawCenteredString(String str, int x, int y, float mult, int width, int color) {
        this.drawString(str, x + (width - (int)((float)this.getStringWidth(str) * mult)) / 2, y, mult, color);
    }

    public void drawCursor(int x, int y, int z, int color) {
        this.drawCursor(x, y, z, 1.0f, color);
    }

    public void drawCursor(int x, int y, int z, float size, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)z);
        GlStateManager.func_179109_b((float)(x += this.guiLeft), (float)(y += this.guiTop), (float)0.0f);
        GlStateManager.func_179152_a((float)size, (float)size, (float)0.0f);
        GlStateManager.func_179109_b((float)(-x), (float)(-y), (float)0.0f);
        Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + 10), (int)color);
        GlStateManager.func_179121_F();
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        GL11.glLineWidth((float)(1.0f + (float)(5 * this.field_146294_l) / 500.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)(this.guiLeft + x1), (float)(this.guiTop + y1), (float)0.0f);
        GL11.glVertex3f((float)(this.guiLeft + x2), (float)(this.guiTop + y2), (float)0.0f);
        GL11.glEnd();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public final void func_146276_q_() {
        super.func_146276_q_();
        this.startScaling();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(this.scaleX(x), this.scaleY(y), f);
        this.stopScaling();
    }

    private void startScaling() {
        GlStateManager.func_179094_E();
        float scale = this.getScale();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179109_b((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
        GlStateManager.func_179109_b((float)(((float)this.field_146294_l - (float)this.xSize * scale) / (2.0f * scale)), (float)(((float)this.field_146295_m - (float)this.ySize * scale) / (2.0f * scale)), (float)0.0f);
    }

    private void stopScaling() {
        GlStateManager.func_179121_F();
    }

    protected float getScale() {
        float h;
        float multY;
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        float w = (float)scaledresolution.func_78326_a() * 0.9f;
        float multX = w / (float)this.xSize;
        float mult = Math.min(multX, multY = (h = (float)scaledresolution.func_78328_b() * 0.9f) / (float)this.ySize);
        if (mult > 1.0f && !Settings.isEnlargeInterfaces()) {
            mult = 1.0f;
        }
        mult = (float)Math.floor(mult * 1000.0f) / 1000.0f;
        return mult;
    }

    protected int scaleX(float x) {
        float scale = this.getScale();
        x /= scale;
        x += (float)this.guiLeft;
        return (int)(x -= ((float)this.field_146294_l - (float)this.xSize * scale) / (2.0f * scale));
    }

    protected int scaleY(float y) {
        float scale = this.getScale();
        y /= scale;
        y += (float)this.guiTop;
        return (int)(y -= ((float)this.field_146295_m - (float)this.ySize * scale) / (2.0f * scale));
    }

    public void drawIcon(TextureAtlasSprite texture, int x, int y) {
        this.func_175175_a(this.guiLeft + x, this.guiTop + y, texture, 16, 16);
    }

    public void drawFluid(Fluid fluid, int x, int y) {
        if (fluid == null) {
            return;
        }
        TextureMap textureMapBlocks = this.field_146297_k.func_147117_R();
        ResourceLocation fluidStill = fluid.getStill();
        TextureAtlasSprite icon = null;
        if (fluidStill != null) {
            icon = textureMapBlocks.func_110572_b(fluidStill.toString());
        }
        if (icon == null) {
            icon = textureMapBlocks.func_174944_f();
        }
        if (icon != null) {
            GuiBase.bindTexture(TERRAIN);
            this.setColor(fluid.getColor());
            this.drawIcon(icon, x, y);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBase.bindTexture(this.getComponentResource());
        }
    }

    private void setColor(int color) {
        float[] colorComponents = new float[3];
        for (int i = 0; i < colorComponents.length; ++i) {
            colorComponents[i] = (float)((color & 255 << i * 8) >> i * 8) / 255.0f;
        }
        GlStateManager.func_179131_c((float)colorComponents[2], (float)colorComponents[1], (float)colorComponents[0], (float)1.0f);
    }

    public int getFontHeight() {
        return this.field_146289_q.field_78288_b;
    }

    public int getLeft() {
        return this.guiLeft;
    }

    public int getTop() {
        return this.guiTop;
    }
}

