/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.interfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.animation.AnimationController;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.interfaces.ContainerManager;
import vswe.stevesfactory.interfaces.GuiBase;
import vswe.stevesfactory.interfaces.IInterfaceRenderer;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;
import vswe.stevesfactory.tiles.TileEntityManager;

@SideOnly(value=Side.CLIENT)
public class GuiManager
extends GuiBase {
    private static final ResourceLocation BACKGROUND_1 = GuiManager.registerTexture("Background1");
    private static final ResourceLocation BACKGROUND_2 = GuiManager.registerTexture("Background2");
    private static final ResourceLocation COMPONENTS = GuiManager.registerTexture("FlowComponents");
    public static int Z_LEVEL_COMPONENT_OPEN_DIFFERENCE = 100;
    public static int Z_LEVEL_COMPONENT_CLOSED_DIFFERENCE = 1;
    public static int Z_LEVEL_COMPONENT_START = 750;
    public static int Z_LEVEL_OPEN_MAXIMUM = 5;
    private long lastTicks;
    private AnimationController controller;
    private boolean doubleShiftFlag;
    private boolean useGreenScreen;
    private boolean useBlueScreen;
    private boolean usePinkScreen;
    private boolean useButtons = true;
    private boolean useInfo = true;
    private boolean useMouseOver = true;
    private List<SecretCode> codes = new ArrayList<SecretCode>();
    private TileEntityManager manager;

    public GuiManager(TileEntityManager manager, InventoryPlayer player) {
        super(new ContainerManager(manager, player));
        this.codes.add(new SecretCode("animate"){

            @Override
            protected void trigger() {
                GuiManager.this.controller = new AnimationController(GuiManager.this.manager, 2);
            }
        });
        this.codes.add(new SecretCode("animslow"){

            @Override
            protected void trigger() {
                GuiManager.this.controller = new AnimationController(GuiManager.this.manager, 1);
            }
        });
        this.codes.add(new SecretCode("animfast"){

            @Override
            protected void trigger() {
                GuiManager.this.controller = new AnimationController(GuiManager.this.manager, 5);
            }
        });
        this.codes.add(new SecretCode("animrapid"){

            @Override
            protected void trigger() {
                GuiManager.this.controller = new AnimationController(GuiManager.this.manager, 20);
            }
        });
        this.codes.add(new SecretCode("animinstant"){

            @Override
            protected void trigger() {
                GuiManager.this.controller = new AnimationController(GuiManager.this.manager, 100);
            }
        });
        this.codes.add(new SecretCode("green"){

            @Override
            protected void trigger() {
                GuiManager.this.useGreenScreen = !GuiManager.this.useGreenScreen;
                GuiManager.this.useBlueScreen = false;
                GuiManager.this.usePinkScreen = false;
            }
        });
        this.codes.add(new SecretCode("blue"){

            @Override
            protected void trigger() {
                GuiManager.this.useBlueScreen = !GuiManager.this.useBlueScreen;
                GuiManager.this.useGreenScreen = false;
                GuiManager.this.usePinkScreen = false;
            }
        });
        this.codes.add(new SecretCode("pink"){

            @Override
            protected void trigger() {
                GuiManager.this.usePinkScreen = !GuiManager.this.usePinkScreen;
                GuiManager.this.useGreenScreen = false;
                GuiManager.this.useBlueScreen = false;
            }
        });
        this.codes.add(new SecretCode("buttons"){

            @Override
            protected void trigger() {
                GuiManager.this.useButtons = !GuiManager.this.useButtons;
            }
        });
        this.codes.add(new SecretCode("info"){

            @Override
            protected void trigger() {
                GuiManager.this.useInfo = !GuiManager.this.useInfo;
            }
        });
        this.codes.add(new SecretCode("mouse"){

            @Override
            protected void trigger() {
                GuiManager.this.useMouseOver = !GuiManager.this.useMouseOver;
            }
        });
        this.xSize = 512;
        this.ySize = 256;
        this.manager = manager;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public ResourceLocation getComponentResource() {
        return COMPONENTS;
    }

    public void func_146270_b(int val) {
        if (this.usePinkScreen) {
            GuiManager.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1310580);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (this.useBlueScreen) {
            GuiManager.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16774511);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (this.useGreenScreen) {
            GuiManager.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16711936);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.func_146270_b(val);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        if (!(this.useGreenScreen || this.useBlueScreen || this.usePinkScreen)) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiManager.bindTexture(BACKGROUND_1);
            this.drawTexture(0, 0, 0, 0, 256, 256);
            GuiManager.bindTexture(BACKGROUND_2);
            this.drawTexture(256, 0, 0, 0, 256, 256);
        }
        x -= this.guiLeft;
        y -= this.guiTop;
        GuiManager.bindTexture(COMPONENTS);
        if (this.hasSpecialRenderer()) {
            this.getSpecialRenderer().draw(this, x, y);
            this.getSpecialRenderer().drawMouseOver(this, x, y);
            return;
        }
        if (this.useButtons) {
            for (int i = 0; i < this.manager.buttons.size(); ++i) {
                TileEntityManager.Button button = this.manager.buttons.get(i);
                if (!button.isVisible()) continue;
                int srcButtonY = CollisionHelper.inBounds(button.getX(), button.getY(), 14, 14, x, y) ? 1 : 0;
                this.drawTexture(button.getX(), button.getY(), 242, 0 + srcButtonY * 14, 14, 14);
                this.drawTexture(button.getX() + 1, button.getY() + 1, 230, 0 + i * 12, 12, 12);
            }
        }
        long ticks = Minecraft.func_71386_F();
        float elapsedSeconds = (float)(ticks - this.lastTicks) / 1000.0f;
        if (this.controller != null) {
            this.controller.update(elapsedSeconds);
        }
        for (FlowComponent component : this.manager.getFlowItems()) {
            component.update(elapsedSeconds);
        }
        this.lastTicks = ticks;
        int zLevel = Z_LEVEL_COMPONENT_START;
        int openCount = 0;
        for (int i = 0; i < this.manager.getZLevelRenderingList().size(); ++i) {
            FlowComponent itemBase = this.manager.getZLevelRenderingList().get(i);
            if (!itemBase.isVisible()) continue;
            if (itemBase.isOpen() && openCount == Z_LEVEL_OPEN_MAXIMUM) {
                itemBase.close();
            }
            if (itemBase.isOpen()) {
                zLevel -= Z_LEVEL_COMPONENT_OPEN_DIFFERENCE;
                ++openCount;
            } else {
                zLevel -= Z_LEVEL_COMPONENT_CLOSED_DIFFERENCE;
            }
            itemBase.draw(this, x, y, zLevel);
            if (!itemBase.isBeingMoved() && !CollisionHelper.inBounds(itemBase.getX(), itemBase.getY(), itemBase.getComponentWidth(), itemBase.getComponentHeight(), x, y)) continue;
            CollisionHelper.disableInBoundsCheck = true;
        }
        CollisionHelper.disableInBoundsCheck = false;
        if (this.useInfo) {
            this.drawString(this.getInfo(), 5, this.ySize - 13, 1.0f, 0x606060);
        }
        if (this.useMouseOver) {
            if (this.useButtons) {
                for (TileEntityManager.Button button : this.manager.buttons) {
                    if (!button.isVisible() || !CollisionHelper.inBounds(button.getX(), button.getY(), 14, 14, x, y)) continue;
                    this.drawMouseOver(button.getMouseOver(), x, y);
                }
            }
            for (FlowComponent itemBase : this.manager.getZLevelRenderingList()) {
                if (!itemBase.isVisible()) continue;
                itemBase.drawMouseOver(this, x, y);
                if (!itemBase.isBeingMoved() && !CollisionHelper.inBounds(itemBase.getX(), itemBase.getY(), itemBase.getComponentWidth(), itemBase.getComponentHeight(), x, y)) continue;
                CollisionHelper.disableInBoundsCheck = true;
            }
        }
        CollisionHelper.disableInBoundsCheck = false;
        if (!Keyboard.isKeyDown((int)54) && this.doubleShiftFlag) {
            this.doubleShiftFlag = false;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            if (this.hasSpecialRenderer()) {
                this.getSpecialRenderer().onScroll(scroll);
                return;
            }
            for (FlowComponent component : this.manager.getZLevelRenderingList()) {
                if (!component.isVisible()) continue;
                component.doScroll(scroll);
                return;
            }
        }
    }

    private String getInfo() {
        String ret = Localization.COMMANDS.toString() + ": " + this.manager.getFlowItems().size() + "  ";
        String path = "";
        FlowComponent component = this.manager.getSelectedComponent();
        if (component != null) {
            ret = ret + "|";
        }
        while (component != null) {
            String nextPath = "> " + component.getName() + " " + path;
            if (this.getStringWidth(ret + nextPath) > this.xSize - 15) {
                path = "... " + path;
                break;
            }
            path = nextPath;
            component = component.getParent();
        }
        ret = ret + path;
        return ret;
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        x = this.scaleX(x);
        y = this.scaleY(y);
        super.func_73864_a(x, y, button);
        x -= this.guiLeft;
        y -= this.guiTop;
        if (this.hasSpecialRenderer()) {
            this.getSpecialRenderer().onClick(this, x, y, button);
            return;
        }
        for (int i = 0; i < this.manager.getZLevelRenderingList().size(); ++i) {
            FlowComponent itemBase = this.manager.getZLevelRenderingList().get(i);
            if (!itemBase.isVisible() || !itemBase.onClick(x, y, button)) continue;
            this.manager.getZLevelRenderingList().remove(i);
            this.manager.getZLevelRenderingList().add(0, itemBase);
            break;
        }
        if (this.useButtons) {
            this.onClickButtonCheck(x, y, false);
        }
    }

    private void onClickButtonCheck(int x, int y, boolean release) {
        for (int i = 0; i < this.manager.buttons.size(); ++i) {
            TileEntityManager.Button guiButton = this.manager.buttons.get(i);
            if (!guiButton.isVisible() || !CollisionHelper.inBounds(guiButton.getX(), guiButton.getY(), 14, 14, x, y) || guiButton.activateOnRelease() != release) continue;
            DataWriter dw = PacketHandler.getButtonPacketWriter();
            dw.writeData(i, DataBitHelper.GUI_BUTTON_ID);
            if (!guiButton.onClick(dw)) break;
            PacketHandler.sendDataToServer(dw);
            break;
        }
    }

    @Override
    protected void func_146273_a(int x, int y, int button, long ticks) {
        x = this.scaleX(x);
        y = this.scaleY(y);
        super.func_146273_a(x, y, button, ticks);
        x -= this.guiLeft;
        y -= this.guiTop;
        if (this.hasSpecialRenderer()) {
            this.getSpecialRenderer().onDrag(this, x, y);
            return;
        }
        for (FlowComponent itemBase : this.manager.getZLevelRenderingList()) {
            if (!itemBase.isVisible()) continue;
            itemBase.onDrag(x, y);
        }
    }

    @Override
    protected void func_146286_b(int x, int y, int button) {
        x = this.scaleX(x);
        y = this.scaleY(y);
        super.func_146286_b(x, y, button);
        x -= this.guiLeft;
        y -= this.guiTop;
        if (this.hasSpecialRenderer()) {
            this.getSpecialRenderer().onRelease(this, x, y);
            return;
        }
        if (this.useButtons) {
            this.onClickButtonCheck(x, y, true);
        }
        if (!this.manager.justSentServerComponentRemovalPacket) {
            for (FlowComponent itemBase : this.manager.getZLevelRenderingList()) {
                if (!itemBase.isVisible()) continue;
                itemBase.onRelease(x, y, button);
            }
        }
        for (FlowComponent itemBase : this.manager.getZLevelRenderingList()) {
            if (!itemBase.isVisible()) continue;
            itemBase.postRelease();
        }
    }

    @Override
    protected void func_73869_a(char c, int k) throws IOException {
        if (this.hasSpecialRenderer()) {
            this.getSpecialRenderer().onKeyTyped(this, c, k);
        } else {
            if (k == 54 && !this.doubleShiftFlag) {
                DataWriter dw = PacketHandler.getWriterForServerActionPacket();
                PacketHandler.sendDataToServer(dw);
                this.doubleShiftFlag = true;
            }
            for (FlowComponent itemBase : this.manager.getZLevelRenderingList()) {
                if (!itemBase.isVisible() || !itemBase.onKeyStroke(this, c, k) || k == 1) continue;
                return;
            }
            boolean recognized = false;
            for (SecretCode code : this.codes) {
                if (!code.keyTyped(c)) continue;
                recognized = true;
            }
            if (recognized) {
                return;
            }
        }
        super.func_73869_a(c, k);
    }

    @Override
    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        for (FlowComponent flowComponent : this.manager.getFlowItems()) {
            flowComponent.onGuiClosed();
        }
        super.func_146281_b();
    }

    public TileEntityManager getManager() {
        return this.manager;
    }

    private boolean hasSpecialRenderer() {
        return this.getSpecialRenderer() != null;
    }

    private IInterfaceRenderer getSpecialRenderer() {
        return this.manager.specialRenderer;
    }

    private abstract class SecretCode {
        private final String code;
        private int triggerNumber;

        private SecretCode(String code) {
            this.code = code;
        }

        public boolean keyTyped(char c) {
            if (Character.isAlphabetic(c)) {
                if (this.code.charAt(this.triggerNumber) == c) {
                    if (this.triggerNumber + 1 > this.code.length() - 1) {
                        this.triggerNumber = 0;
                        this.trigger();
                    } else {
                        ++this.triggerNumber;
                    }
                    return true;
                }
                if (this.triggerNumber != 0) {
                    this.triggerNumber = 0;
                    this.keyTyped(c);
                }
            }
            return false;
        }

        protected abstract void trigger();
    }
}

