/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.tiles;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevesfactory.blocks.ClusterMethodRegistration;
import vswe.stevesfactory.blocks.IRedstoneNode;
import vswe.stevesfactory.components.ComponentMenuPulse;
import vswe.stevesfactory.components.ComponentMenuRedstoneOutput;
import vswe.stevesfactory.components.ComponentMenuRedstoneSidesEmitter;
import vswe.stevesfactory.init.ModBlocks;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.IPacketBlock;
import vswe.stevesfactory.network.PacketHandler;
import vswe.stevesfactory.tiles.TileEntityClusterElement;

public class TileEntityOutput
extends TileEntityClusterElement
implements IPacketBlock,
IRedstoneNode {
    private int[] strengths;
    private boolean[] strong;
    private int[] updatedStrength;
    private boolean[] updatedStrong;
    private static final String NBT_SIDES = "Sides";
    private static final String NBT_STRENGTH = "Strength";
    private static final String NBT_STRONG = "Strong";
    private static final String NBT_TICK = "Tick";
    private static final String NBT_PULSES = "Pulses";
    private List<PulseTimer>[] pulseTimers;
    private boolean hasUpdatedThisTick;
    private List<BlockPos> scheduledToUpdate = new ArrayList<BlockPos>();
    private static final int UPDATE_BUFFER_DISTANCE = 5;
    private boolean hasUpdatedData;

    public TileEntityOutput() {
        this.strengths = new int[EnumFacing.values().length];
        this.strong = new boolean[EnumFacing.values().length];
        this.updatedStrength = new int[EnumFacing.values().length];
        this.updatedStrong = new boolean[EnumFacing.values().length];
        this.pulseTimers = new List[EnumFacing.values().length];
        for (int i = 0; i < this.pulseTimers.length; ++i) {
            this.pulseTimers[i] = new ArrayList<PulseTimer>();
        }
    }

    public boolean hasStrongSignalAtSide(EnumFacing side) {
        return this.strong[side.ordinal()];
    }

    public boolean hasStrongSignalAtOppositeSide(EnumFacing side) {
        return this.strong[side.func_176734_d().ordinal()];
    }

    public int getStrengthFromSide(EnumFacing side) {
        return this.strengths[side.ordinal()];
    }

    public int getStrengthFromOppositeSide(EnumFacing side) {
        return this.getStrengthFromSide(side.func_176734_d());
    }

    public void updateState(ComponentMenuRedstoneSidesEmitter sides, ComponentMenuRedstoneOutput output, ComponentMenuPulse pulse) {
        boolean updateClient = false;
        block6: for (int i = 0; i < EnumFacing.values().length; ++i) {
            boolean updateBlocks;
            if (!sides.isSideRequired(i)) continue;
            int oldStrength = this.updatedStrength[i];
            boolean oldStrong = this.updatedStrong[i];
            this.updateSideState(i, output);
            this.updatedStrong[i] = sides.useStrongSignal();
            boolean bl = updateBlocks = oldStrength != this.updatedStrength[i] || oldStrong != this.updatedStrong[i];
            if (updateBlocks) {
                updateClient = true;
            }
            if (updateBlocks) {
                this.addBlockScheduledForUpdate(EnumFacing.func_82600_a((int)i));
            }
            if (!pulse.shouldEmitPulse()) continue;
            PulseTimer timer = new PulseTimer(oldStrength, oldStrong, pulse.getPulseTime() + 1);
            List<PulseTimer> timers = this.pulseTimers[i];
            if (timers.size() >= 200) continue;
            switch (pulse.getSelectedPulseOverride()) {
                case EXTEND_OLD: {
                    if (timers.size() > 0) {
                        if (timers.size() > 1) {
                            PulseTimer temp = timers.get(0);
                            timers.clear();
                            timers.add(temp);
                        }
                        PulseTimer oldTimer = timers.get(0);
                        oldTimer.ticks = Math.max(oldTimer.ticks, timer.ticks);
                        continue block6;
                    }
                    timers.add(timer);
                    continue block6;
                }
                case KEEP_ALL: {
                    timers.add(timer);
                    continue block6;
                }
                case KEEP_NEW: {
                    timers.clear();
                    timers.add(timer);
                    continue block6;
                }
                case KEEP_OLD: {
                    if (!timers.isEmpty()) continue block6;
                    timers.add(timer);
                }
            }
        }
        if (updateClient && !this.isPartOfCluster()) {
            PacketHandler.sendBlockPacket(this, null, 0);
        }
    }

    private void addBlockScheduledForUpdate(EnumFacing side) {
        int z;
        int y;
        this.hasUpdatedThisTick = true;
        int x = this.func_174877_v().func_177958_n() + side.func_82601_c();
        BlockPos coordinate = new BlockPos(x, y = this.func_174877_v().func_177956_o() + side.func_96559_d(), z = this.func_174877_v().func_177952_p() + side.func_82599_e());
        if (!this.scheduledToUpdate.contains(coordinate)) {
            this.scheduledToUpdate.add(coordinate);
        }
    }

    private void updateSideState(int side, ComponentMenuRedstoneOutput output) {
        int strength = this.updatedStrength[side];
        int selectedStrength = output.getSelectedStrength();
        switch (output.getSelectedSetting()) {
            case FIXED: {
                strength = selectedStrength;
                break;
            }
            case TOGGLE: {
                strength = strength > 0 ? 0 : 15;
                break;
            }
            case MAX: {
                strength = Math.max(strength, selectedStrength);
                break;
            }
            case MIN: {
                strength = Math.min(strength, selectedStrength);
                break;
            }
            case INCREASE: {
                strength = Math.min(15, strength + selectedStrength);
                break;
            }
            case DECREASE: {
                strength = Math.max(0, strength - selectedStrength);
                break;
            }
            case FORWARD: {
                strength = (strength + selectedStrength) % 16;
                break;
            }
            case BACKWARD: {
                if ((strength -= selectedStrength) >= 0) break;
                strength += 16;
            }
        }
        this.updatedStrength[side] = strength;
    }

    private void notifyUpdate(BlockPos pos, boolean spread) {
        if (this.field_145850_b.func_180495_p(pos).func_177230_c() != ModBlocks.blockCable && (pos.func_177958_n() != this.func_174877_v().func_177958_n() || pos.func_177956_o() != this.func_174877_v().func_177956_o() || pos.func_177952_p() != this.func_174877_v().func_177952_p())) {
            this.field_145850_b.func_180496_d(pos, (Block)ModBlocks.blockCableOutput);
            if (spread) {
                this.notifyUpdate(pos.func_177982_a(-1, 0, 0), false);
                this.notifyUpdate(pos.func_177982_a(1, 0, 0), false);
                this.notifyUpdate(pos.func_177982_a(0, -1, 0), false);
                this.notifyUpdate(pos.func_177982_a(0, 1, 0), false);
                this.notifyUpdate(pos.func_177982_a(0, 0, -1), false);
                this.notifyUpdate(pos.func_177982_a(0, 0, 1), false);
            }
        }
    }

    @Override
    public void readContentFromNBT(NBTTagCompound nbtTagCompound) {
        byte version = nbtTagCompound.func_74771_c("ProtocolVersion");
        NBTTagList sidesTag = nbtTagCompound.func_150295_c(NBT_SIDES, 10);
        for (int i = 0; i < sidesTag.func_74745_c(); ++i) {
            NBTTagCompound sideTag = sidesTag.func_150305_b(i);
            byte by = sideTag.func_74771_c(NBT_STRENGTH);
            this.updatedStrength[i] = by;
            this.strengths[i] = by;
            this.strong[i] = this.updatedStrong[i] = sideTag.func_74767_n(NBT_STRONG);
            List<PulseTimer> timers = this.pulseTimers[i];
            timers.clear();
            NBTTagList pulsesTag = sideTag.func_150295_c(NBT_PULSES, 10);
            for (int j = 0; j < pulsesTag.func_74745_c(); ++j) {
                NBTTagCompound pulseTag = pulsesTag.func_150305_b(j);
                timers.add(new PulseTimer(pulseTag.func_74771_c(NBT_STRENGTH), pulseTag.func_74767_n(NBT_STRONG), pulseTag.func_74765_d(NBT_TICK)));
            }
        }
    }

    @Override
    public void writeContentToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74774_a("ProtocolVersion", (byte)13);
        NBTTagList sidesTag = new NBTTagList();
        for (int i = 0; i < this.strengths.length; ++i) {
            NBTTagCompound sideTag = new NBTTagCompound();
            sideTag.func_74774_a(NBT_STRENGTH, (byte)this.updatedStrength[i]);
            sideTag.func_74757_a(NBT_STRONG, this.updatedStrong[i]);
            NBTTagList pulsesTag = new NBTTagList();
            List<PulseTimer> timers = this.pulseTimers[i];
            for (PulseTimer timer : timers) {
                NBTTagCompound pulseTag = new NBTTagCompound();
                pulseTag.func_74774_a(NBT_STRENGTH, (byte)timer.strength);
                pulseTag.func_74757_a(NBT_STRONG, timer.strong);
                pulseTag.func_74777_a(NBT_TICK, (short)timer.ticks);
                pulsesTag.func_74742_a((NBTBase)pulseTag);
            }
            sideTag.func_74782_a(NBT_PULSES, (NBTBase)pulsesTag);
            sidesTag.func_74742_a((NBTBase)sideTag);
        }
        nbtTagCompound.func_74782_a(NBT_SIDES, (NBTBase)sidesTag);
    }

    @Override
    public void writeData(DataWriter dw, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                boolean isOn = this.updatedStrength[i] > 0;
                dw.writeBoolean(isOn);
                if (!isOn) continue;
                dw.writeData(this.updatedStrength[i], DataBitHelper.MENU_REDSTONE_ANALOG);
                dw.writeBoolean(this.updatedStrong[i]);
            }
        }
    }

    @Override
    public void readData(DataReader dr, EntityPlayer player, boolean onServer, int id) {
        if (onServer) {
            PacketHandler.sendBlockPacket(this, player, 0);
        } else {
            for (int i = 0; i < EnumFacing.values().length; ++i) {
                boolean isOn = dr.readBoolean();
                if (isOn) {
                    this.strengths[i] = dr.readData(DataBitHelper.MENU_REDSTONE_ANALOG);
                    this.strong[i] = dr.readBoolean();
                    continue;
                }
                this.strengths[i] = 0;
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
    }

    @Override
    public int infoBitLength(boolean onServer) {
        return 0;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.keepClientDataUpdated();
        } else {
            this.updatePulses();
            if (this.hasUpdatedThisTick) {
                this.hasUpdatedThisTick = false;
                ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>(this.scheduledToUpdate);
                this.scheduledToUpdate.clear();
                for (int i = 0; i < this.strengths.length; ++i) {
                    this.strengths[i] = this.updatedStrength[i];
                    this.strong[i] = this.updatedStrong[i];
                }
                for (BlockPos coordinate : coordinates) {
                    this.notifyUpdate(coordinate, true);
                }
            }
        }
    }

    private void updatePulses() {
        boolean updateClient = false;
        for (int i = 0; i < EnumFacing.values().length; ++i) {
            Iterator<PulseTimer> iterator = this.pulseTimers[i].iterator();
            while (iterator.hasNext()) {
                PulseTimer timer = iterator.next();
                timer.ticks--;
                if (timer.ticks != 0) continue;
                if (this.updatedStrength[i] != timer.strength || this.updatedStrong[i] == timer.strong) {
                    this.updatedStrength[i] = timer.strength;
                    this.updatedStrong[i] = timer.strong;
                    this.addBlockScheduledForUpdate(EnumFacing.func_82600_a((int)i));
                    updateClient = true;
                }
                iterator.remove();
            }
        }
        if (updateClient) {
            PacketHandler.sendBlockPacket(this, null, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void keepClientDataUpdated() {
        if (this.isPartOfCluster()) {
            return;
        }
        double distance = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        if (distance > Math.pow(128.0, 2.0)) {
            this.hasUpdatedData = false;
        } else if (!this.hasUpdatedData && distance < Math.pow(123.0, 2.0)) {
            this.hasUpdatedData = true;
            PacketHandler.sendBlockPacket(this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0);
        }
    }

    @Override
    public int[] getPower() {
        return this.updatedStrength;
    }

    @Override
    protected EnumSet<ClusterMethodRegistration> getRegistrations() {
        return EnumSet.of(ClusterMethodRegistration.CAN_CONNECT_REDSTONE, ClusterMethodRegistration.SHOULD_CHECK_WEAK_POWER, ClusterMethodRegistration.IS_PROVIDING_WEAK_POWER, ClusterMethodRegistration.IS_PROVIDING_STRONG_POWER);
    }

    private class PulseTimer {
        private int strength;
        private boolean strong;
        private int ticks;

        private PulseTimer(int strength, boolean strong, int ticks) {
            this.strength = strength;
            this.strong = strong;
            this.ticks = ticks;
        }
    }
}

