/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.wrappers;

import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityHelper {
    public static boolean hasFluidCapabilitySafe(TileEntity tileEntity) {
        try {
            return tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static IFluidHandler getFluidCapabilitySafe(TileEntity tileEntity) {
        try {
            return (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasItemCapabilitySafe(TileEntity tileEntity) {
        try {
            return tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static IItemHandler getItemCapabilitySafe(TileEntity tileEntity) {
        try {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

