/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.wrappers;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import vswe.stevesfactory.wrappers.CapabilityHelper;
import vswe.stevesfactory.wrappers.EnumInventoryType;

public class InventoryHelper {
    public EnumInventoryType getType(TileEntity tileEntity) {
        if (tileEntity instanceof IInventory) {
            return EnumInventoryType.IInventory;
        }
        if (CapabilityHelper.hasItemCapabilitySafe(tileEntity)) {
            return EnumInventoryType.Capability;
        }
        return null;
    }

    public ItemStack getStackInSlot(TileEntity tileEntity, int id) {
        if (this.getType(tileEntity) == EnumInventoryType.IInventory) {
            return ((IInventory)tileEntity).func_70301_a(id);
        }
        if (this.getType(tileEntity) == EnumInventoryType.Capability) {
            ((IItemHandler)tileEntity).getStackInSlot(id);
        }
        return null;
    }

    public boolean isItemValidForSlot(TileEntity tileEntity, ItemStack stack, int id) {
        if (this.getType(tileEntity) == EnumInventoryType.IInventory) {
            return ((IInventory)tileEntity).func_94041_b(id, stack);
        }
        if (this.getType(tileEntity) == EnumInventoryType.Capability) {
            return ((IItemHandler)tileEntity).insertItem(id, stack, true) != stack;
        }
        return false;
    }

    public boolean isSlotEmpty(TileEntity tileEntity, int id) {
        if (this.getType(tileEntity) == EnumInventoryType.IInventory) {
            return ((IInventory)tileEntity).func_70301_a(id) == null;
        }
        if (this.getType(tileEntity) == EnumInventoryType.Capability) {
            return ((IItemHandler)tileEntity).getStackInSlot(id) == null;
        }
        return false;
    }
}

