/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.api.logic;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.api.StevesFactoryManagerAPI;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.DeserializationContext;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.api.logic.ITrigger;
import vswe.stevesfactory.api.logic.SerializationContext;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.library.collections.CompositeUnmodifiableList;

public final class ProcedureGraph {
    private List<ITrigger> triggers = new ArrayList<ITrigger>();
    private List<IProcedure> regulars = new ArrayList<IProcedure>();
    private List<IProcedure> all;

    public static ProcedureGraph create() {
        return new ProcedureGraph();
    }

    private ProcedureGraph() {
        List<ITrigger> triggers = this.triggers;
        List<IProcedure> regulars = this.regulars;
        this.all = CompositeUnmodifiableList.of(triggers, regulars);
    }

    public void tick(INetworkController controller) {
        for (ITrigger proc : this.triggers) {
            proc.tick(controller);
        }
    }

    public void addProcedure(IProcedure procedure) {
        if (procedure instanceof ITrigger) {
            this.triggers.add((ITrigger)procedure);
        } else {
            this.regulars.add(procedure);
        }
    }

    public void addProcedure(ITrigger trigger) {
        this.triggers.add(trigger);
    }

    public List<ITrigger> getTriggers() {
        return this.triggers;
    }

    public List<IProcedure> getRegulars() {
        return this.regulars;
    }

    public List<IProcedure> getAllProcedures() {
        return this.all;
    }

    public Iterator<ITrigger> iteratorValidTriggers() {
        return ProcedureGraph.createValidOnlyIter(this.triggers);
    }

    public Iterator<IProcedure> iteratorValidRegulars() {
        return ProcedureGraph.createValidOnlyIter(this.regulars);
    }

    public Iterator<IProcedure> iteratorValidAll() {
        return ProcedureGraph.createValidOnlyIter(this.all);
    }

    public Iterable<ITrigger> iterableValidTriggers() {
        return () -> ProcedureGraph.createValidOnlyIter(this.triggers);
    }

    public Iterable<IProcedure> iterableValidRegulars() {
        return () -> ProcedureGraph.createValidOnlyIter(this.regulars);
    }

    public Iterable<IProcedure> iterableValidAll() {
        return () -> ProcedureGraph.createValidOnlyIter(this.all);
    }

    private static <T extends IProcedure> Iterator<T> createValidOnlyIter(final List<T> list) {
        return new Iterator<T>(){
            private Iterator<T> backing;
            {
                this.backing = list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.backing.hasNext();
            }

            @Override
            public T next() {
                IProcedure t;
                while (!(t = (IProcedure)this.backing.next()).isValid()) {
                }
                return t;
            }
        };
    }

    public void invalidateContent() {
        for (IProcedure procedure : this.all) {
            procedure.invalidate();
        }
    }

    public void cleanInvalidated() {
        this.triggers.removeIf(p -> !p.isValid());
        this.regulars.removeIf(p -> !p.isValid());
    }

    public CompoundNBT serialize() {
        CompoundNBT tag = new CompoundNBT();
        Object2IntMap<IProcedure> idMap = this.createIDMap();
        SerializationContext ctx = new SerializationContext((Object2IntFunction<IProcedure>)((Object2IntFunction)p -> idMap.getOrDefault(p, -1)));
        ListNBT nodesNBT = new ListNBT();
        for (Object2IntMap.Entry entry : idMap.object2IntEntrySet()) {
            IProcedure node = (IProcedure)entry.getKey();
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("ID", entry.getIntValue());
            nbt.func_218657_a("Data", (INBT)node.serialize());
            CompoundNBT extra = node.serializeExtra(ctx);
            if (extra != null) {
                nbt.func_218657_a("Extra", (INBT)extra);
            }
            nodesNBT.add((Object)nbt);
        }
        tag.func_218657_a("Nodes", (INBT)nodesNBT);
        tag.func_74768_a("MaxID", idMap.size());
        ListNBT connectionsNBT = new ListNBT();
        HashSet<Connection> visited = new HashSet<Connection>();
        for (IProcedure node : idMap.keySet()) {
            for (Connection successor : node.successors()) {
                if (successor == null || visited.contains(successor)) continue;
                visited.add(successor);
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("FromID", ctx.identify(successor.getSource()));
                nbt.func_74768_a("FromIdx", successor.getSourceOutputIndex());
                nbt.func_74768_a("ToID", ctx.identify(successor.getDestination()));
                nbt.func_74768_a("ToIdx", successor.getDestinationInputIndex());
                nbt.func_197644_a("PolylineNodes", successor.toPolylineData());
                connectionsNBT.add((Object)nbt);
            }
        }
        tag.func_218657_a("Connections", (INBT)connectionsNBT);
        return tag;
    }

    private Object2IntMap<IProcedure> createIDMap() {
        Object2IntOpenHashMap idMap = new Object2IntOpenHashMap(this.all.size());
        for (IProcedure node : this.all) {
            if (!node.isValid()) continue;
            idMap.put((Object)node, idMap.size());
        }
        return idMap;
    }

    public void deserialize(CompoundNBT tag) {
        this.invalidateContent();
        this.triggers.clear();
        this.regulars.clear();
        ListNBT nodesNBT = tag.func_150295_c("Nodes", 10);
        int maxID = tag.func_74762_e("MaxID");
        IProcedure[] nodes = new IProcedure[maxID];
        CompoundNBT[] extras = new CompoundNBT[maxID];
        for (int i2 = 0; i2 < nodesNBT.size(); ++i2) {
            CompoundNBT nodeNBT = nodesNBT.func_150305_b(i2);
            int id = nodeNBT.func_74762_e("ID");
            nodes[id] = this.deserializeNode(nodeNBT.func_74775_l("Data"));
            extras[id] = nodeNBT.func_74764_b("Extra") ? nodeNBT.func_74775_l("Extra") : null;
        }
        ListNBT connectionNBT = tag.func_150295_c("Connections", 10);
        for (int i3 = 0; i3 < connectionNBT.size(); ++i3) {
            CompoundNBT nbt = connectionNBT.func_150305_b(i3);
            IProcedure from = nodes[nbt.func_74762_e("FromID")];
            int fromIdx = nbt.func_74762_e("FromIdx");
            IProcedure to = nodes[nbt.func_74762_e("ToID")];
            int toIdx = nbt.func_74762_e("ToIdx");
            long[] polylineNodes = nbt.func_197645_o("PolylineNodes");
            Connection.create(from, fromIdx, to, toIdx).fromPolylineData(polylineNodes);
        }
        DeserializationContext ctx = new DeserializationContext(i -> i < 0 || i >= nodes.length ? null : nodes[i]);
        for (int i4 = 0; i4 < nodes.length; ++i4) {
            nodes[i4].deserializeExtra(extras[i4], ctx);
        }
        for (IProcedure node : nodes) {
            this.addProcedure(node);
        }
    }

    private IProcedure deserializeNode(CompoundNBT tag) {
        ResourceLocation id = new ResourceLocation(tag.func_74779_i("ID"));
        IProcedureType p = (IProcedureType)StevesFactoryManagerAPI.getProceduresRegistry().getValue(id);
        Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)("Unable to find a procedure registered as " + id + "!"));
        return p.retrieveInstance(tag);
    }
}

