/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.capability.CapabilityEventDispatchers;
import vswe.stevesfactory.api.capability.IBUDEventDispatcher;
import vswe.stevesfactory.api.network.ICable;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.setup.ModBlocks;
import vswe.stevesfactory.utils.NetworkHelper;

public class BUDTileEntity
extends TileEntity
implements ICable,
IBUDEventDispatcher {
    private List<Predicate<BlockPos>> handlers = new ArrayList<Predicate<BlockPos>>();
    private LazyOptional<IBUDEventDispatcher> capability = LazyOptional.of(() -> this);

    public BUDTileEntity() {
        super(ModBlocks.budTileEntity);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEventDispatchers.BUD_EVENT_DISPATCHER_CAPABILITY) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onNeighborChanged(BlockPos fromPos) {
        this.handlers.removeIf(handler -> handler.test(fromPos));
    }

    @Override
    public void subscribe(Consumer<BlockPos> handler) {
        this.subscribe((BlockPos event) -> {
            handler.accept((BlockPos)event);
            return false;
        });
    }

    @Override
    public void subscribe(Predicate<BlockPos> handler) {
        this.handlers.add(handler);
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public boolean isCable() {
        return (Boolean)Config.COMMON.isBUDBlockCables.get();
    }

    @Override
    public void addLinksFor(INetworkController controller) {
        NetworkHelper.updateLinksFor(controller, this);
    }
}

