/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.api.capability.CapabilityDocuments;
import vswe.stevesfactory.api.capability.ITextDocument;
import vswe.stevesfactory.setup.ModBlocks;

public class SignUpdaterTileEntity
extends TileEntity
implements ITextDocument {
    private static final ITextComponent EMPTY_TEXT_COMPONENT = new StringTextComponent("");
    private LazyOptional<ITextDocument> textDisplayCap = LazyOptional.of(() -> this);
    private SignTileEntity cachedSign;
    private long updatedTick = -1L;

    public SignUpdaterTileEntity() {
        super(ModBlocks.signUpdaterTileEntity);
    }

    public Direction getFacing() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
    }

    public boolean hasSignAttached() {
        assert (this.field_145850_b != null);
        BlockPos neighbor = this.field_174879_c.func_177972_a(this.getFacing());
        return this.field_145850_b.func_180495_p(neighbor).func_177230_c() instanceof AbstractSignBlock;
    }

    public SignTileEntity getSignAttached() {
        assert (this.field_145850_b != null);
        BlockPos neighbor = this.field_174879_c.func_177972_a(this.getFacing());
        return (SignTileEntity)Objects.requireNonNull(this.field_145850_b.func_175625_s(neighbor));
    }

    @Nullable
    public SignTileEntity getSignAttachedNullable() {
        assert (this.field_145850_b != null);
        BlockPos neighbor = this.field_174879_c.func_177972_a(this.getFacing());
        TileEntity tile = this.field_145850_b.func_175625_s(neighbor);
        if (tile instanceof SignTileEntity) {
            return (SignTileEntity)tile;
        }
        return null;
    }

    void invalidateSignCache() {
        this.cachedSign = null;
    }

    boolean isSignCacheValid() {
        return this.cachedSign != null;
    }

    @Nullable
    private SignTileEntity getCachedSign() {
        if (!this.isSignCacheValid()) {
            this.cachedSign = this.getSignAttachedNullable();
        }
        return this.cachedSign;
    }

    @Override
    public int getLines() {
        return 4;
    }

    @Override
    public ITextComponent getLine(int line) {
        SignTileEntity sign = this.getCachedSign();
        if (sign == null) {
            return EMPTY_TEXT_COMPONENT;
        }
        return sign.func_212366_a(line);
    }

    @Override
    public void setLine(int line, ITextComponent text) {
        SignTileEntity sign = this.getCachedSign();
        if (sign != null) {
            sign.func_212365_a(line, text);
            this.syncData();
        }
    }

    @Override
    public void addLine(ITextComponent line) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ITextComponent> view() {
        SignTileEntity sign = this.getCachedSign();
        if (sign == null) {
            return ImmutableList.of();
        }
        return Arrays.asList(sign.field_145915_a);
    }

    @Override
    public Stream<ITextComponent> stream() {
        SignTileEntity sign = this.getCachedSign();
        if (sign == null) {
            return Stream.empty();
        }
        return Arrays.stream(sign.field_145915_a);
    }

    @Override
    public Stream<String> textStream() {
        return this.stream().map(ITextComponent::func_150254_d);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityDocuments.TEXT_DISPLAY_CAPABILITY) {
            return this.textDisplayCap.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        this.textDisplayCap.invalidate();
        super.invalidateCaps();
    }

    public void syncData() {
        assert (this.field_145850_b != null);
        if (this.updatedTick == this.field_145850_b.func_82737_E()) {
            return;
        }
        BlockPos neighbor = this.field_174879_c.func_177972_a(this.getFacing());
        BlockState neighborState = this.field_145850_b.func_180495_p(neighbor);
        this.field_145850_b.func_184138_a(neighbor, neighborState, neighborState, 3);
        this.updatedTick = this.field_145850_b.func_82737_E();
    }
}

