/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IWidget;

public final class RenderingHelper {
    private static int translationX = 0;
    private static int translationY = 0;
    private static boolean active = false;
    public static final int LEFT_BORDER = 2;

    private RenderingHelper() {
    }

    public static BufferBuilder getRenderer() {
        return Tessellator.func_178181_a().func_178180_c();
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static FontRenderer fontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static int fontHeight() {
        RenderingHelper.fontRenderer().getClass();
        return 9;
    }

    public static int textWidth(String text) {
        return RenderingHelper.fontRenderer().func_78256_a(text);
    }

    public static int textWidth(String text, int fontHeight) {
        FontRenderer fr = RenderingHelper.fontRenderer();
        float f = fontHeight;
        fr.getClass();
        float scale = f / 9.0f;
        return (int)((float)fr.func_78256_a(text) * scale);
    }

    public static void useGradientGLStates() {
        GlStateManager.disableTexture();
        GlStateManager.disableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.shadeModel((int)7425);
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void useBlendingGLStates() {
        GlStateManager.disableTexture();
        GlStateManager.disableAlphaTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void usePlainColorGLStates() {
        GlStateManager.disableTexture();
        GlStateManager.disableBlend();
    }

    public static void useTextureGLStates() {
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawRect(Rectangle rect, int color) {
        RenderingHelper.drawRect(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, color);
    }

    public static void drawRect(Point point, Dimension dimensions, int red, int green, int blue, int alpha) {
        RenderingHelper.drawRect(point.x, point.y, point.x + dimensions.width, point.y + dimensions.height, red, green, blue, alpha);
    }

    public static void drawRect(Point point, Dimension dimensions, int color) {
        RenderingHelper.drawRect(point.x, point.y, point.x + dimensions.width, point.y + dimensions.width, color);
    }

    public static void drawRect(int x, int y, Dimension dimensions, int red, int green, int blue, int alpha) {
        RenderingHelper.drawRect(x, y, x + dimensions.width, y + dimensions.height, red, green, blue, alpha);
    }

    public static void drawRect(int x, int y, Dimension dimensions, int color) {
        RenderingHelper.drawRect(x, y, x + dimensions.width, y + dimensions.height, color);
    }

    public static void drawRect(int x, int y, int x2, int y2, int red, int green, int blue, int alpha) {
        GlStateManager.disableTexture();
        RenderingHelper.getRenderer().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderingHelper.rectVertices(x, y, x2, y2, red, green, blue, alpha);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawRect(int x, int y, int x2, int y2, int color) {
        GlStateManager.disableTexture();
        RenderingHelper.getRenderer().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderingHelper.rectVertices(x, y, x2, y2, color);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void rectVertices(int x, int y, int x2, int y2, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        RenderingHelper.rectVertices(x, y, x2, y2, red, green, blue, alpha);
    }

    public static void rectVertices(int x, int y, int x2, int y2, int red, int green, int blue, int alpha) {
        BufferBuilder renderer = RenderingHelper.getRenderer();
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x, (double)y2, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x2, (double)y2, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x2, (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
    }

    public static void drawColorLogic(int x, int y, int width, int height, int red, int green, int blue, GlStateManager.LogicOp logicOp) {
        GlStateManager.disableTexture();
        GlStateManager.enableColorLogicOp();
        GlStateManager.logicOp((GlStateManager.LogicOp)logicOp);
        RenderingHelper.drawRect(x, y, x + width, y + height, red, green, blue, 255);
        GlStateManager.disableColorLogicOp();
        GlStateManager.enableTexture();
    }

    public static void drawThickBeveledBox(int x1, int y1, int x2, int y2, int thickness, int topLeftColor, int bottomRightColor, int fillColor) {
        GlStateManager.disableTexture();
        RenderingHelper.drawRect(x1, y1, x2, y2, bottomRightColor);
        RenderingHelper.drawRect(x1, y1, x2 - thickness, y2 - thickness, topLeftColor);
        if (fillColor != -1) {
            RenderingHelper.drawRect(x1 + thickness, y1 + thickness, x2 - thickness, y2 - thickness, fillColor);
        }
        GlStateManager.enableTexture();
    }

    public static void drawVerticalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        RenderingHelper.useGradientGLStates();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x2, (double)y1, 0.0).func_181669_b(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, 0.0).func_181669_b(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y2, 0.0).func_181669_b(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181669_b(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    public static void drawHorizontalGradientRect(int x1, int y1, int x2, int y2, int color1, int color2) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        RenderingHelper.useGradientGLStates();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)x1, (double)y1, 0.0).func_181669_b(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y2, 0.0).func_181669_b(r1, g1, b1, a1).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181669_b(r2, g2, b2, a2).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, 0.0).func_181669_b(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    public static void drawTexture(int x1, int y1, int x2, int y2, float z, ResourceLocation texture, float u1, float v1, float u2, float v2) {
        GlStateManager.enableTexture();
        GlStateManager.disableLighting();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderingHelper.bindTexture(texture);
        BufferBuilder buffer = RenderingHelper.getRenderer();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RenderingHelper.textureVertices(x1, y1, x2, y2, z, u1, v1, u2, v2);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void textureVertices(int x1, int y1, int x2, int y2, float z, float u1, float v1, float u2, float v2) {
        BufferBuilder buffer = RenderingHelper.getRenderer();
        buffer.func_181662_b((double)x1, (double)y1, (double)z).func_187315_a((double)u1, (double)v1).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y2, (double)z).func_187315_a((double)u1, (double)v2).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, (double)z).func_187315_a((double)u2, (double)v2).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, (double)z).func_187315_a((double)u2, (double)v1).func_181675_d();
    }

    public static void drawTexture(int x1, int y1, int x2, int y2, ResourceLocation texture, float u1, float v1, float u2, float v2) {
        RenderingHelper.drawTexture(x1, y1, x2, y2, 0.0f, texture, u1, v1, u2, v2);
    }

    public static void drawTexturePortion(int x1, int y1, int x2, int y2, float z, ResourceLocation texture, int textureWidth, int textureHeight, int tx, int ty, int portionWidth, int portionHeight) {
        float uFactor = 1.0f / (float)textureWidth;
        float vFactor = 1.0f / (float)textureHeight;
        int tx2 = tx + portionWidth;
        int ty2 = ty + portionHeight;
        RenderingHelper.drawTexture(x1, y1, x2, y2, z, texture, (float)tx * uFactor, (float)ty * vFactor, (float)tx2 * uFactor, (float)ty2 * vFactor);
    }

    public static void drawTexturePortion(int x1, int y1, int x2, int y2, ResourceLocation texture, int textureWidth, int textureHeight, int tx, int ty, int portionWidth, int portionHeight) {
        RenderingHelper.drawTexturePortion(x1, y1, x2, y2, 0.0f, texture, textureWidth, textureHeight, tx, ty, portionWidth, portionHeight);
    }

    public static void drawCompleteTexture(int x1, int y1, int x2, int y2, float z, ResourceLocation texture) {
        RenderingHelper.drawTexture(x1, y1, x2, y2, z, texture, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawCompleteTexture(int x1, int y1, int x2, int y2, ResourceLocation texture) {
        RenderingHelper.drawCompleteTexture(x1, y1, x2, y2, 0.0f, texture);
    }

    public static void drawTexture256x256(int x1, int y1, int x2, int y2, ResourceLocation texture, int tx, int ty, int portionWidth, int portionHeight) {
        RenderingHelper.drawTexturePortion(x1, y1, x2, y2, texture, 256, 256, tx, ty, portionWidth, portionHeight);
    }

    public static int getCenterXFor(IWidget widget) {
        return widget.getAbsoluteX() + widget.getWidth() / 2;
    }

    public static int getCenterYFor(IWidget widget) {
        return widget.getAbsoluteY() + widget.getHeight() / 2;
    }

    public static int getXForAlignedRight(int right, int width) {
        return right - width;
    }

    public static int getXForAlignedCenter(int left, int right, int width) {
        return left + (right - left) / 2 - width / 2;
    }

    public static int getYForAlignedCenter(int top, int bottom, int height) {
        return top + (bottom - top) / 2 - height / 2;
    }

    public static int getYForAlignedBottom(int bottom, int height) {
        return bottom - height;
    }

    public static int getXForHorizontallyCenteredText(String text, int left, int right) {
        int textWidth = RenderingHelper.fontRenderer().func_78256_a(text);
        return RenderingHelper.getXForAlignedCenter(left, right, textWidth);
    }

    public static int getYForVerticallyCenteredText(int top, int bottom) {
        return RenderingHelper.getYForAlignedCenter(top, bottom, RenderingHelper.fontHeight());
    }

    public static void drawTextCenteredVertically(String text, int leftX, int top, int bottom, int color) {
        int y = RenderingHelper.getYForVerticallyCenteredText(top, bottom);
        GlStateManager.enableTexture();
        RenderingHelper.fontRenderer().func_211126_b(text, (float)leftX, (float)y, color);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextCenteredHorizontally(String text, int left, int right, int topY, int color) {
        int x = RenderingHelper.getXForHorizontallyCenteredText(text, left, right);
        GlStateManager.enableTexture();
        RenderingHelper.fontRenderer().func_211126_b(text, (float)x, (float)topY, color);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextCentered(String text, int top, int bottom, int left, int right, int color) {
        int x = RenderingHelper.getXForHorizontallyCenteredText(text, left, right);
        int y = RenderingHelper.getYForVerticallyCenteredText(top, bottom);
        GlStateManager.enableTexture();
        RenderingHelper.fontRenderer().func_211126_b(text, (float)x, (float)y, color);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawText(String text, int x, int y, int fontHeight, int color) {
        FontRenderer fr = RenderingHelper.fontRenderer();
        float f = fontHeight;
        fr.getClass();
        float scale = f / 9.0f;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)0.0f);
        GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
        fr.func_211126_b(text, 0.0f, 0.0f, color);
        GlStateManager.popMatrix();
    }

    public static void drawTextCenteredVertically(String text, int x, int top, int bottom, int fontHeight, int color) {
        int y = RenderingHelper.getYForVerticallyCenteredText(top, bottom);
        GlStateManager.enableTexture();
        RenderingHelper.drawText(text, x, y, fontHeight, color);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextCenteredHorizontally(String text, int left, int right, int y, int fontHeight, int color) {
        int x = RenderingHelper.getXForHorizontallyCenteredText(text, left, right);
        GlStateManager.enableTexture();
        RenderingHelper.drawText(text, x, y, fontHeight, color);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextCentered(String text, int top, int bottom, int left, int right, int fontHeight, int color) {
        int x = RenderingHelper.getXForHorizontallyCenteredText(text, left, right);
        int y = RenderingHelper.getYForVerticallyCenteredText(top, bottom);
        GlStateManager.enableTexture();
        RenderingHelper.drawText(text, x, y, fontHeight, color);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTextWithShadow(String text, int x, int y, int fontHeight, int color) {
        FontRenderer fr = RenderingHelper.fontRenderer();
        float f = fontHeight;
        fr.getClass();
        float scale = f / 9.0f;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)0.0f);
        GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
        fr.func_175063_a(text, 0.0f, 0.0f, color);
        GlStateManager.popMatrix();
    }

    public static void drawVerticalText(String text, int x, int y, int fontHeight, int color) {
        FontRenderer fr = RenderingHelper.fontRenderer();
        float f = fontHeight;
        fr.getClass();
        float scale = f / 9.0f;
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(x + fontHeight), (float)y, (float)0.0f);
        GlStateManager.rotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
        fr.func_211126_b(text, 0.0f, 0.0f, color);
        GlStateManager.popMatrix();
    }

    public static ResourceLocation linkTexture(String path) {
        return new ResourceLocation("sfm", "textures/" + path);
    }

    public static ResourceLocation linkTexture(String seg1, String seg2) {
        return new ResourceLocation("sfm", "textures/" + seg1 + "/" + seg2);
    }

    public static ResourceLocation linkTexture(String seg1, String seg2, String seg3) {
        return new ResourceLocation("sfm", "textures/" + seg1 + "/" + seg2 + "/" + seg3);
    }

    public static ResourceLocation linkTexture(String ... segments) {
        StringBuilder path = new StringBuilder("textures/");
        for (String segment : segments) {
            path.append(segment).append("/");
        }
        return new ResourceLocation("sfm", path.toString());
    }

    public static int getTranslationX() {
        return active ? translationX : 0;
    }

    public static int getTranslationY() {
        return active ? translationY : 0;
    }

    public static int getPrevTranslationX() {
        return translationX;
    }

    public static int getPrevTranslationY() {
        return translationY;
    }

    public static void translate(int x, int y) {
        translationX = x;
        translationY = y;
        active = true;
    }

    public static void clearTranslation() {
        active = false;
    }

    public static void renderSideLine(AbstractWidget widget) {
        GlStateManager.disableTexture();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int x1 = widget.getAbsoluteX();
        int x2 = x1 + 2;
        int y1 = widget.getAbsoluteY() - 1;
        int y2 = widget.getAbsoluteYBottom() + 1;
        RenderingHelper.rectVertices(x1, y1, x2, y2, -8816263);
        RenderingHelper.rectVertices(x1 + 1, y1, x2, y2, -1);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableTexture();
    }
}

