/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.contextmenu;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.window.AbstractPopupWindow;

public class ContextMenu
extends AbstractPopupWindow {
    public static final int MIN_DISTANCE = 4;
    private final List<? extends IEntry> entries;
    private IEntry focusedEntry;

    public static ContextMenu atCursor(List<? extends IEntry> entries) {
        MouseHelper m = Minecraft.func_71410_x().field_71417_B;
        double scale = Minecraft.func_71410_x().field_195558_d.func_198100_s();
        double mouseX = m.func_198024_e() / scale;
        double mouseY = m.func_198026_f() / scale;
        return ContextMenu.atCursor(mouseX + (double)RenderingHelper.getTranslationX(), mouseY + (double)RenderingHelper.getTranslationY(), entries);
    }

    public static ContextMenu atCursor(double mouseX, double mouseY, List<? extends IEntry> entries) {
        return new ContextMenu((int)mouseX + RenderingHelper.getTranslationX(), (int)mouseY + RenderingHelper.getTranslationY(), entries);
    }

    public ContextMenu(int x, int y, List<? extends IEntry> entries) {
        Preconditions.checkArgument((!entries.isEmpty() ? 1 : 0) != 0);
        this.entries = entries;
        this.setPosition(x, y);
        for (IEntry iEntry : entries) {
            iEntry.attach(this);
        }
        this.reflow();
    }

    /*
     * WARNING - void declaration
     */
    public void reflow() {
        void var5_10;
        int width = this.entries.stream().max(Comparator.comparingInt(IWidget::getWidth)).orElseThrow(IllegalArgumentException::new).getWidth();
        int height = this.entries.stream().mapToInt(IWidget::getHeight).sum();
        this.setContents(width, height);
        int ey = 0;
        for (IEntry iEntry : this.entries) {
            iEntry.setLocation(0, ey);
            iEntry.setWidth(this.contents.width);
            ey += iEntry.getHeight();
        }
        int xOff = 0;
        boolean bl = false;
        int left = this.getX() - 4;
        if (left < 0) {
            xOff = left;
        } else {
            int right = this.getX() + this.getWidth() + 4;
            if (right > WidgetScreen.screenWidth()) {
                xOff = right - WidgetScreen.screenWidth();
            }
        }
        int top = this.getY() - 4;
        if (top < 0) {
            int n = top;
        } else {
            int bottom = this.getY() + this.getHeight() + 4;
            if (bottom > WidgetScreen.screenHeight()) {
                int n = bottom - WidgetScreen.screenHeight();
            }
        }
        this.move(-xOff, (int)(-var5_10));
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        RenderingHelper.drawRect(this.position, this.border, 75, 75, 75, 255);
        RenderingHelper.drawRect(this.getContentX(), this.getContentY(), this.contents, 61, 61, 61, 255);
        for (IEntry iEntry : this.entries) {
            iEntry.render(mouseX, mouseY, particleTicks);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isInside(mouseX, mouseY)) {
            this.alive = false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public IWidget getFocusedWidget() {
        return this.focusedEntry;
    }

    @Override
    public void setFocusedWidget(@Nullable IWidget widget) {
        if (widget instanceof IEntry || widget == null) {
            if (this.focusedEntry != null) {
                this.focusedEntry.onFocusChanged(false);
            }
            this.focusedEntry = (IEntry)widget;
            if (widget != null) {
                widget.onFocusChanged(true);
            }
        }
    }

    public List<? extends IEntry> getChildren() {
        return this.entries;
    }

    @Override
    public boolean shouldDrag() {
        return false;
    }

    @Override
    public int getBorderSize() {
        return 1;
    }
}

