/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.debug;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.IRenderEventListener;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.window.IWindow;

public abstract class Inspections
implements IRenderEventListener {
    public static final Inspections INSTANCE = new Inspections(){

        @Override
        public void onPreRender(IWidget widget, int mx, int my) {
        }

        @Override
        public void onPreRender(IWindow window, int mx, int my) {
        }

        @Override
        public void onPostRender(IWidget widget, int mx, int my) {
            this.tryRender(widget, mx, my);
        }

        @Override
        public void onPostRender(IWindow window, int mx, int my) {
            this.tryRender(window, mx, my);
        }
    };
    private static final ITextReceiver DEFAULT_INFO_RENDERER = new ITextReceiver(){
        private static final int STARTING_X = 1;
        private static final int STARTING_Y = 1;
        private int x;
        private int y;
        {
            this.reset();
        }

        @Override
        public void reset() {
            this.x = 1;
            this.y = 1;
        }

        @Override
        public void string(String text) {
            RenderingHelper.fontRenderer().func_211126_b(text, (float)this.x, (float)this.y, Color.WHITE.getRGB());
            this.x += RenderingHelper.fontRenderer().func_78256_a(text);
        }

        @Override
        public void line(String line) {
            RenderingHelper.fontRenderer().func_211126_b(line, 1.0f, (float)this.y, Color.WHITE.getRGB());
            this.nextLine();
        }

        @Override
        public void nextLine() {
            this.x = 1;
            this.y += RenderingHelper.fontHeight() + 2;
        }
    };
    public static final int CONTENTS = 1713805055;
    public static final int BORDER = -1998353854;
    public static final int BORDER_A = 136;
    public static final int BORDER_R = 227;
    public static final int BORDER_G = 138;
    public static final int BORDER_B = 66;

    public static boolean isEnabled() {
        return (Boolean)Config.CLIENT.enableInspections.get();
    }

    public final boolean tryRender(IWidget widget, int mx, int my) {
        if (!Inspections.isEnabled()) {
            return false;
        }
        if (widget.isInside(mx, my) && this.shouldRender(widget, mx, my)) {
            this.renderBox(widget);
            if (Screen.hasControlDown()) {
                this.renderOverlayInfo(widget);
            }
            return true;
        }
        return false;
    }

    public final boolean tryRender(IWindow window, int mx, int my) {
        if (!Inspections.isEnabled()) {
            return false;
        }
        if (window.isInside(mx, my) && this.shouldRender(window, mx, my)) {
            this.renderBox(window);
            if (Screen.hasControlDown()) {
                this.renderOverlayInfo(window);
            }
            return true;
        }
        return false;
    }

    public boolean shouldRender(IWidget widget, int mx, int my) {
        return true;
    }

    public boolean shouldRender(IWindow window, int mx, int my) {
        return true;
    }

    public void renderBox(IWidget widget) {
        int ax = widget.getAbsoluteX();
        int ay = widget.getAbsoluteY();
        RenderingHelper.useBlendingGLStates();
        RenderingHelper.drawRect(ax, ay, ax + widget.getWidth(), ay + widget.getHeight(), 1713805055);
        RenderingHelper.useTextureGLStates();
    }

    public void renderBox(IWindow window) {
        RenderingHelper.useBlendingGLStates();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int x = window.getX();
        int y = window.getY();
        int x2 = x + window.getWidth();
        int y2 = y + window.getHeight();
        int bs = window.getBorderSize();
        RenderingHelper.rectVertices(x, y, x2 - bs, y + bs, 227, 138, 66, 136);
        RenderingHelper.rectVertices(x2 - bs, y, x2, y2 - bs, 227, 138, 66, 136);
        RenderingHelper.rectVertices(x + bs, y2 - bs, x2, y2, 227, 138, 66, 136);
        RenderingHelper.rectVertices(x, y + bs, x + bs, y2, 227, 138, 66, 136);
        int cx = window.getContentX();
        int cy = window.getContentY();
        RenderingHelper.rectVertices(cx, cy, cx + window.getContentWidth(), cy + window.getContentHeight(), 1713805055);
        Tessellator.func_178181_a().func_78381_a();
        RenderingHelper.useTextureGLStates();
    }

    public void renderOverlayInfo(IWidget widget) {
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        DEFAULT_INFO_RENDERER.reset();
        if (widget instanceof IInspectionInfoProvider) {
            ((IInspectionInfoProvider)((Object)widget)).provideInformation(DEFAULT_INFO_RENDERER);
        } else {
            this.defaultOverlayInfo(widget);
        }
        GlStateManager.popMatrix();
    }

    public void renderOverlayInfo(IWindow window) {
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        DEFAULT_INFO_RENDERER.reset();
        if (window instanceof IInspectionInfoProvider) {
            ((IInspectionInfoProvider)((Object)window)).provideInformation(DEFAULT_INFO_RENDERER);
        } else {
            this.defaultOverlayInfo(window);
        }
        GlStateManager.popMatrix();
    }

    protected void defaultOverlayInfo(IWidget widget) {
        DEFAULT_INFO_RENDERER.line("(default inspection info)");
        DEFAULT_INFO_RENDERER.line(widget.toString());
        DEFAULT_INFO_RENDERER.line("X=" + widget.getX());
        DEFAULT_INFO_RENDERER.line("Y=" + widget.getY());
        DEFAULT_INFO_RENDERER.line("AbsX=" + widget.getAbsoluteX());
        DEFAULT_INFO_RENDERER.line("AbsY=" + widget.getAbsoluteY());
        DEFAULT_INFO_RENDERER.line("Width=" + widget.getWidth());
        DEFAULT_INFO_RENDERER.line("Height=" + widget.getHeight());
    }

    protected void defaultOverlayInfo(IWindow window) {
        DEFAULT_INFO_RENDERER.line("(default inspection info)");
        DEFAULT_INFO_RENDERER.line(window.toString());
        DEFAULT_INFO_RENDERER.line("X=" + window.getX());
        DEFAULT_INFO_RENDERER.line("Y=" + window.getY());
        DEFAULT_INFO_RENDERER.line("Width=" + window.getWidth());
        DEFAULT_INFO_RENDERER.line("Height=" + window.getHeight());
        DEFAULT_INFO_RENDERER.line("ContentX=" + window.getContentX());
        DEFAULT_INFO_RENDERER.line("ContentY=" + window.getContentY());
        DEFAULT_INFO_RENDERER.line("ContentWidth=" + window.getContentWidth());
        DEFAULT_INFO_RENDERER.line("ContentHeight=" + window.getContentHeight());
        DEFAULT_INFO_RENDERER.line("BorderSize=" + window.getBorderSize());
    }

    public static interface IInspectionInfoProvider {
        public void provideInformation(ITextReceiver var1);
    }
}

