/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.awt.Point;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IButton;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public abstract class AbstractIconButton
extends AbstractWidget
implements IButton,
LeafWidgetMixin {
    private boolean hovered = false;
    private boolean clicked = false;

    public AbstractIconButton(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public AbstractIconButton(Point location, Dimension dimensions) {
        super(location, dimensions);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        this.preRenderEvent(mouseX, mouseY);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        TextureWrapper tex = this.isDisabled() ? this.getTextureDisabled() : (this.isClicked() ? this.getTextureClicked() : (this.isHovered() ? this.getTextureHovered() : this.getTextureNormal()));
        tex.draw(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
        this.postRenderEvent(mouseX, mouseY);
    }

    protected void preRenderEvent(int mx, int my) {
        if (this.isEnabled()) {
            RenderEventDispatcher.onPreRender(this, mx, my);
        }
    }

    protected void postRenderEvent(int mx, int my) {
        if (this.isEnabled()) {
            RenderEventDispatcher.onPostRender(this, mx, my);
        }
    }

    public abstract TextureWrapper getTextureNormal();

    public abstract TextureWrapper getTextureHovered();

    public TextureWrapper getTextureClicked() {
        return this.getTextureHovered();
    }

    public TextureWrapper getTextureDisabled() {
        return TextureWrapper.NONE;
    }

    @Override
    public boolean isClicked() {
        return this.clicked;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.clicked = true;
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.clicked = false;
        return true;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        this.hovered = this.isInside(mouseX, mouseY);
        if (!this.hovered) {
            this.clicked = false;
        }
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Hovered=" + this.hovered);
        receiver.line("Clicked=" + this.clicked);
        receiver.line("NormalTexture=" + this.getTextureNormal());
        receiver.line("HoveredTexture=" + this.getTextureHovered());
    }
}

