/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IButton;
import vswe.stevesfactory.library.gui.widget.RadioController;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public class RadioButton
extends AbstractWidget
implements IButton,
LeafWidgetMixin {
    public static final TextureWrapper UNCHECKED = TextureWrapper.ofFlowComponent(18, 20, 8, 8);
    public static final TextureWrapper CHECKED = UNCHECKED.toRight(1);
    public static final TextureWrapper HOVERED_UNCHECKED = UNCHECKED.toDown(1);
    public static final TextureWrapper HOVERED_CHECKED = CHECKED.toDown(1);
    private final RadioController controller;
    private final int index;
    private String label = "";
    public Runnable onChecked = () -> {};
    private boolean hovered;
    private boolean checked;

    public RadioButton(RadioController controller) {
        this.controller = controller;
        this.index = controller.add(this);
        this.setDimensions(8, 8);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        TextureWrapper texture = this.hovered ? (this.checked ? HOVERED_CHECKED : HOVERED_UNCHECKED) : (this.checked ? CHECKED : UNCHECKED);
        int x1 = this.getAbsoluteX();
        int x2 = this.getAbsoluteXRight() + 2;
        int y1 = this.getAbsoluteY();
        int y2 = this.getAbsoluteYBottom();
        texture.draw(x1, y1);
        if (!this.label.isEmpty()) {
            int y = RenderingHelper.getYForAlignedCenter(y1, y2, (int)((float)RenderingHelper.fontHeight() * 0.7f));
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)x2, (float)y, (float)0.0f);
            GlStateManager.scalef((float)0.7f, (float)0.7f, (float)1.0f);
            RenderingHelper.fontRenderer().func_211126_b(this.label, 0.0f, 0.0f, -12566464);
            GlStateManager.popMatrix();
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.checked) {
            this.check(true);
        }
        return true;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        this.hovered = this.isInside(mouseX, mouseY);
    }

    protected void onStateUpdate(boolean oldValue) {
    }

    protected void onCheck() {
    }

    protected void onUncheck() {
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        boolean oldValue = this.checked;
        this.checked = checked;
        this.onStateUpdate(oldValue);
        if (checked) {
            this.onCheck();
        } else {
            this.onUncheck();
        }
    }

    public void check(boolean checked) {
        this.setChecked(checked);
        if (checked) {
            this.controller.checkRadioButton(this.index);
            this.onChecked.run();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public RadioController getRadioController() {
        return this.controller;
    }

    @Override
    public boolean isClicked() {
        return this.checked;
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Hovered=" + this.hovered);
        receiver.line("Checked=" + this.checked);
        receiver.line("Index=" + this.index);
    }
}

