/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.math.MathHelper;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IBackgroundRenderer;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.utils.Utils;

public class TextField
extends AbstractWidget
implements LeafWidgetMixin {
    public static TextField DUMMY = new TextField(0, 0, 0, 0){

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
        }

        @Override
        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return false;
        }

        @Override
        public boolean charTyped(char typedChar, int keyCode) {
            return false;
        }

        @Override
        public void setX(int x) {
        }

        @Override
        public void setY(int y) {
        }

        @Override
        public void onParentPositionChanged() {
        }

        @Override
        public boolean isFocused() {
            return false;
        }
    };
    private IBackgroundRenderer backgroundStyle = BackgroundStyle.THICK_BEVELED;
    private String text = "";
    private int cursor = 0;
    private int startOffset = 0;
    private int selection = -1;
    private boolean editable = true;
    private int textColor = -16777216;
    private int textColorUneditable = -13421773;
    private int fontHeight;
    private float scaleFactor;
    private String label;

    public TextField(int x, int y, int width, int height) {
        super(x, y, width, height);
        RenderingHelper.fontRenderer().getClass();
        this.fontHeight = 9;
        this.scaleFactor = 1.0f;
        this.label = "";
    }

    public TextField(Point location, Dimension dimensions) {
        super(location, dimensions);
        RenderingHelper.fontRenderer().getClass();
        this.fontHeight = 9;
        this.scaleFactor = 1.0f;
        this.label = "";
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.updateText(text);
        this.cursor = text.length();
        if (this.startOffset >= this.cursor) {
            this.startOffset = Utils.lowerBound(this.cursor - 1, 0);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.editable) {
            this.getWindow().setFocusedWidget(this);
            if (button == 1) {
                this.setText("");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown()) {
            switch (keyCode) {
                case 67: {
                    this.copyText();
                    break;
                }
                case 86: {
                    this.pasteText();
                    break;
                }
                case 88: {
                    this.cutText();
                    break;
                }
                case 65: {
                    this.selectAll();
                }
            }
        } else {
            switch (keyCode) {
                case 256: {
                    this.getWindow().changeFocus(this, false);
                }
                case 257: 
                case 258: 
                case 264: 
                case 265: {
                    return false;
                }
                case 268: {
                    this.updateSelection();
                    this.cursor = 0;
                    break;
                }
                case 269: {
                    this.updateSelection();
                    this.cursor = this.text.length();
                    break;
                }
                case 263: {
                    this.updateSelection();
                    if (this.cursor <= 0) break;
                    --this.cursor;
                    break;
                }
                case 262: {
                    this.updateSelection();
                    if (this.cursor >= this.text.length()) break;
                    ++this.cursor;
                    break;
                }
                case 259: {
                    if (this.isRegionSelected()) {
                        this.replaceSelectedRegion("");
                        break;
                    }
                    if (this.text.isEmpty() || this.cursor <= 0 || !this.removeTextAt(this.cursor - 1, this.cursor)) break;
                    --this.cursor;
                    break;
                }
                case 261: {
                    if (this.isRegionSelected()) {
                        this.replaceSelectedRegion("");
                        break;
                    }
                    if (this.cursor >= this.text.length()) break;
                    this.removeTextAt(this.cursor, this.cursor + 1);
                }
            }
        }
        return true;
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (typedChar != '\u0000') {
            String replacement = String.valueOf(typedChar);
            if (this.isRegionSelected()) {
                this.replaceSelectedRegion(replacement);
            } else {
                this.insertTextAtCursor(replacement);
            }
            return true;
        }
        return false;
    }

    public boolean insertTextAtCursor(String in) {
        if (this.insertTextAt(this.cursor, in)) {
            this.cursor += in.length();
            return true;
        }
        return false;
    }

    public boolean insertTextAt(int index, String in) {
        return this.updateText(this.text.substring(0, index) + in + this.text.substring(index));
    }

    public boolean removeTextAtCursor(int length) {
        int a = this.cursor + length;
        int b = this.cursor;
        if (this.removeTextAt(Math.min(a, b), Math.max(a, b))) {
            this.cursor -= length;
            return true;
        }
        return false;
    }

    public boolean removeTextAt(int start, int end) {
        return this.updateText(this.text.substring(0, start) + this.text.substring(end));
    }

    protected boolean updateText(String text) {
        this.text = text;
        return true;
    }

    private void copyText() {
        if (this.isRegionSelected()) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
        }
    }

    private void pasteText() {
        String text = Minecraft.func_71410_x().field_195559_v.func_197965_a();
        if (this.isRegionSelected()) {
            this.replaceSelectedRegion(text);
        } else {
            this.insertTextAtCursor(text);
        }
    }

    private void cutText() {
        if (this.isRegionSelected()) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
            this.replaceSelectedRegion("");
        }
    }

    public int getCursor() {
        return this.cursor;
    }

    protected void setCursor(int cursor) {
        this.cursor = MathHelper.func_76125_a((int)cursor, (int)0, (int)this.text.length());
    }

    public void scrollToFront() {
        this.cursor = 0;
        this.startOffset = 0;
    }

    public void selectAll() {
        this.setSelection(0, this.text.length());
    }

    public void setSelection(int start, int end) {
        this.selection = start;
        this.cursor = end;
    }

    public void clearSelection() {
        this.selection = -1;
    }

    public boolean isRegionSelected() {
        return this.selection != -1;
    }

    public int getSelectionStart() {
        return Math.min(this.cursor, this.selection);
    }

    public int getSelectionEnd() {
        return Math.max(this.cursor, this.selection);
    }

    public String getSelectedText() {
        return this.text.substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public void replaceSelectedRegion(String replacement) {
        int selectionStart = this.getSelectionStart();
        if (this.updateText(this.text.substring(0, selectionStart) + replacement + this.text.substring(this.getSelectionEnd()))) {
            this.cursor = selectionStart + replacement.length();
        }
        this.clearSelection();
    }

    private void updateSelection() {
        if (Screen.hasShiftDown()) {
            if (!this.isRegionSelected()) {
                this.selection = this.cursor;
            }
        } else {
            this.clearSelection();
        }
    }

    private int calculateVerticalOffset() {
        return (this.getDimensions().height - this.fontHeight) / 2;
    }

    private void ensureVisible() {
        if (this.cursor < this.startOffset) {
            this.startOffset = this.cursor;
        } else {
            int w = RenderingHelper.fontRenderer().func_78256_a(this.text.substring(this.startOffset, this.cursor));
            while (w > this.getDimensions().width - 12) {
                ++this.startOffset;
                w = RenderingHelper.fontRenderer().func_78256_a(this.text.substring(this.startOffset, this.cursor));
            }
        }
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
        this.scaleFactor = (float)fontHeight / (float)this.getDefaultFontHeight();
    }

    public int getDefaultFontHeight() {
        RenderingHelper.fontRenderer().getClass();
        return 9;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        this.ensureVisible();
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        int x2 = this.getAbsoluteXRight();
        int y2 = this.getAbsoluteYBottom();
        this.backgroundStyle.render(x, y, x2, y2, this.isInside(mouseX, mouseY), this.isFocused());
        int width = (int)((float)(this.getDimensions().width - 4) * (1.0f / this.scaleFactor));
        String renderedText = RenderingHelper.fontRenderer().func_78269_a(this.text.substring(this.startOffset), width);
        int textX = x + 2;
        int textY = y + this.calculateVerticalOffset();
        GlStateManager.enableTexture();
        if (this.isEnabled()) {
            if (this.isEditable()) {
                this.drawString(renderedText, textX, textY, this.textColor);
            } else {
                this.drawString(renderedText, textX, textY, this.textColorUneditable);
            }
            if (this.isRegionSelected()) {
                int selectionStart = this.getSelectionStart();
                int selectionEnd = this.getSelectionEnd();
                int renderedStart = MathHelper.func_76125_a((int)(selectionStart - this.startOffset), (int)0, (int)renderedText.length());
                int renderedEnd = MathHelper.func_76125_a((int)(selectionEnd - this.startOffset), (int)0, (int)renderedText.length());
                String renderedSelection = renderedText.substring(renderedStart, renderedEnd);
                String renderedPreSelection = renderedText.substring(0, renderedStart);
                int selectionX = (int)((float)textX + (float)RenderingHelper.fontRenderer().func_78256_a(renderedPreSelection) * this.scaleFactor);
                int selectionWidth = (int)((float)RenderingHelper.fontRenderer().func_78256_a(renderedSelection) * this.scaleFactor);
                RenderingHelper.fontRenderer().getClass();
                RenderingHelper.drawColorLogic(selectionX - 1, textY, selectionWidth + 1, 9, 60, 147, 242, GlStateManager.LogicOp.OR_REVERSE);
            }
        } else {
            this.drawString(renderedText, textX, textY, -6250336);
        }
        if (!this.label.isEmpty()) {
            RenderingHelper.drawTextCenteredVertically(this.label, this.getAbsoluteXRight() + 2, this.getAbsoluteY(), this.getAbsoluteYBottom(), -12566464);
        }
        if (this.isFocused()) {
            int w = (int)((float)RenderingHelper.fontRenderer().func_78256_a(this.text.substring(this.startOffset, this.cursor)) * this.scaleFactor);
            int cx = x + 2 + w;
            RenderingHelper.drawRect(cx, y + 2, cx + 1, y2 - 3, -16777216);
            GlStateManager.enableTexture();
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    private void drawString(String text, int textX, int textY, int color) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)textX, (float)textY, (float)0.0f);
        GlStateManager.scalef((float)this.scaleFactor, (float)this.scaleFactor, (float)1.0f);
        RenderingHelper.fontRenderer().func_211126_b(text, 0.0f, 0.0f, color);
        GlStateManager.popMatrix();
    }

    public IBackgroundRenderer getBackgroundStyle() {
        return this.backgroundStyle;
    }

    public void setBackgroundStyle(IBackgroundRenderer backgroundStyle) {
        this.backgroundStyle = backgroundStyle;
    }

    public void setBackgroundStyle(BackgroundStyle backgroundStyle) {
        this.backgroundStyle = backgroundStyle;
        this.setTextColor(backgroundStyle.textColor, backgroundStyle.textColorUneditable);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public int getTextColorUneditable() {
        return this.textColorUneditable;
    }

    public void setTextColor(int textColor, int textColorUneditable) {
        this.textColor = textColor;
        this.textColorUneditable = textColorUneditable;
    }

    private String getSelectedTextSafe() {
        if (this.isRegionSelected()) {
            return this.getSelectedText();
        }
        return "";
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Editable=" + this.editable);
        receiver.line("Text=" + this.text);
        receiver.line("StartOffset=" + this.startOffset);
        receiver.line("Cursor=" + this.cursor);
        receiver.line("SelectionStart=" + this.getSelectionStart());
        receiver.line("SelectionEnd=" + this.getSelectionEnd());
        receiver.line("SelectedText=" + this.getSelectedTextSafe());
    }

    public static enum BackgroundStyle implements IBackgroundRenderer
    {
        NONE(-16777216, -13421773){

            @Override
            public void render(int x1, int y1, int x2, int y2, boolean hovered, boolean focused) {
            }
        }
        ,
        THICK_BEVELED(-16777216, -13421773){

            @Override
            public void render(int x1, int y1, int x2, int y2, boolean hovered, boolean focused) {
                int color = focused ? -1118482 : (hovered ? -2434342 : -3750202);
                RenderingHelper.drawThickBeveledBox(x1, y1, x2 - 1, y2 - 1, 1, -13948117, -1, color);
            }
        }
        ,
        RED_OUTLINE(-1, -3355444){

            @Override
            public void render(int x1, int y1, int x2, int y2, boolean hovered, boolean focused) {
                if (focused) {
                    RenderingHelper.drawRect(x1, y1, x2, y2, -3204833);
                    RenderingHelper.drawVerticalGradientRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, -15132391, -13553359);
                } else {
                    RenderingHelper.drawRect(x1, y1, x2, y2, -9630962);
                    RenderingHelper.drawRect(x1 + 1, y1 + 1, x2 - 1, y2 - 1, -14935012);
                }
            }
        };

        public final int textColor;
        public final int textColorUneditable;

        private BackgroundStyle(int textColor, int textColorUneditable) {
            this.textColor = textColor;
            this.textColorUneditable = textColorUneditable;
        }
    }
}

