/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;

public class TextList
extends AbstractWidget
implements LeafWidgetMixin {
    private List<String> texts;
    private boolean fitContents = false;
    private int fontHeight = RenderingHelper.fontHeight();
    private float scaleFactor = (float)this.fontHeight / (float)RenderingHelper.fontHeight();

    public TextList(int width, int height, List<String> texts) {
        super(0, 0, width, height);
        this.texts = texts;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        int x = this.getAbsoluteX() + 1;
        int y = this.getAbsoluteY() + 1;
        GlStateManager.enableTexture();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)x, (float)y, (float)0.0f);
        GlStateManager.scalef((float)this.scaleFactor, (float)this.scaleFactor, (float)1.0f);
        for (String text : this.texts) {
            RenderingHelper.fontRenderer().func_211126_b(text, 0.0f, 0.0f, -16777216);
            GlStateManager.translatef((float)0.0f, (float)this.fontHeight, (float)0.0f);
        }
        GlStateManager.popMatrix();
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    public boolean doesFitContents() {
        return this.fitContents;
    }

    public void setFitContents(boolean fitContents) {
        this.fitContents = fitContents;
    }

    public List<String> getTexts() {
        return this.texts;
    }

    public void addLine(String newLine) {
        this.texts.add(newLine);
        this.tryExpand(newLine);
    }

    public void addLineSplit(String text) {
        this.addLineSplit((int)((float)this.getWidth() / this.scaleFactor), text);
    }

    public void addLineSplit(int maxWidth, String text) {
        int end = RenderingHelper.fontRenderer().func_78259_e(text, maxWidth);
        if (end >= text.length()) {
            this.addLine(text);
        } else {
            String trimmed = text.substring(0, end);
            String after = text.substring(end).trim();
            this.addLine(trimmed);
            this.addLineSplit(maxWidth, after);
        }
    }

    private void tryExpand(String line) {
        if (this.fitContents) {
            int w = (int)((float)Minecraft.func_71410_x().field_71466_p.func_78256_a(line) * this.scaleFactor);
            this.setWidth(Math.max(this.getWidth(), 1 + w + 1));
            this.setHeight(1 + (this.fontHeight + 2) * this.texts.size() + 1);
        }
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
        this.scaleFactor = (float)fontHeight / (float)RenderingHelper.fontHeight();
    }
}

