/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.window;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.FlowLayout;
import vswe.stevesfactory.library.gui.screen.BackgroundRenderers;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.Spacer;
import vswe.stevesfactory.library.gui.widget.TextButton;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.widget.TextList;
import vswe.stevesfactory.library.gui.widget.box.Box;
import vswe.stevesfactory.library.gui.window.AbstractPopupWindow;

public class Dialog
extends AbstractPopupWindow {
    public static final Consumer<Dialog> VANILLA_STYLE_RENDERER = d -> {
        GlStateManager.enableAlphaTest();
        BackgroundRenderers.drawVanillaStyle(d.position.x, d.position.y, d.border.width, d.border.height, 0.0f);
    };
    public static final int VANILLA_STYLE_BORDER_SIZE = 4;
    public static final Consumer<Dialog> FLAT_STYLE_RENDERER = d -> {
        GlStateManager.disableAlphaTest();
        BackgroundRenderers.drawFlatStyle(d.position.x, d.position.y, d.border.width, d.border.height, 0.0f);
        GlStateManager.enableAlphaTest();
    };
    public static final int FLAT_STYLE_BORDER_SIZE = 3;
    private Consumer<Dialog> backgroundRenderer;
    private int borderSize;
    private TextList messageBox;
    private Box<TextButton> buttons;
    private List<AbstractWidget> children;
    public Runnable onPreReflow = () -> {};
    public Runnable onPostReflow = () -> {};

    public static Dialog createPrompt(String message, BiConsumer<Integer, String> onConfirm) {
        return Dialog.createPrompt(message, onConfirm, (Integer b, String t) -> {});
    }

    public static Dialog createPrompt(String message, BiConsumer<Integer, String> onConfirm, BiConsumer<Integer, String> onCancel) {
        return Dialog.createPrompt(message, "", onConfirm, onCancel);
    }

    public static Dialog createPrompt(String message, String defaultText, BiConsumer<Integer, String> onConfirm) {
        return Dialog.createPrompt(message, defaultText, onConfirm, (b, t) -> {});
    }

    public static Dialog createPrompt(String message, String defaultText, BiConsumer<Integer, String> onConfirm, BiConsumer<Integer, String> onCancel) {
        return Dialog.createPrompt(message, defaultText, "gui.sfm.ok", "gui.sfm.cancel", onConfirm, onCancel);
    }

    public static Dialog createPrompt(String message, String defaultText, String confirm, String cancel, BiConsumer<Integer, String> onConfirm, BiConsumer<Integer, String> onCancel) {
        Dialog dialog = Dialog.dialog(message);
        TextField inputBox = new TextField(0, 0, 0, 16);
        inputBox.setText(defaultText);
        dialog.insertBeforeButtons(inputBox);
        dialog.onPostReflow = inputBox::expandHorizontally;
        dialog.insertBeforeButtons(new Spacer(0, 4));
        dialog.buttons.addChildren((IWidget)TextButton.of(confirm, b -> onConfirm.accept(b, inputBox.getText())));
        dialog.bindRemoveSelf2LastButton();
        dialog.buttons.addChildren((IWidget)TextButton.of(cancel, b -> onCancel.accept(b, inputBox.getText())));
        dialog.bindRemoveSelf2LastButton();
        dialog.reflow();
        dialog.centralize();
        dialog.setFocusedWidget(inputBox);
        return dialog;
    }

    public static Dialog createBiSelectionDialog(String message, IntConsumer onConfirm) {
        return Dialog.createBiSelectionDialog(message, onConfirm, TextButton.DUMMY);
    }

    public static Dialog createBiSelectionDialog(String message, IntConsumer onConfirm, IntConsumer onCancel) {
        return Dialog.createBiSelectionDialog(message, "gui.sfm.ok", "gui.sfm.cancel", onConfirm, onCancel);
    }

    public static Dialog createBiSelectionDialog(String message, String confirm, String cancel, IntConsumer onConfirm, IntConsumer onCancel) {
        Dialog dialog = Dialog.dialog(message);
        dialog.buttons.addChildren((IWidget)TextButton.of(confirm, onConfirm));
        dialog.bindRemoveSelf2LastButton();
        dialog.buttons.addChildren((IWidget)TextButton.of(cancel, onCancel));
        dialog.bindRemoveSelf2LastButton();
        dialog.reflow();
        dialog.centralize();
        return dialog;
    }

    public static Dialog createDialog(String message) {
        return Dialog.createDialog(message, TextButton.DUMMY);
    }

    public static Dialog createDialog(String message, IntConsumer onConfirm) {
        return Dialog.createDialog(message, "gui.sfm.ok", onConfirm);
    }

    public static Dialog createDialog(String message, String ok, IntConsumer onConfirm) {
        Dialog dialog = Dialog.dialog(message);
        dialog.buttons.addChildren((IWidget)TextButton.of(ok, onConfirm));
        dialog.bindRemoveSelf2LastButton();
        dialog.reflow();
        dialog.centralize();
        return dialog;
    }

    private static Dialog dialog(String message) {
        Dialog dialog = new Dialog();
        dialog.insertBeforeMessage(new Spacer(0, 5));
        dialog.messageBox.addLineSplit(160, I18n.func_135052_a((String)message, (Object[])new Object[0]));
        return dialog;
    }

    public Dialog() {
        this.messageBox = new TextList(10, 10, new ArrayList<String>());
        this.messageBox.setFitContents(true);
        this.buttons = new Box(0, 0, 10, 10).setLayout(b -> {
            int x = 0;
            for (TextButton button : b) {
                button.setLocation(x, 0);
                x += button.getWidth() + 2;
            }
        });
        this.children = new ArrayList<AbstractWidget>();
        this.children.add(this.messageBox);
        this.children.add(this.buttons);
        this.useVanillaBorders();
        for (AbstractWidget child : this.children) {
            child.setWindow(this);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        this.backgroundRenderer.accept(this);
        this.renderChildren(mouseX, mouseY, particleTicks);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    public void reflow() {
        this.onPreReflow.run();
        this.messageBox.expandHorizontally();
        this.buttons.reflow();
        this.buttons.adjustMinContent();
        FlowLayout.vertical(this.children, 0, 0, 0);
        this.updateDimensions();
        this.updateChildPosition();
        this.onPostReflow.run();
    }

    private void updateDimensions() {
        int rightmost = 0;
        int bottommost = 0;
        for (IWidget iWidget : this.children) {
            int right = iWidget.getX() + iWidget.getWidth();
            int bottom = iWidget.getY() + iWidget.getHeight();
            if (right > rightmost) {
                rightmost = right;
            }
            if (bottom <= bottommost) continue;
            bottommost = bottom;
        }
        this.setContents(rightmost, bottommost);
    }

    public TextList getMessageBox() {
        return this.messageBox;
    }

    public Box<TextButton> getButtons() {
        return this.buttons;
    }

    public void insertBeforeMessage(AbstractWidget widget) {
        widget.setWindow(this);
        this.children.add(0, widget);
    }

    public void insertBeforeButtons(AbstractWidget widget) {
        widget.setWindow(this);
        this.children.add(this.children.size() - 1, widget);
    }

    public void appendChild(AbstractWidget widget) {
        widget.setWindow(this);
        this.children.add(widget);
    }

    @Override
    public Dimension getBorder() {
        return this.border;
    }

    @Override
    public int getBorderSize() {
        return this.borderSize;
    }

    @Override
    public Dimension getContentDimensions() {
        return this.contents;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return this.children;
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    public void setStyle(Consumer<Dialog> renderer, int borderSize) {
        this.backgroundRenderer = renderer;
        this.borderSize = borderSize;
        this.reflow();
    }

    public void useFlatBorders() {
        this.setStyle(FLAT_STYLE_RENDERER, 3);
    }

    public void useVanillaBorders() {
        this.setStyle(VANILLA_STYLE_RENDERER, 4);
    }

    public void bindRemoveSelf(int buttonID) {
        TextButton button = (TextButton)this.buttons.getChildren().get(buttonID);
        if (button.hasClickAction()) {
            IntConsumer oldAction = button.onClick;
            button.onClick = b -> {
                this.alive = false;
                oldAction.accept(b);
            };
        } else {
            button.onClick = b -> {
                this.alive = false;
            };
        }
    }

    public void bindRemoveSelf2LastButton() {
        this.bindRemoveSelf(this.buttons.getChildren().size() - 1);
    }

    public boolean tryAddSelfToActiveGUI() {
        if (Minecraft.func_71410_x().field_71462_r instanceof WidgetScreen) {
            WidgetScreen.getCurrent().addPopupWindow(this);
            return true;
        }
        return false;
    }
}

