/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.window;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.BackgroundRenderers;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.slot.AbstractItemSlot;
import vswe.stevesfactory.library.gui.widget.slot.ItemSlotPanel;
import vswe.stevesfactory.library.gui.window.AbstractPopupWindow;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;

public class PlayerInventoryWindow
extends AbstractPopupWindow {
    private final List<IWidget> children;

    public static PlayerInventoryWindow atCursor() {
        return PlayerInventoryWindow.atCursor(ItemSlotPanel.DefaultSlot::new);
    }

    public static PlayerInventoryWindow atCursor(Function<ItemStack, AbstractItemSlot> factory) {
        MouseHelper m = Minecraft.func_71410_x().field_71417_B;
        double scale = Minecraft.func_71410_x().field_195558_d.func_198100_s();
        int mouseX = (int)(m.func_198024_e() / scale);
        int mouseY = (int)(m.func_198026_f() / scale);
        return new PlayerInventoryWindow(mouseX, mouseY, factory);
    }

    public PlayerInventoryWindow() {
        this(0, 0, ItemSlotPanel.DefaultSlot::new);
    }

    public PlayerInventoryWindow(int x, int y, Function<ItemStack, AbstractItemSlot> factory) {
        PlayerInventory playerInventory = Minecraft.func_71410_x().field_71439_g.field_71071_by;
        ItemSlotPanel inventory = new ItemSlotPanel(9, 3, playerInventory.field_70462_a.subList(9, playerInventory.field_70462_a.size()), factory);
        inventory.setWindow(this);
        inventory.setLocation(0, 11);
        ItemSlotPanel hotbar = new ItemSlotPanel(9, 1, playerInventory.field_70462_a.subList(0, 9), factory);
        hotbar.setWindow(this);
        hotbar.setLocation(0, inventory.getY() + inventory.getHeight() + 4);
        AbstractIconButton close = new AbstractIconButton(inventory.getWidth() - 8 - 1, 1, 8, 8){

            @Override
            public TextureWrapper getTextureNormal() {
                return FactoryManagerGUI.CLOSE_ICON;
            }

            @Override
            public TextureWrapper getTextureHovered() {
                return FactoryManagerGUI.CLOSE_ICON_HOVERED;
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                PlayerInventoryWindow.this.alive = false;
                return super.mouseClicked(mouseX, mouseY, button);
            }
        };
        close.setWindow(this);
        this.children = ImmutableList.of((Object)close, (Object)inventory, (Object)hotbar);
        this.setPosition(x, y);
        this.setContents(inventory.getWidth(), hotbar.getY() + hotbar.getHeight());
    }

    @Override
    public int getBorderSize() {
        return 4;
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return this.children;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        GlStateManager.enableAlphaTest();
        BackgroundRenderers.drawVanillaStyle(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0.0f);
        this.renderChildren(mouseX, mouseY, particleTicks);
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }
}

