/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sfm", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class BlockHighlight {
    private static List<BlockHighlight> highlights = new ArrayList<BlockHighlight>();
    private final BlockPos pos;
    private final long expireTime;

    public static void createHighlight(BlockPos pos, int expire) {
        long expireTime = Minecraft.func_71410_x().field_71441_e.func_82737_E() + (long)expire;
        highlights.add(new BlockHighlight(pos, expireTime));
    }

    @SubscribeEvent
    public static void renderWorldLast(RenderWorldLastEvent event) {
        for (BlockHighlight highlight : highlights) {
            highlight.render();
        }
        highlights.removeIf(BlockHighlight::isExpired);
    }

    public BlockHighlight(BlockPos pos, long expireTime) {
        this.pos = pos;
        this.expireTime = expireTime;
    }

    public void render() {
        BlockHighlight.renderOutline(this.pos);
    }

    public boolean isExpired() {
        return Minecraft.func_71410_x().field_71441_e.func_82737_E() > this.expireTime;
    }

    public static void renderOutline(BlockPos c) {
        GlStateManager.pushMatrix();
        Vec3d vpos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        GlStateManager.translated((double)(-vpos.field_72450_a), (double)(-vpos.field_72448_b), (double)(-vpos.field_72449_c));
        GlStateManager.disableDepthTest();
        GlStateManager.disableTexture();
        GlStateManager.lineWidth((float)3.0f);
        float mx = c.func_177958_n();
        float my = c.func_177956_o();
        float mz = c.func_177952_p();
        WorldRenderer.func_189694_a((double)mx, (double)my, (double)mz, (double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.enableTexture();
        GlStateManager.popMatrix();
    }
}

