/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.setup;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.types.Type;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class BlockBuilder<T extends TileEntity> {
    private final ResourceLocation registryName;
    private Block.Properties blockProperties;
    private Function<Block.Properties, Block> blockConstructor;
    private Block block;
    private BiFunction<Block, Item.Properties, Item> itemBlockConstructor = BlockItem::new;
    private Item.Properties itemProperties = null;
    private Item item;
    private Function<Block, TileEntityType.Builder<T>> tileEntityTypeBuilder = null;
    private Type<T> dataFixerType = null;
    private TileEntityType<T> tileEntityType;
    private Class<T> tileClass;
    private Supplier<TileEntityRenderer<T>> rendererFactory;

    public BlockBuilder(String registryName) {
        this(new ResourceLocation("sfm", registryName));
    }

    public BlockBuilder(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public BlockBuilder<T> properties(@Nonnull Block.Properties blockProperties) {
        this.blockProperties = Objects.requireNonNull(blockProperties);
        return this;
    }

    public BlockBuilder<T> constructor(@Nonnull Function<Block.Properties, Block> blockConstructor) {
        this.blockConstructor = Objects.requireNonNull(blockConstructor);
        return this;
    }

    public BlockBuilder<T> item(@Nonnull Item.Properties itemBuilder, @Nonnull BiFunction<Block, Item.Properties, Item> itemBlockFactory) {
        this.itemProperties = Objects.requireNonNull(itemBuilder);
        this.itemBlockConstructor = Objects.requireNonNull(itemBlockFactory);
        return this;
    }

    public BlockBuilder<T> item(@Nonnull Item.Properties itemBuilder) {
        return this.item(itemBuilder, this.itemBlockConstructor);
    }

    public BlockBuilder<T> noItem() {
        this.itemProperties = null;
        return this;
    }

    public BlockBuilder<T> tileEntity(@Nonnull Function<Block, TileEntityType.Builder<T>> builder) {
        this.tileEntityTypeBuilder = Objects.requireNonNull(builder);
        return this;
    }

    public BlockBuilder<T> dataFixer(@Nonnull Type<T> dataFixerType) {
        this.dataFixerType = Objects.requireNonNull(dataFixerType);
        return this;
    }

    public BlockBuilder<T> noTileEntity() {
        this.tileEntityTypeBuilder = null;
        return this;
    }

    public BlockBuilder<T> renderer(@Nonnull Class<T> tileClass, @Nonnull Supplier<TileEntityRenderer<T>> rendererFactory) {
        this.tileClass = Objects.requireNonNull(tileClass);
        this.rendererFactory = Objects.requireNonNull(rendererFactory);
        return this;
    }

    public Block construct() {
        if (this.block == null) {
            this.block = this.blockConstructor.apply(this.blockProperties);
            this.block.setRegistryName(this.registryName);
        }
        return this.block;
    }

    public Item constructItemBlock() {
        Preconditions.checkState((boolean)this.hasItem(), (Object)"No item properties specified. Unable to construct item-form block!");
        if (this.item == null) {
            this.item = this.itemBlockConstructor.apply(this.block, this.itemProperties);
            this.item.setRegistryName(this.registryName);
        }
        return this.item;
    }

    public TileEntityType<T> constructTileEntityType() {
        Preconditions.checkState((boolean)this.hasTileEntity(), (Object)"No tile entity builder specified. Unable to construct TileEntityType<T>!");
        if (this.tileEntityType == null) {
            this.tileEntityType = this.tileEntityTypeBuilder.apply(this.construct()).func_206865_a(this.dataFixerType);
            this.tileEntityType.setRegistryName(this.registryName);
        }
        return this.tileEntityType;
    }

    public boolean tryRegisterTileEntityRenderer() {
        if (this.hasTileEntityRenderer()) {
            ClientRegistry.bindTileEntitySpecialRenderer(this.tileClass, this.rendererFactory.get());
            return true;
        }
        return false;
    }

    public boolean hasItem() {
        return this.itemProperties != null;
    }

    public boolean hasTileEntity() {
        return this.tileEntityTypeBuilder != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTileEntityRenderer() {
        return this.tileClass != null && this.rendererFactory != null;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public BlockBuilder<T> forClient(Supplier<Consumer<BlockBuilder<T>>> task) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            task.get().accept(this);
        }
        return this;
    }
}

