/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.ScissorTest;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.ui.manager.DynamicWidthWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.editor.EndNode;
import vswe.stevesfactory.ui.manager.editor.INode;
import vswe.stevesfactory.ui.manager.editor.IntermediateNode;
import vswe.stevesfactory.ui.manager.editor.StartNode;

public final class ConnectionsPanel
extends DynamicWidthWidget<INode> {
    public static final int REGULAR_WIDTH = 7;
    public static final int REGULAR_HEIGHT = 6;
    private Set<INode> children = new HashSet<INode>();
    private Either<StartNode, EndNode> selectedNode = null;

    public static void connect(INode from, INode to) {
        from.connectTo(to);
        to.connectFrom(from);
    }

    public static void connectAndOverride(StartNode start, EndNode end) {
        if (start.isConnected()) {
            ConnectionsPanel.removeConnection(start);
        }
        if (end.isConnected()) {
            ConnectionsPanel.removeConnection(end);
        }
        ConnectionsPanel.connect(start, end);
    }

    public static void disconnect(INode from, INode to) {
        from.disconnectNext();
        to.disconnectPrevious();
    }

    public static void mergeConnection(INode from, INode to, INode middle) {
        ConnectionsPanel.disconnect(from, middle);
        ConnectionsPanel.disconnect(middle, to);
        ConnectionsPanel.connect(from, to);
    }

    public static IntermediateNode subdivideConnection(INode from, INode to) {
        ConnectionsPanel.disconnect(from, to);
        IntermediateNode middle = new IntermediateNode();
        ConnectionsPanel.connect(from, middle);
        ConnectionsPanel.connect(middle, to);
        return middle;
    }

    public static void removeConnection(StartNode start) {
        StartNode current;
        INode next;
        start.onEdgeRemoval();
        INode nextTarget = start;
        while ((next = (current = nextTarget).getNext()) != null) {
            ConnectionsPanel.disconnect(current, next);
            nextTarget = next;
            next.onEdgeRemoval();
        }
    }

    public static void removeConnection(EndNode end) {
        EndNode current;
        INode previous;
        end.onEdgeRemoval();
        INode nextTarget = end;
        while ((previous = (current = nextTarget).getPrevious()) != null) {
            ConnectionsPanel.disconnect(previous, current);
            nextTarget = previous;
            previous.onEdgeRemoval();
        }
    }

    public static void drawConnectionLine(INode first, INode second) {
        ConnectionsPanel.drawConnectionLine(RenderingHelper.getCenterXFor(first), RenderingHelper.getCenterYFor(first), RenderingHelper.getCenterXFor(second), RenderingHelper.getCenterYFor(second));
    }

    public static void drawConnectionLine(int x1, int y1, int x2, int y2) {
        GlStateManager.disableTexture();
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        GL11.glLineWidth((float)4.0f);
        GL11.glColor3f((float)0.36862746f, (float)0.36862746f, (float)0.36862746f);
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x2, (float)y2, (float)0.0f);
        GL11.glEnd();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableTexture();
    }

    public ConnectionsPanel() {
        super(DynamicWidthWidget.WidthOccupierType.MAX_WIDTH);
    }

    @Override
    public Set<INode> getChildren() {
        return this.children;
    }

    @Override
    public BoxSizing getBoxSizing() {
        return BoxSizing.PHANTOM;
    }

    @Override
    public void reflow() {
    }

    @Override
    protected void onAfterReflow() {
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        this.setLocation(editor.getX(), editor.getY());
        this.setDimensions(editor.getWidth(), editor.getHeight());
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        ScissorTest test = ScissorTest.scaled(this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)editor.getXOffset(), (float)editor.getYOffset(), (float)0.0f);
        for (INode child : this.children) {
            if (child.getPrevious() != null) continue;
            INode current = child;
            for (INode next = child.getNext(); next != null; next = next.getNext()) {
                ConnectionsPanel.drawConnectionLine(current, next);
                current = next;
            }
        }
        for (INode child : this.children) {
            child.render(mouseX - editor.getXOffset(), mouseY - editor.getYOffset(), particleTicks);
        }
        GlStateManager.popMatrix();
        test.destroy();
        if (this.selectedNode != null) {
            INode node = (INode)this.selectedNode.map(Function.identity(), Function.identity());
            ConnectionsPanel.drawConnectionLine(RenderingHelper.getCenterXFor(node) + editor.getXOffset(), RenderingHelper.getCenterYFor(node) + editor.getYOffset(), mouseX, mouseY);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        if (super.mouseClicked(mouseX - (double)editor.getXOffset(), mouseY - (double)editor.getYOffset(), button)) {
            return true;
        }
        if (button == 1 && this.selectedNode != null) {
            this.clearSelection();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        return super.mouseReleased(mouseX - (double)editor.getXOffset(), mouseY - (double)editor.getYOffset(), button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        return super.mouseDragged(mouseX - (double)editor.getXOffset(), mouseY - (double)editor.getYOffset(), button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        return super.mouseScrolled(mouseX - (double)editor.getXOffset(), mouseY - (double)editor.getYOffset(), scroll);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        EditorPanel editor = FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel;
        super.mouseMoved(mouseX - (double)editor.getXOffset(), mouseY - (double)editor.getYOffset());
    }

    public void onTerminalNodeClick(Either<StartNode, EndNode> node, int button) {
        switch (button) {
            case 0: {
                this.handleTerminalNodeConnecting(node);
                break;
            }
            case 1: {
                this.handleTerminalNodeDisconnecting(node);
            }
        }
    }

    private void handleTerminalNodeConnecting(Either<StartNode, EndNode> node) {
        if (this.selectedNode == null) {
            this.selectedNode = node;
            return;
        }
        StartNode start = (StartNode)node.map(Function.identity(), __ -> this.selectedNode.left().orElse(null));
        EndNode end = (EndNode)node.map(__ -> this.selectedNode.right().orElse(null), Function.identity());
        if (start == null || end == null) {
            return;
        }
        ConnectionsPanel.connectAndOverride(start, end);
        Connection.createAndOverride(start.getProcedure(), start.getIndex(), end.getProcedure(), end.getIndex());
        this.clearSelection();
    }

    private void handleTerminalNodeDisconnecting(Either<StartNode, EndNode> node) {
        StartNode start = (StartNode)node.map(Function.identity(), EndNode::getStart);
        EndNode end = (EndNode)node.map(StartNode::getEnd, Function.identity());
        if (start == null || end == null) {
            return;
        }
        ConnectionsPanel.removeConnection(start);
    }

    public void clearSelection() {
        this.selectedNode = null;
    }

    public ConnectionsPanel addChildren(INode node) {
        this.children.add(node);
        node.setParentWidget(this);
        return this;
    }

    public ConnectionsPanel addChildren(Collection<INode> nodes) {
        for (INode node : nodes) {
            this.addChildren(node);
        }
        return this;
    }

    public void removeChildren(INode node) {
        if (this.children.remove(node)) {
            node.onRemoved();
        }
    }
}

