/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.nbt.CompoundNBT;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.library.gui.widget.box.LinearList;
import vswe.stevesfactory.library.gui.widget.box.MinimumLinearList;
import vswe.stevesfactory.library.gui.window.Dialog;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.ConnectionNodes;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.editor.EndNode;
import vswe.stevesfactory.ui.manager.editor.ErrorIndicator;
import vswe.stevesfactory.ui.manager.editor.INode;
import vswe.stevesfactory.ui.manager.editor.Menu;
import vswe.stevesfactory.ui.manager.editor.StartNode;
import vswe.stevesfactory.utils.NetworkHelper;

public class FlowComponent<P extends IProcedure & IClientDataStorage>
extends AbstractContainer<IWidget>
implements Comparable<FlowComponent<?>> {
    private P procedure;
    private final ToggleStateButton toggleStateButton;
    private final RenameButton renameButton;
    private final SubmitButton submitButton;
    private final CancelButton cancelButton;
    private final TextField nameBox;
    private final ConnectionNodes<EndNode> inputNodes;
    private final ConnectionNodes<StartNode> outputNodes;
    private final ErrorIndicator errorIndicator;
    private final MinimumLinearList<Menu<P>> menus;
    private final List<IWidget> children;
    private State state;
    private int zIndex;
    private int initialDragLocalX;
    private int initialDragLocalY;

    public static <P extends IProcedure & IClientDataStorage> FlowComponent<P> of(P procedure) {
        return new FlowComponent<P>(procedure, procedure.predecessors().length, procedure.successors().length);
    }

    public FlowComponent(P procedure, int amountInputs, int amountOutputs) {
        super(0, 0, 0, 0);
        String name = ((IClientDataStorage)procedure).getName();
        this.toggleStateButton = new ToggleStateButton(this);
        this.renameButton = new RenameButton(this);
        this.submitButton = new SubmitButton(this);
        this.cancelButton = new CancelButton(this, name);
        this.nameBox = new TextField(6, 8, 35, 10);
        this.nameBox.setBackgroundStyle(TextField.BackgroundStyle.NONE);
        this.nameBox.setText(name);
        this.nameBox.setTextColor(-13619152, -13619152);
        this.nameBox.setEditable(false);
        this.nameBox.setFontHeight(6);
        this.inputNodes = ConnectionNodes.inputNodes(amountInputs);
        this.outputNodes = ConnectionNodes.outputNodes(amountOutputs);
        this.errorIndicator = ErrorIndicator.error();
        this.menus = new MinimumLinearList(120, 130);
        this.menus.setLocation(2, 20);
        this.children = ImmutableList.of((Object)this.toggleStateButton, (Object)this.renameButton, (Object)this.submitButton, (Object)this.cancelButton, (Object)this.nameBox, this.inputNodes, this.outputNodes, (Object)this.errorIndicator, this.menus);
        this.setLinkedProcedure(procedure);
        this.state = State.COLLAPSED;
        this.errorIndicator.setLocation(2, 8);
    }

    public TextureWrapper getBackgroundTexture() {
        return this.state.background;
    }

    public State getState() {
        return this.state;
    }

    public void toggleState() {
        switch (this.state) {
            case COLLAPSED: {
                this.expand();
                break;
            }
            case EXPANDED: {
                this.collapse();
            }
        }
    }

    public void expand() {
        this.state = State.EXPANDED;
        this.setDimensions(this.state.componentWidth(), this.state.componentHeight());
        this.nameBox.setWidth(95);
        this.nameBox.scrollToFront();
        this.toggleStateButton.setLocation(114, 5);
        this.renameButton.setLocation(103, 6);
        this.submitButton.setLocation(105, 3);
        this.cancelButton.setLocation(105, 11);
        this.renameButton.setEnabled(true);
        this.updateMenusEnableState(true);
        this.reflow();
    }

    public void collapse() {
        this.state = State.COLLAPSED;
        this.setDimensions(this.state.componentWidth(), this.state.componentHeight());
        this.nameBox.setWidth(35);
        this.nameBox.scrollToFront();
        this.toggleStateButton.setLocation(54, 5);
        this.renameButton.setLocation(43, 6);
        this.submitButton.setLocation(45, 3);
        this.cancelButton.setLocation(45, 11);
        if (this.isEditing()) {
            this.cancelButton.cancel();
        }
        this.renameButton.setEnabled(false);
        this.updateMenusEnableState(false);
        this.reflow();
    }

    public boolean isEditing() {
        return this.submitButton.isEnabled();
    }

    private void updateMenusEnableState(boolean enabled) {
        this.menus.setEnabled(enabled);
        for (Menu menu : this.menus.getChildren()) {
            menu.setEnabled(enabled);
        }
    }

    public String getName() {
        return this.nameBox.getText();
    }

    public void setName(String name) {
        this.nameBox.setText(name);
        this.cancelButton.previousName = this.getName();
        ((IClientDataStorage)this.procedure).setName(name);
    }

    @Override
    public List<IWidget> getChildren() {
        return this.children;
    }

    public LinearList<Menu<P>> getMenusBox() {
        return this.menus;
    }

    public void collapseAllMenus() {
        for (Menu menu : this.menus.getChildren()) {
            menu.collapse();
        }
        this.menus.setScrollDistance(0.0f);
    }

    public void expandAllMenus() {
        for (Menu menu : this.menus.getChildren()) {
            menu.expand();
        }
    }

    @Override
    public void reflow() {
        this.inputNodes.setWidth(this.getWidth());
        this.inputNodes.setY(-6);
        this.inputNodes.reflow();
        this.outputNodes.setWidth(this.getWidth());
        this.outputNodes.setY(this.getHeight());
        this.outputNodes.reflow();
        this.menus.reflow();
    }

    public FlowComponent<P> addMenu(Menu<P> menu) {
        this.menus.addChildren((IWidget)menu);
        menu.onLinkFlowComponent(this);
        return this;
    }

    @Override
    public FlowComponent<P> addChildren(IWidget widget) {
        if (widget instanceof Menu) {
            Menu menu = (Menu)widget;
            return this.addMenu(menu);
        }
        throw new IllegalArgumentException("Flow components do not accept new child widgets with type other than Menu");
    }

    @Override
    public FlowComponent<P> addChildren(Collection<IWidget> widgets) {
        for (IWidget widget : widgets) {
            this.addChildren(widget);
        }
        return this;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.getBackgroundTexture().draw(this.getAbsoluteX(), this.getAbsoluteY());
        this.toggleStateButton.render(mouseX, mouseY, particleTicks);
        this.renameButton.render(mouseX, mouseY, particleTicks);
        this.submitButton.render(mouseX, mouseY, particleTicks);
        this.cancelButton.render(mouseX, mouseY, particleTicks);
        this.nameBox.render(mouseX, mouseY, particleTicks);
        this.inputNodes.render(mouseX, mouseY, particleTicks);
        this.outputNodes.render(mouseX, mouseY, particleTicks);
        this.errorIndicator.render(mouseX, mouseY, particleTicks);
        this.menus.render(mouseX, mouseY, particleTicks);
        if (this.nameBox.isInside(mouseX, mouseY)) {
            WidgetScreen.getCurrent().setHoveringText(this.getName(), mouseX, mouseY);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.clearDrag();
            return true;
        }
        if (!this.isInside(mouseX, mouseY)) {
            this.clearDrag();
            return false;
        }
        this.getWindow().setFocusedWidget(this);
        if (button == 0) {
            this.initialDragLocalX = (int)mouseX - this.getAbsoluteX();
            this.initialDragLocalY = (int)mouseY - this.getAbsoluteY();
        } else {
            this.clearDrag();
        }
        if (button == 1) {
            this.openContextMenu();
        }
        return true;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isEnabled()) {
            return false;
        }
        if (super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (this.isDragging()) {
            EditorPanel parent = this.getParentWidget();
            int x = (int)mouseX - parent.getAbsoluteX() - this.initialDragLocalX;
            int y = (int)mouseY - parent.getAbsoluteY() - this.initialDragLocalY;
            this.setLocation(x, y);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isEnabled()) {
            return false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (!this.isEnabled()) {
            return false;
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isEnabled()) {
            return false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (!this.isEnabled()) {
            return false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char charTyped, int keyCode) {
        if (!this.isEnabled()) {
            return false;
        }
        return super.charTyped(charTyped, keyCode);
    }

    @Override
    public void update(float particleTicks) {
        super.update(particleTicks);
        if (Minecraft.func_71410_x().field_71441_e.func_82737_E() % 10L == 0L) {
            this.repopulateErrors();
        }
    }

    private void clearDrag() {
        this.initialDragLocalX = -1;
        this.initialDragLocalY = -1;
    }

    private boolean isDragging() {
        return this.initialDragLocalX != -1 && this.initialDragLocalY != -1;
    }

    public void setParentWidget(EditorPanel parent) {
        this.setParentWidget((IWidget)parent);
        this.collapse();
    }

    private void openContextMenu() {
        ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(FactoryManagerGUI.DELETE_ICON, "gui.sfm.FactoryManager.Editor.CtxMenu.Delete", b -> this.actionDelete()), (Object)new CallbackEntry(FactoryManagerGUI.CUT_ICON, "gui.sfm.FactoryManager.Editor.CtxMenu.Cut", b -> this.actionCut()), (Object)new CallbackEntry(FactoryManagerGUI.COPY_ICON, "gui.sfm.FactoryManager.Editor.CtxMenu.Copy", b -> this.actionCopy()), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Editor.CtxMenu.ChangeGroup", b -> this.actionChangeGroup())));
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
    }

    private void actionDelete() {
        if (Screen.hasShiftDown()) {
            Dialog.createBiSelectionDialog("gui.sfm.FactoryManager.Editor.PopupMsg.DeleteAll.ConfirmMsg", "gui.sfm.yes", "gui.sfm.no", b -> FlowComponent.removeGraph(this), b -> {}).tryAddSelfToActiveGUI();
        } else {
            this.remove();
        }
    }

    private void actionCopy() {
        this.save();
        CompoundNBT tag = this.procedure.serialize();
        Minecraft.func_71410_x().field_195559_v.func_197960_a(tag.toString());
    }

    private void actionCut() {
        this.actionCopy();
        this.remove();
    }

    private void actionChangeGroup() {
        Dialog.createPrompt("gui.sfm.FactoryManager.Editor.PopupMsg.ChangeGroup", (b, newGroup) -> {
            this.disconnect();
            this.setGroup((String)newGroup);
        }).tryAddSelfToActiveGUI();
    }

    public void save() {
        for (Menu menu : this.menus.getChildren()) {
            menu.updateData();
        }
        P proc = this.getProcedure();
        for (int i = 0; i < proc.successors().length; ++i) {
            Connection conn = proc.successors()[i];
            if (conn == null) continue;
            StartNode start = (StartNode)this.outputNodes.getChildren().get(i);
            conn.getPolylineNodes().clear();
            INode next = start.getNext();
            while (next != null && !next.getType().isTerminal()) {
                INode current = next;
                conn.getPolylineNodes().add(new Point(current.getPosition()));
                next = current.getNext();
            }
        }
    }

    public static void removeGraph(FlowComponent<?> start) {
        HashSet visited = new HashSet();
        ArrayDeque nexts = new ArrayDeque();
        nexts.add(start);
        while (!nexts.isEmpty()) {
            AbstractIconButton pair;
            FlowComponent node = (FlowComponent)nexts.remove();
            for (AbstractIconButton conn : node.inputNodes.getChildren()) {
                FlowComponent<?> prev;
                pair = ((EndNode)conn).getStart();
                if (pair == null || visited.contains(prev = ((StartNode)pair).getFlowComponent())) continue;
                visited.add(prev);
                nexts.add(prev);
            }
            for (AbstractIconButton conn : node.outputNodes.getChildren()) {
                FlowComponent<?> next;
                pair = ((StartNode)conn).getEnd();
                if (pair == null || visited.contains(next = ((EndNode)pair).getFlowComponent())) continue;
                visited.add(next);
                nexts.add(next);
            }
        }
        for (FlowComponent node : visited) {
            node.remove();
        }
    }

    public void disconnect() {
        this.inputNodes.removeAllConnections();
        this.outputNodes.removeAllConnections();
        NetworkHelper.removeAllConnectionsFor(this.procedure);
    }

    public void remove() {
        this.disconnect();
        this.procedure.invalidate();
        this.getParentWidget().removeFlowComponent(this);
    }

    public ConnectionNodes<EndNode> getInputNodes() {
        return this.inputNodes;
    }

    public ConnectionNodes<StartNode> getOutputNodes() {
        return this.outputNodes;
    }

    @Override
    @Nonnull
    public EditorPanel getParentWidget() {
        return Objects.requireNonNull((EditorPanel)super.getParentWidget());
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(int z) {
        this.zIndex = z;
    }

    @Override
    public int compareTo(FlowComponent<?> that) {
        return this.getZIndex() - that.getZIndex();
    }

    public P getProcedure() {
        return this.procedure;
    }

    public String getGroup() {
        return ((IClientDataStorage)this.procedure).getGroup();
    }

    public void setGroup(String group) {
        ((IClientDataStorage)this.procedure).setGroup(group);
        FactoryManagerGUI.getActiveGUI().getTopLevel().toolboxPanel.getGroupList().onProcedureGroupChanged();
    }

    public IClientDataStorage getDataHandler() {
        return (IClientDataStorage)this.procedure;
    }

    public void setLinkedProcedure(P procedure) {
        this.procedure = procedure;
        this.setName(((IClientDataStorage)procedure).getName());
        this.setLocation(((IClientDataStorage)procedure).getComponentX(), ((IClientDataStorage)procedure).getComponentY());
        this.repopulateErrors();
    }

    private void repopulateErrors() {
        this.errorIndicator.clearErrors();
        for (Menu menu : this.menus.getChildren()) {
            this.errorIndicator.populateErrors(menu);
        }
    }

    public void readConnections(Map<IProcedure, FlowComponent<?>> m) {
        this.inputNodes.readConnections(m, (IProcedure)this.procedure);
        this.outputNodes.readConnections(m, (IProcedure)this.procedure);
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        ((IClientDataStorage)this.procedure).setComponentX(x);
        ((IClientDataStorage)this.procedure).setComponentY(y);
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("Z=" + this.getZIndex());
    }

    public static class CancelButton
    extends AbstractIconButton {
        public static final TextureWrapper NORMAL = TextureWrapper.ofFlowComponent(0, 140, 7, 7);
        public static final TextureWrapper HOVERING = NORMAL.toRight(1);
        private String previousName;

        public CancelButton(FlowComponent<?> parent, String previousName) {
            super(-1, -1, 7, 7);
            this.setParentWidget(parent);
            this.setEnabled(false);
            this.previousName = previousName;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isEnabled() && button == 0) {
                this.cancel();
                return true;
            }
            return false;
        }

        public void cancel() {
            this.setEnabled(false);
            IWidget parent = this.getParentWidget();
            ((FlowComponent)parent).submitButton.setEnabled(false);
            ((FlowComponent)parent).renameButton.setEnabled(true);
            ((FlowComponent)parent).setName(this.previousName);
            ((FlowComponent)parent).nameBox.scrollToFront();
            ((FlowComponent)parent).nameBox.setEditable(false);
            this.getWindow().changeFocus(((FlowComponent)parent).nameBox, false);
            this.previousName = "";
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.previousName = ((FlowComponent)this.getParentWidget()).getName();
            }
        }

        @Override
        public TextureWrapper getTextureNormal() {
            return NORMAL;
        }

        @Override
        public TextureWrapper getTextureHovered() {
            return HOVERING;
        }

        @Override
        @Nonnull
        public FlowComponent<?> getParentWidget() {
            return Objects.requireNonNull((FlowComponent)super.getParentWidget());
        }

        @Override
        public BoxSizing getBoxSizing() {
            return BoxSizing.PHANTOM;
        }
    }

    public static class SubmitButton
    extends AbstractIconButton {
        public static final TextureWrapper NORMAL = TextureWrapper.ofFlowComponent(0, 133, 7, 7);
        public static final TextureWrapper HOVERING = NORMAL.toRight(1);

        public SubmitButton(FlowComponent<?> parent) {
            super(-1, -1, 7, 7);
            this.setParentWidget(parent);
            this.setEnabled(false);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isEnabled() && button == 0) {
                this.submit();
                return true;
            }
            return false;
        }

        public void submit() {
            this.setEnabled(false);
            IWidget parent = this.getParentWidget();
            ((FlowComponent)parent).cancelButton.setEnabled(false);
            ((FlowComponent)parent).renameButton.setEnabled(true);
            ((FlowComponent)parent).nameBox.scrollToFront();
            ((FlowComponent)parent).nameBox.setEditable(false);
            ((FlowComponent)parent).getDataHandler().setName(((FlowComponent)parent).getName());
            this.getWindow().changeFocus(((FlowComponent)parent).nameBox, false);
        }

        @Override
        public TextureWrapper getTextureNormal() {
            return NORMAL;
        }

        @Override
        public TextureWrapper getTextureHovered() {
            return HOVERING;
        }

        @Override
        @Nonnull
        public FlowComponent<?> getParentWidget() {
            return Objects.requireNonNull((FlowComponent)super.getParentWidget());
        }

        @Override
        public BoxSizing getBoxSizing() {
            return BoxSizing.PHANTOM;
        }
    }

    public static class RenameButton
    extends AbstractIconButton {
        public static final TextureWrapper NORMAL = TextureWrapper.ofFlowComponent(0, 124, 9, 9);
        public static final TextureWrapper HOVERING = NORMAL.toRight(1);

        public RenameButton(FlowComponent<?> parent) {
            super(-1, -1, 9, 9);
            this.setParentWidget(parent);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isEnabled() && button == 0) {
                this.setEnabled(false);
                IWidget parent = this.getParentWidget();
                ((FlowComponent)parent).submitButton.setEnabled(true);
                ((FlowComponent)parent).cancelButton.setEnabled(true);
                ((FlowComponent)parent).nameBox.setEditable(true);
                this.getWindow().setFocusedWidget(((FlowComponent)parent).nameBox);
                return true;
            }
            return false;
        }

        @Override
        public TextureWrapper getTextureNormal() {
            return NORMAL;
        }

        @Override
        public TextureWrapper getTextureHovered() {
            return HOVERING;
        }

        @Override
        @Nonnull
        public FlowComponent<?> getParentWidget() {
            return Objects.requireNonNull((FlowComponent)super.getParentWidget());
        }

        @Override
        public BoxSizing getBoxSizing() {
            return BoxSizing.PHANTOM;
        }
    }

    public static class ToggleStateButton
    extends AbstractIconButton {
        public ToggleStateButton(FlowComponent<?> parent) {
            super(-1, -1, 9, 10);
            this.setParentWidget(parent);
        }

        @Override
        public TextureWrapper getTextureNormal() {
            return ((FlowComponent)this.getParentWidget()).getState().toggleStateNormal;
        }

        @Override
        public TextureWrapper getTextureHovered() {
            return ((FlowComponent)this.getParentWidget()).getState().toggleStateHovered;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                ((FlowComponent)this.getParentWidget()).toggleState();
                return true;
            }
            return false;
        }

        @Override
        @Nonnull
        public FlowComponent<?> getParentWidget() {
            return Objects.requireNonNull((FlowComponent)super.getParentWidget());
        }

        @Override
        public BoxSizing getBoxSizing() {
            return BoxSizing.PHANTOM;
        }
    }

    public static enum State {
        COLLAPSED(TextureWrapper.ofFlowComponent(0, 0, 64, 20), TextureWrapper.ofFlowComponent(0, 20, 9, 10), TextureWrapper.ofFlowComponent(0, 30, 9, 10)),
        EXPANDED(TextureWrapper.ofFlowComponent(64, 0, 124, 152), TextureWrapper.ofFlowComponent(9, 20, 9, 10), TextureWrapper.ofFlowComponent(9, 30, 9, 10));

        public final TextureWrapper background;
        public final TextureWrapper toggleStateNormal;
        public final TextureWrapper toggleStateHovered;

        private State(TextureWrapper background, TextureWrapper toggleStateNormal, TextureWrapper toggleStateHovered) {
            this.background = background;
            this.toggleStateNormal = toggleStateNormal;
            this.toggleStateHovered = toggleStateHovered;
        }

        public int componentWidth() {
            return this.background.getPortionWidth();
        }

        public int componentHeight() {
            return this.background.getPortionHeight();
        }
    }
}

