/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IErrorPopulator;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.box.LinearList;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;

public abstract class Menu<P extends IProcedure & IClientDataStorage>
extends AbstractContainer<IWidget>
implements IErrorPopulator,
IWidget {
    private static final List<Supplier<IEntry>> EMPTY_LIST = ImmutableList.of();
    public static final TextureWrapper HEADING_BOX = TextureWrapper.ofFlowComponent(66, 152, 120, 13);
    public static final int DEFAULT_CONTENT_HEIGHT = 65;
    private FlowComponent<P> flowComponent;
    private State state = State.COLLAPSED;
    private ToggleStateButton toggleStateButton;
    private final List<IWidget> children;
    private List<Supplier<IEntry>> actionMenuEntries = EMPTY_LIST;

    public Menu() {
        super(0, 0, HEADING_BOX.getPortionWidth(), HEADING_BOX.getPortionHeight());
        this.toggleStateButton = new ToggleStateButton(this);
        this.children = new ArrayList<IWidget>();
        this.children.add(this.toggleStateButton);
    }

    @Override
    public List<IWidget> getChildren() {
        return this.children;
    }

    @Override
    public void reflow() {
    }

    public ToggleStateButton getToggleStateButton() {
        return this.toggleStateButton;
    }

    @Override
    public Menu<P> addChildren(IWidget widget) {
        this.children.add(widget);
        return this;
    }

    @Override
    public Menu<P> addChildren(Collection<IWidget> widgets) {
        this.children.addAll(widgets);
        return this;
    }

    public void toggleState() {
        this.state.toggleStateFor(this);
    }

    public void expand() {
        if (this.state == State.COLLAPSED) {
            this.state = State.EXPANDED;
            this.growHeight(this.getContentHeight());
            this.updateChildrenEnableState(true);
        }
    }

    public void collapse() {
        if (this.state == State.EXPANDED) {
            this.state = State.COLLAPSED;
            this.shrinkHeight(this.getContentHeight());
            this.updateChildrenEnableState(false);
        }
    }

    private void updateChildrenEnableState(boolean state) {
        for (IWidget child : this.children) {
            if (!BoxSizing.shouldIncludeWidget(child)) continue;
            child.setEnabled(state);
        }
    }

    public void growHeight(int growth) {
        this.setHeight(this.getHeight() + growth);
    }

    public void shrinkHeight(int shrinkage) {
        this.growHeight(-shrinkage);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        ((LinearList)this.getParentWidget()).reflow();
    }

    @Override
    public void setWidth(int width) {
        throw new UnsupportedOperationException();
    }

    public int getContentHeight() {
        return 65;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        if (!this.isEnabled()) {
            return;
        }
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        HEADING_BOX.draw(this.getAbsoluteX(), this.getAbsoluteY());
        this.renderHeadingText();
        if (this.state == State.EXPANDED) {
            this.renderContents(mouseX, mouseY, particleTicks);
        } else {
            this.toggleStateButton.render(mouseX, mouseY, particleTicks);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    public void renderHeadingText() {
        int y1 = this.getAbsoluteY();
        int y2 = y1 + HEADING_BOX.getPortionHeight();
        RenderingHelper.drawTextCenteredVertically(this.getHeadingText(), this.getHeadingLeftX(), y1, y2 + 1, this.getHeadingColor());
    }

    public int getHeadingLeftX() {
        return this.getAbsoluteX() + 5;
    }

    public int getHeadingColor() {
        return -12566464;
    }

    public abstract String getHeadingText();

    public void renderContents(int mouseX, int mouseY, float particleTicks) {
        for (IWidget child : this.children) {
            child.render(mouseX, mouseY, particleTicks);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isEnabled()) {
            return false;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return this.state != State.COLLAPSED || this.toggleStateButton.isInside(mouseX, mouseY);
        }
        if (this.isInside(mouseX, mouseY)) {
            this.getWindow().setFocusedWidget(this);
            if (button == 1) {
                ImmutableList.Builder list = ImmutableList.builder().add((Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Editor.CtxMenu.CollapseAll", b -> this.flowComponent.collapseAllMenus())).add((Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Editor.CtxMenu.ExpandAll", b -> this.flowComponent.expandAllMenus()));
                for (Supplier<IEntry> entry : this.actionMenuEntries) {
                    list.add((Object)entry.get());
                }
                ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)list.build());
                WidgetScreen.getCurrent().addPopupWindow(contextMenu);
            }
            return true;
        }
        return false;
    }

    protected void addContextMenuEntries(ImmutableList.Builder<IEntry> builder) {
    }

    protected void updateData() {
    }

    @Override
    @Nonnull
    public LinearList<Menu<P>> getParentWidget() {
        return Objects.requireNonNull((LinearList)super.getParentWidget());
    }

    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        Preconditions.checkState((this.flowComponent == null ? 1 : 0) != 0);
        this.flowComponent = flowComponent;
        this.setParentWidget(flowComponent.getMenusBox());
    }

    public FlowComponent<P> getFlowComponent() {
        return this.flowComponent;
    }

    public P getLinkedProcedure() {
        return this.flowComponent.getProcedure();
    }

    void useActionList(List<Supplier<IEntry>> actions) {
        this.actionMenuEntries = actions;
    }

    public void injectAction(Supplier<IEntry> action) {
        if (this.actionMenuEntries == EMPTY_LIST) {
            this.actionMenuEntries = new ArrayList<Supplier<IEntry>>();
        }
        this.actionMenuEntries.add(action);
    }

    public static class ToggleStateButton
    extends AbstractIconButton {
        public ToggleStateButton(Menu parent) {
            super(109, 2, 9, 9);
            this.setParentWidget(parent);
        }

        @Override
        public TextureWrapper getTextureNormal() {
            return ((Menu)this.getParentWidget()).state.toggleStateNormalTexture;
        }

        @Override
        public TextureWrapper getTextureHovered() {
            return ((Menu)this.getParentWidget()).state.toggleStateHoveringTexture;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            this.getParentWidget().toggleState();
            return true;
        }

        @Override
        @Nonnull
        public Menu getParentWidget() {
            return Objects.requireNonNull((Menu)super.getParentWidget());
        }

        @Override
        public BoxSizing getBoxSizing() {
            return BoxSizing.PHANTOM;
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            super.render(mouseX, mouseY, particleTicks);
        }
    }

    public static enum State {
        COLLAPSED(TextureWrapper.ofFlowComponent(0, 40, 9, 9), TextureWrapper.ofFlowComponent(9, 40, 9, 9)){

            @Override
            public void toggleStateFor(Menu menu) {
                menu.expand();
            }
        }
        ,
        EXPANDED(TextureWrapper.ofFlowComponent(0, 49, 9, 9), TextureWrapper.ofFlowComponent(9, 49, 9, 9)){

            @Override
            public void toggleStateFor(Menu menu) {
                menu.collapse();
            }
        };

        public final TextureWrapper toggleStateNormalTexture;
        public final TextureWrapper toggleStateHoveringTexture;

        private State(TextureWrapper toggleStateNormalTexture, TextureWrapper toggleStateHoveringTexture) {
            this.toggleStateNormalTexture = toggleStateNormalTexture;
            this.toggleStateHoveringTexture = toggleStateHoveringTexture;
        }

        public abstract void toggleStateFor(Menu var1);
    }
}

