/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.editor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.contextmenu.DefaultEntry;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.logic.item.IItemFilter;
import vswe.stevesfactory.logic.item.ItemTagFilter;
import vswe.stevesfactory.logic.item.ItemTraitsFilter;
import vswe.stevesfactory.logic.procedure.IItemFilterTarget;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;
import vswe.stevesfactory.ui.manager.menu.ItemTagFilterMenu;
import vswe.stevesfactory.ui.manager.menu.ItemTraitsFilterMenu;

public class PropertyManager<T, P extends IProcedure & IClientDataStorage> {
    private static final List<Supplier<IEntry>> EMPTY_LIST = ImmutableList.of();
    private final FlowComponent<P> flowComponent;
    private final List<Case<T, P>> cases = new ArrayList<Case<T, P>>();
    private final Supplier<T> propertyGetter;
    private final Consumer<T> propertySetter;
    private List<Supplier<IEntry>> actions = EMPTY_LIST;
    private Menu<P> menu;
    private int selectedIndex = -1;

    public static <P extends IProcedure & IClientDataStorage> PropertyManager<IItemFilter, P> createFilterMenu(P procedure, FlowComponent<P> flowComponent, int filterID) {
        PropertyManager<IItemFilter, P> pm = new PropertyManager<IItemFilter, P>(flowComponent, () -> ((IItemFilterTarget)((Object)procedure)).getFilter(filterID), filter -> ((IItemFilterTarget)((Object)procedure)).setFilter(filterID, (IItemFilter)filter));
        pm.on(filter -> filter instanceof ItemTraitsFilter).name(I18n.func_135052_a((String)"menu.sfm.ItemFilter.Traits", (Object[])new Object[0])).prop(ItemTraitsFilter::new).then(() -> new ItemTraitsFilterMenu(filterID, I18n.func_135052_a((String)"menu.sfm.ItemFilter.Traits", (Object[])new Object[0])));
        pm.on(filter -> filter instanceof ItemTagFilter).name(I18n.func_135052_a((String)"menu.sfm.ItemFilter.Tags", (Object[])new Object[0])).prop(ItemTagFilter::new).then(() -> new ItemTagFilterMenu(filterID, I18n.func_135052_a((String)"menu.sfm.ItemFilter.Tags", (Object[])new Object[0])));
        pm.actionCycling();
        pm.setProperty(((IItemFilterTarget)procedure).getFilter(filterID));
        return pm;
    }

    public PropertyManager(FlowComponent<P> flowComponent, Supplier<T> propertyGetter, Consumer<T> propertySetter) {
        this.flowComponent = flowComponent;
        this.propertyGetter = propertyGetter;
        this.propertySetter = propertySetter;
    }

    public Case<T, P> on(Predicate<T> condition) {
        Case caseElement = new Case(condition);
        this.cases.add(caseElement);
        return caseElement;
    }

    public T getProperty() {
        return this.propertyGetter.get();
    }

    public void setProperty(@Nonnull T property) {
        Preconditions.checkNotNull(property);
        int i = 0;
        for (Case<T, P> caseElement : this.cases) {
            if (caseElement.matches(property)) {
                if (i == this.selectedIndex) break;
                this.setPropertyBase(i, caseElement, property);
                break;
            }
            ++i;
        }
    }

    private void setProperty(int index) {
        Case<Object, P> expectedCase = this.cases.get(index);
        Object newProp = ((Case)expectedCase).createProperty();
        Preconditions.checkNotNull((Object)newProp);
        Preconditions.checkState((boolean)expectedCase.matches(newProp));
        this.setPropertyBase(index, expectedCase, newProp);
    }

    private void setPropertyBase(int index, Case<T, P> caseElement, T property) {
        this.selectedIndex = index;
        Menu<P> oldMenu = this.menu;
        if (oldMenu != null) {
            this.flowComponent.getMenusBox().getChildren().remove(oldMenu);
            oldMenu.onRemoved();
        }
        this.propertySetter.accept(property);
        this.menu = (Menu)((Case)caseElement).menuFactory.get();
        this.flowComponent.addMenu(this.menu);
        this.menu.setParentWidget(this.flowComponent.getMenusBox());
        this.flowComponent.getMenusBox().reflow();
        this.menu.useActionList(this.actions);
    }

    public Menu<P> getMenu() {
        return this.menu;
    }

    private void enableActions() {
        if (this.actions == EMPTY_LIST) {
            this.actions = new ArrayList<Supplier<IEntry>>();
        }
    }

    public void action(Supplier<IEntry> action) {
        this.enableActions();
        this.actions.add(action);
    }

    public void actionCycling() {
        this.action(() -> new DefaultEntry(null, ""){
            private int cachedIndex;
            private String cachedText;
            {
                this.cachedIndex = -1;
            }

            @Override
            public String getText() {
                this.updateText();
                return this.cachedText;
            }

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                int nextIndex = PropertyManager.this.selectedIndex + 1 >= PropertyManager.this.cases.size() ? 0 : PropertyManager.this.selectedIndex + 1;
                PropertyManager.this.setProperty(nextIndex);
                this.getWindow().alive = false;
                return true;
            }

            private void updateText() {
                int nextIndex;
                int n = nextIndex = PropertyManager.this.selectedIndex + 1 >= PropertyManager.this.cases.size() ? 0 : PropertyManager.this.selectedIndex + 1;
                if (this.cachedIndex != nextIndex || this.cachedText == null) {
                    Case nextCase = (Case)PropertyManager.this.cases.get(nextIndex);
                    this.cachedText = nextCase.hasName() ? I18n.func_135052_a((String)"gui.sfm.FactoryManager.Editor.CtxMenu.CycleProperty.Named", (Object[])new Object[]{nextCase.getName()}) : I18n.func_135052_a((String)"gui.sfm.FactoryManager.Editor.CtxMenu.CycleProperty", (Object[])new Object[0]);
                    this.cachedIndex = nextIndex;
                    this.reflowSafe();
                }
            }

            private void reflowSafe() {
                if (this.getWindow() != null) {
                    this.getWindow().reflow();
                }
            }
        });
    }

    public static final class Case<T, P extends IProcedure & IClientDataStorage> {
        private Predicate<T> condition;
        private Supplier<T> propertyFactory;
        private Supplier<Menu<P>> menuFactory;
        private String name;

        private Case(Predicate<T> condition) {
            this.condition = condition;
        }

        public Case<T, P> then(Supplier<Menu<P>> factory) {
            Preconditions.checkState((this.menuFactory == null ? 1 : 0) != 0);
            this.menuFactory = factory;
            return this;
        }

        public Case<T, P> prop(Supplier<T> factory) {
            Preconditions.checkState((this.propertyFactory == null ? 1 : 0) != 0);
            this.propertyFactory = factory;
            return this;
        }

        public Case<T, P> name(String name) {
            this.name = name;
            return this;
        }

        public boolean matches(T property) {
            return this.condition.test(property);
        }

        @Nullable
        private T createProperty() {
            return this.propertyFactory == null ? null : (T)this.propertyFactory.get();
        }

        public boolean hasName() {
            return this.name != null;
        }

        public String getName() {
            return this.name == null ? "" : this.name;
        }
    }
}

