/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.debug.ITextReceiver;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IButton;
import vswe.stevesfactory.library.gui.widget.INamedElement;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.render.BlockHighlight;

public class BlockTarget
extends AbstractWidget
implements IButton,
INamedElement,
LeafWidgetMixin {
    private boolean hovered = false;
    private boolean clicked = false;
    private boolean selected = false;
    public final BlockPos pos;
    private BlockState state;
    private ItemStack cachedItemStack;

    public BlockTarget(BlockPos pos) {
        this(pos, 16);
    }

    public BlockTarget(BlockPos pos, int size) {
        super(0, 0, size, size);
        this.pos = pos;
        this.setBlockState(Minecraft.func_71410_x().field_71441_e.func_180495_p(pos));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(null, "menu.sfm.BlockTarget.Highlight", b -> BlockHighlight.createHighlight(this.pos, 80))));
            WidgetScreen.getCurrent().addPopupWindow(contextMenu);
            return true;
        }
        this.clicked = true;
        this.setSelected(!this.selected);
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.clicked = false;
        return true;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        this.hovered = this.isInside(mouseX, mouseY);
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public boolean isClicked() {
        return this.clicked;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public BlockState getBlockState() {
        return this.state;
    }

    public void setBlockState(BlockState state) {
        this.state = state;
        this.cachedItemStack = new ItemStack((IItemProvider)state.func_177230_c());
    }

    public ItemStack getCachedItemStack() {
        return this.cachedItemStack;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        int color = this.selected ? (this.hovered ? -10303174 : -5386336) : (this.hovered ? -2829100 : -5987164);
        RenderingHelper.drawRect(x, y, this.getAbsoluteXRight(), this.getAbsoluteYBottom(), color);
        GlStateManager.disableDepthTest();
        GlStateManager.enableTexture();
        RenderHelper.func_74520_c();
        Minecraft.func_71410_x().func_175599_af().func_175042_a(this.cachedItemStack, x + (this.getWidth() - 16) / 2, y + (this.getHeight() - 16) / 2);
        if (this.hovered) {
            WidgetScreen.getCurrent().setHoveringText(new ItemStack((IItemProvider)this.state.func_177230_c().func_199767_j()), mouseX, mouseY);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)this.state.func_177230_c().func_149739_a(), (Object[])new Object[0]);
    }

    @Override
    public void provideInformation(ITextReceiver receiver) {
        super.provideInformation(receiver);
        receiver.line("BlockState=" + this.state);
    }
}

