/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Direction;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.logic.procedure.IDirectionTarget;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;
import vswe.stevesfactory.ui.manager.menu.ActivationButton;
import vswe.stevesfactory.ui.manager.menu.DirectionButton;

public class DirectionSelectionMenu<P extends IDirectionTarget & IProcedure>
extends Menu<P> {
    private final int id;
    private final String name;
    private final String errorMessage;
    private DirectionButton down;
    private DirectionButton up;
    private DirectionButton north;
    private DirectionButton south;
    private DirectionButton east;
    private DirectionButton west;
    private ActivationButton activationButton;

    public DirectionSelectionMenu(int id) {
        this(id, I18n.func_135052_a((String)"menu.sfm.TargetSides", (Object[])new Object[0]), I18n.func_135052_a((String)"error.sfm.ItemIO.NoTarget", (Object[])new Object[0]));
    }

    public DirectionSelectionMenu(int id, String name, String errorMessage) {
        this.id = id;
        this.name = name;
        this.errorMessage = errorMessage;
        this.down = new DirectionButton(Direction.DOWN);
        this.down.onStateChanged = b -> ((IDirectionTarget)this.getLinkedProcedure()).setEnabled(id, Direction.DOWN, b);
        this.up = new DirectionButton(Direction.UP);
        this.up.onStateChanged = b -> ((IDirectionTarget)this.getLinkedProcedure()).setEnabled(id, Direction.UP, b);
        this.north = new DirectionButton(Direction.NORTH);
        this.north.onStateChanged = b -> ((IDirectionTarget)this.getLinkedProcedure()).setEnabled(id, Direction.NORTH, b);
        this.south = new DirectionButton(Direction.SOUTH);
        this.south.onStateChanged = b -> ((IDirectionTarget)this.getLinkedProcedure()).setEnabled(id, Direction.SOUTH, b);
        this.east = new DirectionButton(Direction.EAST);
        this.east.onStateChanged = b -> ((IDirectionTarget)this.getLinkedProcedure()).setEnabled(id, Direction.EAST, b);
        this.west = new DirectionButton(Direction.WEST);
        this.west.onStateChanged = b -> ((IDirectionTarget)this.getLinkedProcedure()).setEnabled(id, Direction.WEST, b);
        this.activationButton = new ActivationButton(this.down);
        int y = HEADING_BOX.getPortionHeight() + 4;
        this.down.setLocation(2, y);
        this.north.setLocation(this.down.getX(), this.down.getY() + this.down.getHeight() + 6);
        this.west.setLocation(this.down.getX(), this.north.getY() + this.north.getHeight() + 6);
        this.up.setLocation(this.getWidth() - 2 - this.up.getWidth(), y);
        this.south.setLocation(this.up.getX(), this.up.getY() + this.up.getHeight() + 6);
        this.east.setLocation(this.up.getX(), this.south.getY() + this.south.getHeight() + 6);
        int leftMid = this.down.getX() + this.down.getWidth();
        int rightMid = this.up.getX();
        this.activationButton.setLocation(RenderingHelper.getXForAlignedCenter(leftMid, rightMid, this.activationButton.getWidth()), y);
        this.activationButton.setEditingState(false);
        this.addChildren(this.down);
        this.addChildren(this.up);
        this.addChildren(this.north);
        this.addChildren(this.south);
        this.addChildren(this.east);
        this.addChildren(this.west);
        this.addChildren(this.activationButton);
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        for (Direction direction : ((IDirectionTarget)this.getLinkedProcedure()).getDirections(this.id)) {
            switch (direction) {
                case DOWN: {
                    this.down.setSelected(true);
                    break;
                }
                case UP: {
                    this.up.setSelected(true);
                    break;
                }
                case NORTH: {
                    this.north.setSelected(true);
                    break;
                }
                case SOUTH: {
                    this.south.setSelected(true);
                    break;
                }
                case WEST: {
                    this.west.setSelected(true);
                    break;
                }
                case EAST: {
                    this.east.setSelected(true);
                }
            }
        }
    }

    void clearEditing() {
        this.activationButton.setEditingState(false);
    }

    void editDirection(DirectionButton button) {
        this.activationButton.setEditingState(true);
        this.activationButton.setTarget(button);
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableTexture();
        super.render(mouseX, mouseY, particleTicks);
    }

    @Override
    public String getHeadingText() {
        return this.name;
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        if (!this.hasAnythingSelected()) {
            errors.add(this.errorMessage);
        }
        return errors;
    }

    private boolean hasAnythingSelected() {
        return this.down.isSelected() || this.up.isSelected() || this.north.isSelected() || this.south.isSelected() || this.east.isSelected() || this.west.isSelected();
    }
}

