/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.layout.FlowLayout;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractContainer;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.NumberField;
import vswe.stevesfactory.library.gui.widget.TextButton;
import vswe.stevesfactory.library.gui.widget.TextField;
import vswe.stevesfactory.logic.item.ItemTraitsFilter;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.menu.ConfigurableSlot;
import vswe.stevesfactory.ui.manager.menu.MultiLayerMenu;

public class FilterSlot
extends ConfigurableSlot<Editor> {
    private final int index;
    private final ItemTraitsFilter filter;

    public FilterSlot(ItemTraitsFilter filter, int index, ItemStack stack) {
        super(stack);
        this.filter = filter;
        this.index = index;
        this.setDimensions(16, 16);
    }

    @Override
    protected boolean hasEditor() {
        return true;
    }

    @Override
    @Nonnull
    protected Editor createEditor() {
        return new Editor();
    }

    @Override
    public void openEditor() {
        super.openEditor();
        ((Editor)this.editor).update();
    }

    @Override
    protected void onSetStack() {
        this.filter.getItems().set(this.index, this.stack);
    }

    private static class DeleteFilterButton
    extends TextButton {
        private DeleteFilterButton() {
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            super.render(mouseX, mouseY, particleTicks);
            if (this.isHovered()) {
                WidgetScreen.getCurrent().setHoveringText(I18n.func_135052_a((String)"menu.sfm.Delete.Info", (Object[])new Object[0]), mouseX, mouseY);
            }
        }

        @Override
        protected void renderText() {
            GlStateManager.pushMatrix();
            GlStateManager.enableTexture();
            GlStateManager.translatef((float)(this.getAbsoluteX() + 2), (float)(this.getAbsoluteY() + 2), (float)0.0f);
            GlStateManager.scalef((float)0.8f, (float)0.8f, (float)1.0f);
            RenderingHelper.fontRenderer().func_211126_b(this.getText(), 0.0f, 0.0f, this.getTextColor());
            GlStateManager.popMatrix();
        }

        @Override
        public int getTextColor() {
            return -5298393;
        }

        @Override
        public int getNormalBorderColor() {
            return -5298393;
        }

        @Override
        public int getHoveredBorderColor() {
            return -6932681;
        }

        @Override
        public BoxSizing getBoxSizing() {
            return BoxSizing.PHANTOM;
        }
    }

    public class Editor
    extends AbstractContainer<IWidget> {
        private final NumberField<Integer> count;
        private final NumberField<Integer> damage;
        private final List<IWidget> children;

        public Editor() {
            MultiLayerMenu<?> menu = FilterSlot.this.getMenu();
            this.setDimensions(menu.getWidth(), menu.getContentHeight());
            DeleteFilterButton delete = new DeleteFilterButton();
            delete.setText(I18n.func_135052_a((String)"menu.sfm.Delete", (Object[])new Object[0]));
            delete.setDimensions(32, 11);
            delete.setLocation(this.getWidth() - delete.getWidth() - 2, 2);
            delete.onClick = b -> {
                FilterSlot.this.closeEditor();
                FilterSlot.this.stack = ItemStack.field_190927_a;
                FilterSlot.this.onSetStack();
            };
            AbstractIconButton close = new AbstractIconButton(this.getWidth() - 8 - 1, this.getHeight() - 8 - 1, 8, 8){

                @Override
                public void render(int mouseX, int mouseY, float particleTicks) {
                    super.render(mouseX, mouseY, particleTicks);
                    if (this.isHovered()) {
                        WidgetScreen.getCurrent().setHoveringText(I18n.func_135052_a((String)"menu.sfm.CloseEditor.Info", (Object[])new Object[0]), mouseX, mouseY);
                    }
                }

                @Override
                public TextureWrapper getTextureNormal() {
                    return FactoryManagerGUI.CLOSE_ICON;
                }

                @Override
                public TextureWrapper getTextureHovered() {
                    return FactoryManagerGUI.CLOSE_ICON_HOVERED;
                }

                @Override
                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    FilterSlot.this.closeEditor();
                    return super.mouseClicked(mouseX, mouseY, button);
                }

                @Override
                public BoxSizing getBoxSizing() {
                    return BoxSizing.PHANTOM;
                }
            };
            this.count = NumberField.integerFieldRanged(33, 12, 1, 1, Integer.MAX_VALUE);
            this.count.setValue(FilterSlot.this.stack.func_190916_E());
            this.count.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
            this.count.setLabel(I18n.func_135052_a((String)"menu.sfm.ItemFilter.Traits.Amount", (Object[])new Object[0]));
            this.count.onValueUpdated = arg_0 -> ((ItemStack)FilterSlot.this.stack).func_190920_e(arg_0);
            this.damage = NumberField.integerField(33, 12);
            this.damage.setValue(FilterSlot.this.stack.func_77952_i());
            this.damage.setBackgroundStyle(TextField.BackgroundStyle.RED_OUTLINE);
            this.damage.setLabel(I18n.func_135052_a((String)"menu.sfm.ItemFilter.Traits.Damage", (Object[])new Object[0]));
            this.damage.onValueUpdated = arg_0 -> ((ItemStack)FilterSlot.this.stack).func_196085_b(arg_0);
            this.children = ImmutableList.of((Object)close, (Object)delete, this.count, this.damage);
            this.reflow();
        }

        @Override
        public Collection<IWidget> getChildren() {
            return this.children;
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
            super.render(mouseX, mouseY, particleTicks);
            this.renderItem();
            RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
        }

        private void renderItem() {
            GlStateManager.disableDepthTest();
            GlStateManager.enableTexture();
            RenderHelper.func_74520_c();
            ItemRenderer ir = Minecraft.func_71410_x().func_175599_af();
            int x = this.getAbsoluteX() + 4;
            int y = this.getAbsoluteY() + 4;
            ir.func_180450_b(FilterSlot.this.stack, x, y);
            ir.func_180453_a(RenderingHelper.fontRenderer(), FilterSlot.this.stack, x, y, "");
            RenderHelper.func_74518_a();
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void reflow() {
            FlowLayout.vertical(this.children, 4, 24, 4);
        }

        public void update() {
            this.count.setEnabled(FilterSlot.this.filter.isMatchingAmount());
            this.damage.setEnabled(FilterSlot.this.stack.func_77984_f() && FilterSlot.this.filter.isMatchingDamage());
        }
    }
}

