/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractIconButton;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.editor.Menu;

public abstract class MultiLayerMenu<P extends IProcedure & IClientDataStorage>
extends Menu<P> {
    private IWidget openEditor;

    @Override
    public void renderContents(int mouseX, int mouseY, float particleTicks) {
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.openEditor != null) {
            this.getToggleStateButton().render(mouseX, mouseY, particleTicks);
            this.openEditor.render(mouseX, mouseY, particleTicks);
        } else {
            super.renderContents(mouseX, mouseY, particleTicks);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.openEditor != null) {
            if (this.getToggleStateButton().isInside(mouseX, mouseY)) {
                return this.getToggleStateButton().mouseClicked(mouseX, mouseY, button);
            }
            return this.openEditor.mouseClicked(mouseX, mouseY, button);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.openEditor != null) {
            if (this.getToggleStateButton().isInside(mouseX, mouseY)) {
                return this.getToggleStateButton().mouseReleased(mouseX, mouseY, button);
            }
            return this.openEditor.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.openEditor != null) {
            return this.openEditor.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        if (this.openEditor != null) {
            return this.openEditor.mouseScrolled(mouseX, mouseY, scroll);
        }
        return super.mouseScrolled(mouseX, mouseY, scroll);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.openEditor != null) {
            return this.openEditor.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.openEditor != null) {
            return this.openEditor.keyReleased(keyCode, scanCode, modifiers);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(char charTyped, int keyCode) {
        if (this.openEditor != null) {
            return this.openEditor.charTyped(charTyped, keyCode);
        }
        return super.charTyped(charTyped, keyCode);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.openEditor != null) {
            this.openEditor.mouseMoved(mouseX, mouseY);
        } else {
            super.mouseMoved(mouseX, mouseY);
        }
    }

    @Override
    public void update(float particleTicks) {
        if (this.openEditor != null) {
            this.openEditor.update(particleTicks);
        } else {
            super.update(particleTicks);
        }
    }

    @Override
    public void notifyChildrenForPositionChange() {
        super.notifyChildrenForPositionChange();
        if (this.openEditor != null) {
            this.openEditor.onParentPositionChanged();
        }
    }

    public IWidget getOpenEditor() {
        return this.openEditor;
    }

    public void openEditor(@Nullable IWidget editor) {
        this.openEditor = editor;
        if (editor != null) {
            editor.setParentWidget(this);
            editor.setLocation(0, HEADING_BOX.getPortionHeight());
        }
    }

    public abstract IWidget getEditor();

    public static class OpenSettingsButton
    extends AbstractIconButton {
        public OpenSettingsButton(int x, int y) {
            super(x, y, 12, 12);
        }

        @Override
        public TextureWrapper getTextureNormal() {
            return FactoryManagerGUI.SETTINGS_ICON;
        }

        @Override
        public TextureWrapper getTextureHovered() {
            return FactoryManagerGUI.SETTINGS_ICON_HOVERED;
        }

        @Override
        public void render(int mouseX, int mouseY, float particleTicks) {
            super.render(mouseX, mouseY, particleTicks);
            if (this.isHovered()) {
                WidgetScreen.getCurrent().setHoveringText(I18n.func_135052_a((String)"menu.sfm.ItemFilter.Traits.Settings", (Object[])new Object[0]), mouseX, mouseY);
            }
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            IWidget parent = this.getParentWidget();
            ((MultiLayerMenu)parent).openEditor(((MultiLayerMenu)parent).getEditor());
            return true;
        }

        @Override
        @Nonnull
        public MultiLayerMenu<?> getParentWidget() {
            return (MultiLayerMenu)Objects.requireNonNull(super.getParentWidget());
        }
    }
}

