/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.tool.group;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import vswe.stevesfactory.library.gui.contextmenu.CallbackEntry;
import vswe.stevesfactory.library.gui.contextmenu.ContextMenu;
import vswe.stevesfactory.library.gui.contextmenu.IEntry;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.TextButton;
import vswe.stevesfactory.library.gui.window.Dialog;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.tool.group.GroupList;

public class GroupButton
extends TextButton {
    private final String groupName;

    public GroupButton(String name) {
        this.groupName = name;
        this.setText(name.isEmpty() ? I18n.func_135052_a((String)"gui.sfm.FactoryManager.Tool.Group.DefaultGroup", (Object[])new Object[0]) : name);
        this.setHeight(12);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        switch (button) {
            case 0: {
                this.actionSwitchGroup();
                return true;
            }
            case 1: {
                this.openContextMenu();
                return true;
            }
        }
        return false;
    }

    private void openContextMenu() {
        ContextMenu contextMenu = ContextMenu.atCursor((List<? extends IEntry>)ImmutableList.of((Object)new CallbackEntry(FactoryManagerGUI.DELETE_ICON, "gui.sfm.FactoryManager.Tool.Group.CtxMenu.Delete", b -> this.actionDelete()), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Tool.Group.CtxMenu.RenameGroup", b -> this.actionRename()), (Object)new CallbackEntry(null, "gui.sfm.FactoryManager.Tool.Group.CtxMenu.MoveContent", b -> this.actionMoveContent())));
        WidgetScreen.getCurrent().addPopupWindow(contextMenu);
    }

    private void actionSwitchGroup() {
        FactoryManagerGUI.getActiveGUI().getTopLevel().editorPanel.setCurrentGroup(this.groupName);
    }

    private void actionDelete() {
        GroupList groupList = this.getGroupList();
        groupList.delete(this.groupName);
        groupList.onProcedureGroupChanged();
    }

    private void actionRename() {
        Dialog.createPrompt("gui.sfm.FactoryManager.Tool.Group.PopupMsg.RenameGroup", (b, newName) -> {
            GroupList groupList = this.getGroupList();
            for (GroupButton group : groupList.getChildren()) {
                if (group == this || !this.groupName.equals(group.groupName)) continue;
                Dialog.createDialog(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Tool.Group.PopupMsg.RenameFailed", (Object[])new Object[]{newName})).tryAddSelfToActiveGUI();
                return;
            }
            groupList.move(this.groupName, (String)newName);
            groupList.onProcedureGroupChanged();
        }).tryAddSelfToActiveGUI();
    }

    private void actionMoveContent() {
        Dialog.createPrompt("gui.sfm.FactoryManager.Tool.Group.PopupMsg.MoveContent", (b, toGroup) -> {
            GroupList groupList = this.getGroupList();
            boolean exists = false;
            for (GroupButton group : groupList.getChildren()) {
                if (!toGroup.equals(group.groupName)) continue;
                exists = true;
                break;
            }
            if (!exists) {
                Dialog.createDialog(I18n.func_135052_a((String)"gui.sfm.FactoryManager.Tool.Group.PopupMsg.MoveFailed", (Object[])new Object[]{toGroup})).tryAddSelfToActiveGUI();
                return;
            }
            groupList.move(this.groupName, (String)toGroup);
            groupList.onProcedureGroupChanged();
        }).tryAddSelfToActiveGUI();
    }

    private GroupList getGroupList() {
        return FactoryManagerGUI.getActiveGUI().getTopLevel().toolboxPanel.getGroupList();
    }

    public String getGroupName() {
        return this.groupName;
    }
}

