/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.toolbox;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.function.Supplier;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.TextureWrapper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.ui.manager.FactoryManagerGUI;
import vswe.stevesfactory.ui.manager.tool.ToolPanel;
import vswe.stevesfactory.ui.manager.toolbox.IToolType;

public class IconToolType<T extends IWidget>
extends AbstractWidget
implements IToolType,
LeafWidgetMixin {
    public static final int NORMAL_BORDER_COLOR = -7566196;
    public static final int HOVERED_BORDER_COLOR = -7566196;
    public static final int NORMAL_FILLER_COLOR = -9211021;
    public static final int HOVERED_FILLER_COLOR = -3552823;
    public static final int FONT_HEIGHT = 5;
    public static final int LABEL_VERTICAL_GAP = 3;
    private TextureWrapper tex;
    private String name = "";
    private Supplier<T> toolWindowConstructor;
    private T cachedToolWindow;

    public IconToolType(TextureWrapper tex, Supplier<T> toolWindowConstructor) {
        super(0, 0, tex.getPortionWidth() / 2, tex.getPortionHeight() / 2);
        this.tex = tex;
        this.toolWindowConstructor = toolWindowConstructor;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableTexture();
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int x1 = this.getAbsoluteX();
        int y1 = this.getAbsoluteY();
        int x2 = this.getAbsoluteXRight();
        int y2 = this.getAbsoluteYBottom();
        boolean hovered = this.isInside(mouseX, mouseY);
        RenderingHelper.rectVertices(x1, y1, x2, y2, hovered ? -7566196 : -7566196);
        RenderingHelper.rectVertices(x1 + 1, y1 + 1, x2 - 1, y2 - 1, hovered ? -3552823 : -9211021);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.enableAlphaTest();
        int textureSize = this.getWidth();
        this.tex.draw(x1, y1, textureSize, textureSize);
        RenderingHelper.drawVerticalText(this.name, x1 + 1, y1 + textureSize + 3, 5, -1);
        if (hovered && !this.name.isEmpty()) {
            WidgetScreen.getCurrent().setHoveringText(this.name, mouseX, mouseY);
        }
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        ToolPanel panel = FactoryManagerGUI.getActiveGUI().getTopLevel().toolPanel;
        panel.setActivePanel(this.getToolWindow());
        return true;
    }

    public T getToolWindow() {
        if (this.cachedToolWindow == null) {
            this.cachedToolWindow = (IWidget)this.toolWindowConstructor.get();
        }
        return this.cachedToolWindow;
    }

    public String getName() {
        return this.name;
    }

    public IconToolType<T> setName(String name) {
        this.name = name;
        this.setHeight(this.getHeight() + 3 + RenderingHelper.textWidth(name, 5) + 3);
        return this;
    }
}

