/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.utils;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import vswe.stevesfactory.logic.item.IItemFilter;

public final class IOHelper {
    private IOHelper() {
    }

    public static ListNBT writeBlockPoses(Collection<BlockPos> poses) {
        return IOHelper.writeBlockPoses(poses, new ListNBT());
    }

    public static ListNBT writeBlockPoses(Collection<BlockPos> poses, ListNBT target) {
        for (BlockPos pos : poses) {
            target.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        return target;
    }

    public static <T extends Collection<BlockPos>> T readBlockPoses(ListNBT serializedPoses, T target) {
        for (int i = 0; i < serializedPoses.size(); ++i) {
            target.add((BlockPos)NBTUtil.func_186861_c((CompoundNBT)serializedPoses.func_150305_b(i)));
        }
        return target;
    }

    public static void writeBlockPoses(Collection<BlockPos> poses, PacketBuffer buf) {
        buf.writeInt(poses.size());
        for (BlockPos linkable : poses) {
            buf.func_179255_a(linkable);
        }
    }

    public static <T extends IInventory> T readInventory(ListNBT serializedStacks, T target) {
        Preconditions.checkArgument((serializedStacks.size() == target.func_70302_i_() ? 1 : 0) != 0);
        for (int i = 0; i < serializedStacks.size(); ++i) {
            CompoundNBT tag = serializedStacks.func_150305_b(i);
            target.func_70299_a(i, ItemStack.func_199557_a((CompoundNBT)tag));
        }
        return target;
    }

    public static <T extends Collection<ItemStack>> T readItemStacks(ListNBT serializedFilters, T target) {
        for (int i = 0; i < serializedFilters.size(); ++i) {
            target.add((ItemStack)ItemStack.func_199557_a((CompoundNBT)serializedFilters.func_150305_b(i)));
        }
        return target;
    }

    public static ListNBT writeInventory(IInventory inventory) {
        return IOHelper.writeInventory(inventory, new ListNBT());
    }

    public static ListNBT writeInventory(IInventory inventory, ListNBT target) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            target.add((Object)inventory.func_70301_a(i).func_77955_b(new CompoundNBT()));
        }
        return target;
    }

    public static ListNBT writeItemStacks(Collection<ItemStack> stacks) {
        return IOHelper.writeItemStacks(stacks, new ListNBT());
    }

    public static ListNBT writeItemStacks(Collection<ItemStack> filters, ListNBT target) {
        for (ItemStack stack : filters) {
            target.add((Object)stack.func_77955_b(new CompoundNBT()));
        }
        return target;
    }

    public static <T extends Collection<Tag<Item>>> T readItemTags(ListNBT serializedFilters, T target) {
        for (int i = 0; i < serializedFilters.size(); ++i) {
            ResourceLocation id = new ResourceLocation(serializedFilters.func_150307_f(i));
            ItemTags.Wrapper tag = new ItemTags.Wrapper(id);
            target.add((ItemTags.Wrapper)tag);
        }
        return target;
    }

    public static <T> ListNBT writeTags(Collection<Tag<T>> tags, ListNBT target) {
        for (Tag<T> tag : tags) {
            target.add((Object)new StringNBT(tag.func_199886_b().toString()));
        }
        return target;
    }

    public static <T> ListNBT writeTags(Collection<Tag<T>> tags) {
        return IOHelper.writeTags(tags, new ListNBT());
    }

    public static CompoundNBT writeItemFilter(IItemFilter filter) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("TypeID", filter.getTypeID());
        filter.write(tag);
        return tag;
    }

    public static IItemFilter readItemFilter(CompoundNBT tag) {
        int typeID = tag.func_74762_e("TypeID");
        Function<CompoundNBT, IItemFilter> deserializer = IItemFilter.ItemFilters.getDeserializerFor(typeID);
        Preconditions.checkArgument((deserializer != null ? 1 : 0) != 0);
        return deserializer.apply(tag);
    }

    public static <T extends Collection<BlockPos>> T readBlockPoses(PacketBuffer buf, T target) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            target.add((BlockPos)buf.func_179259_c());
        }
        return target;
    }

    public static <T extends Collection<BlockPos>> T readBlockPosesSized(PacketBuffer buf, IntFunction<T> targetFactory) {
        int size = buf.readInt();
        Collection target = (Collection)targetFactory.apply(size);
        for (int i = 0; i < size; ++i) {
            target.add(buf.func_179259_c());
        }
        return (T)target;
    }

    public static int[] direction2Index(Collection<Direction> directions) {
        int[] res = new int[directions.size()];
        int i = 0;
        for (Direction direction : directions) {
            res[i] = direction.func_176745_a();
            ++i;
        }
        return res;
    }

    public static List<Direction> index2Direction(int[] indices) {
        ArrayList<Direction> res = new ArrayList<Direction>(indices.length);
        for (int index : indices) {
            res.add(Direction.func_82600_a((int)index));
        }
        return res;
    }

    public static <T extends Collection<Direction>> T index2Direction(int[] indices, IntFunction<T> factory) {
        Collection collection = (Collection)factory.apply(indices.length);
        for (int index : indices) {
            collection.add(Direction.func_82600_a((int)index));
        }
        return (T)collection;
    }

    public static <T extends Collection<Direction>> T index2DirectionFill(int[] indices, T collection) {
        for (int index : indices) {
            collection.add((Direction)Direction.func_82600_a((int)index));
        }
        return collection;
    }

    public static ListNBT writeStrings(Collection<String> texts) {
        ListNBT list = new ListNBT();
        for (String text : texts) {
            list.add((Object)new StringNBT(text));
        }
        return list;
    }

    public static ListNBT writeStrings(String[] texts) {
        ListNBT list = new ListNBT();
        for (String text : texts) {
            list.add((Object)new StringNBT(text));
        }
        return list;
    }

    public static <T extends Collection<String>> T readStrings(ListNBT list, T target) {
        for (int i = 0; i < list.size(); ++i) {
            target.add((String)list.func_150307_f(i));
        }
        return target;
    }

    public static String[] readStrings(ListNBT list) {
        String[] result = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.func_150307_f(i);
        }
        return result;
    }

    public static String[] readStrings(ListNBT list, String[] target) {
        Preconditions.checkArgument((list.size() == target.length ? 1 : 0) != 0);
        for (int i = 0; i < list.size(); ++i) {
            target[i] = list.func_150307_f(i);
        }
        return target;
    }
}

