/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vswe.stevesfactory.ClientEventHandler;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.network.NetworkHandler;
import vswe.stevesfactory.network.PacketReloadComponentGroups;
import vswe.stevesfactory.setup.ModBlocks;
import vswe.stevesfactory.setup.ModContainers;
import vswe.stevesfactory.setup.ModItems;
import vswe.stevesfactory.ui.manager.selection.ComponentGroup;

@Mod(value="sfm")
public class StevesFactoryManager {
    public static final String MODID = "sfm";
    public static final String NAME = "Steve's Factory Manager";
    public static final Logger logger = LogManager.getLogger((String)"sfm");
    public static StevesFactoryManager instance;

    public StevesFactoryManager() {
        instance = this;
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::finishLoading);
        bus.addListener(Config::onLoad);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        ModBlocks.blocks.register(bus);
        ModBlocks.tiles.register(bus);
        ModItems.items.register(bus);
        bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::serverStarting);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(ClientEventHandler::onPlayerLoggedIn));
    }

    private void setup(FMLCommonSetupEvent event) {
        NetworkHandler.register();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ModContainers.registerFactories();
        ComponentGroup.reload(false);
    }

    private void finishLoading(FMLLoadCompleteEvent event) {
        ModBlocks.blocks = null;
        ModBlocks.tiles = null;
        ModItems.items = null;
    }

    private void serverStarting(FMLServerStartingEvent event) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)MODID).then(StevesFactoryManager.componentGroupsCommand());
        event.getCommandDispatcher().register(builder);
    }

    private static LiteralArgumentBuilder<CommandSource> componentGroupsCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"componentGroups").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reload").requires(source -> source.func_197022_f() instanceof ServerPlayerEntity)).executes(context -> {
            ServerPlayerEntity client = ((CommandSource)context.getSource()).func_197035_h();
            PacketReloadComponentGroups.reload(client);
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset").requires(source -> source.func_197022_f() instanceof ServerPlayerEntity)).executes(context -> {
            ServerPlayerEntity client = ((CommandSource)context.getSource()).func_197035_h();
            PacketReloadComponentGroups.reset(client);
            return 0;
        }));
    }
}

