/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.api.capability;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IRedstoneEventDispatcher {
    public boolean hasSignal();

    public void subscribe(Consumer<SignalStatus> var1);

    public void subscribe(Predicate<SignalStatus> var1);

    public static final class SignalStatus {
        private int down;
        private int up;
        private int north;
        private int south;
        private int west;
        private int east;
        private boolean signal;

        public static SignalStatus scan(World world, BlockPos pos) {
            int down = world.func_175651_c(pos.func_177977_b(), Direction.DOWN);
            int up = world.func_175651_c(pos.func_177984_a(), Direction.UP);
            int north = world.func_175651_c(pos.func_177978_c(), Direction.NORTH);
            int south = world.func_175651_c(pos.func_177968_d(), Direction.SOUTH);
            int west = world.func_175651_c(pos.func_177976_e(), Direction.WEST);
            int east = world.func_175651_c(pos.func_177974_f(), Direction.EAST);
            boolean signal = down > 0 || up > 0 || north > 0 || south > 0 || west > 0 || east > 0;
            return new SignalStatus(down, up, north, south, west, east, signal);
        }

        public SignalStatus(int down, int up, int north, int south, int west, int east, boolean signal) {
            this.up = up;
            this.down = down;
            this.north = north;
            this.south = south;
            this.east = east;
            this.west = west;
            this.signal = signal;
        }

        public SignalStatus() {
        }

        public int getDown() {
            return this.down;
        }

        public int getUp() {
            return this.up;
        }

        public int getNorth() {
            return this.north;
        }

        public int getSouth() {
            return this.south;
        }

        public int getWest() {
            return this.west;
        }

        public int getEast() {
            return this.east;
        }

        public boolean hasSignal() {
            return this.signal;
        }

        public int get(Direction direction) {
            switch (direction) {
                case DOWN: {
                    return this.down;
                }
                case UP: {
                    return this.up;
                }
                case NORTH: {
                    return this.north;
                }
                case SOUTH: {
                    return this.south;
                }
                case WEST: {
                    return this.west;
                }
                case EAST: {
                    return this.east;
                }
            }
            throw new IllegalArgumentException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SignalStatus that = (SignalStatus)o;
            return this.down == that.down && this.up == that.up && this.north == that.north && this.south == that.south && this.west == that.west && this.east == that.east;
        }

        public int hashCode() {
            return Objects.hash(this.down, this.up, this.north, this.south, this.west, this.east);
        }

        public void read(CompoundNBT compound) {
            this.down = compound.func_74762_e("Down");
            this.up = compound.func_74762_e("Up");
            this.north = compound.func_74762_e("North");
            this.south = compound.func_74762_e("South");
            this.west = compound.func_74762_e("West");
            this.east = compound.func_74762_e("East");
            this.signal = this.down > 0 || this.up > 0 || this.north > 0 || this.south > 0 || this.west > 0 || this.east > 0;
        }

        public CompoundNBT write(CompoundNBT compound) {
            compound.func_74768_a("Down", this.down);
            compound.func_74768_a("Up", this.up);
            compound.func_74768_a("North", this.north);
            compound.func_74768_a("South", this.south);
            compound.func_74768_a("West", this.west);
            compound.func_74768_a("East", this.east);
            return compound;
        }
    }
}

