/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.api.capability.CapabilityRedstone;
import vswe.stevesfactory.api.capability.RedstoneSignalHandler;
import vswe.stevesfactory.api.network.ICable;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.setup.ModBlocks;
import vswe.stevesfactory.utils.NetworkHelper;

public class RedstoneEmitterTileEntity
extends TileEntity
implements ICable {
    private LazyOptional<RedstoneSignalHandler> redstoneDown = LazyOptional.of(this::createSignalHandler);
    private LazyOptional<RedstoneSignalHandler> redstoneUp = LazyOptional.of(this::createSignalHandler);
    private LazyOptional<RedstoneSignalHandler> redstoneNorth = LazyOptional.of(this::createSignalHandler);
    private LazyOptional<RedstoneSignalHandler> redstoneSouth = LazyOptional.of(this::createSignalHandler);
    private LazyOptional<RedstoneSignalHandler> redstoneWest = LazyOptional.of(this::createSignalHandler);
    private LazyOptional<RedstoneSignalHandler> redstoneEast = LazyOptional.of(this::createSignalHandler);

    public RedstoneEmitterTileEntity() {
        super((TileEntityType)ModBlocks.redstoneEmitterTileEntity.get());
    }

    private RedstoneSignalHandler createSignalHandler() {
        assert (this.field_145850_b != null);
        return new RedstoneSignalHandler(() -> this.field_145850_b.func_195592_c(this.field_174879_c, (Block)ModBlocks.redstoneEmitterBlock.get()));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityRedstone.REDSTONE_CAPABILITY) {
            if (side == null) {
                return this.redstoneUp.cast();
            }
            switch (side) {
                case DOWN: {
                    return this.redstoneDown.cast();
                }
                case UP: {
                    return this.redstoneUp.cast();
                }
                case NORTH: {
                    return this.redstoneNorth.cast();
                }
                case SOUTH: {
                    return this.redstoneSouth.cast();
                }
                case WEST: {
                    return this.redstoneWest.cast();
                }
                case EAST: {
                    return this.redstoneEast.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        ((RedstoneSignalHandler)this.redstoneDown.orElseThrow(RuntimeException::new)).read(compound.func_74775_l("Down"));
        ((RedstoneSignalHandler)this.redstoneUp.orElseThrow(RuntimeException::new)).read(compound.func_74775_l("Up"));
        ((RedstoneSignalHandler)this.redstoneNorth.orElseThrow(RuntimeException::new)).read(compound.func_74775_l("North"));
        ((RedstoneSignalHandler)this.redstoneSouth.orElseThrow(RuntimeException::new)).read(compound.func_74775_l("South"));
        ((RedstoneSignalHandler)this.redstoneWest.orElseThrow(RuntimeException::new)).read(compound.func_74775_l("West"));
        ((RedstoneSignalHandler)this.redstoneEast.orElseThrow(RuntimeException::new)).read(compound.func_74775_l("East"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("Down", (INBT)((RedstoneSignalHandler)this.redstoneDown.orElseThrow(RuntimeException::new)).write());
        compound.func_218657_a("Up", (INBT)((RedstoneSignalHandler)this.redstoneUp.orElseThrow(RuntimeException::new)).write());
        compound.func_218657_a("North", (INBT)((RedstoneSignalHandler)this.redstoneNorth.orElseThrow(RuntimeException::new)).write());
        compound.func_218657_a("South", (INBT)((RedstoneSignalHandler)this.redstoneSouth.orElseThrow(RuntimeException::new)).write());
        compound.func_218657_a("West", (INBT)((RedstoneSignalHandler)this.redstoneWest.orElseThrow(RuntimeException::new)).write());
        compound.func_218657_a("East", (INBT)((RedstoneSignalHandler)this.redstoneEast.orElseThrow(RuntimeException::new)).write());
        return super.func_189515_b(compound);
    }

    protected void invalidateCaps() {
        this.redstoneDown.invalidate();
        this.redstoneUp.invalidate();
        this.redstoneNorth.invalidate();
        this.redstoneSouth.invalidate();
        this.redstoneWest.invalidate();
        this.redstoneEast.invalidate();
        super.invalidateCaps();
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public boolean isCable() {
        return (Boolean)Config.COMMON.isRedstoneEmitterBlockCables.get();
    }

    @Override
    public void addLinksFor(INetworkController controller) {
        NetworkHelper.updateLinksFor(controller, this);
    }
}

